/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.jfreechart.Colour;
import org.exist.xquery.modules.jfreechart.Configuration;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xml.DatasetReader;
import org.jfree.util.TableOrder;

public class JFreeChartFactory {
    private static final Logger logger = Logger.getLogger(JFreeChartFactory.class);

    public static JFreeChart createJFreeChart(String chartType, Configuration conf, InputStream is) throws XPathException {
        logger.debug((Object)("Generating " + chartType));
        CategoryDataset categoryDataset = null;
        PieDataset pieDataset = null;
        try {
            if ("PieChart".equals(chartType) || "PieChart3D".equals(chartType) || "RingChart".equals(chartType)) {
                logger.debug((Object)"Reading XML PieDataset");
                pieDataset = DatasetReader.readPieDatasetFromXML((InputStream)is);
            } else {
                logger.debug((Object)"Reading XML CategoryDataset");
                categoryDataset = DatasetReader.readCategoryDatasetFromXML((InputStream)is);
            }
        }
        catch (IOException ex) {
            throw new XPathException(ex.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        JFreeChart chart = null;
        if ("AreaChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createAreaChart((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("BarChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createBarChart((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("BarChart3D".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createBarChart3D((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("LineChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createLineChart((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("LineChart3D".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createLineChart3D((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("MultiplePieChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createMultiplePieChart((String)conf.getTitle(), (CategoryDataset)categoryDataset, (TableOrder)conf.getOrder(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setPieChartParameters(chart, conf);
        } else if ("MultiplePieChart3D".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createMultiplePieChart3D((String)conf.getTitle(), (CategoryDataset)categoryDataset, (TableOrder)conf.getOrder(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setPieChartParameters(chart, conf);
        } else if ("PieChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createPieChart((String)conf.getTitle(), (PieDataset)pieDataset, (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setPieChartParameters(chart, conf);
        } else if ("PieChart3D".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createPieChart3D((String)conf.getTitle(), (PieDataset)pieDataset, (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setPieChartParameters(chart, conf);
        } else if ("RingChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createRingChart((String)conf.getTitle(), (PieDataset)pieDataset, (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setPieChartParameters(chart, conf);
        } else if ("StackedAreaChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createStackedAreaChart((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("StackedBarChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createStackedBarChart((String)conf.getTitle(), (String)conf.getDomainAxisLabel(), (String)conf.getRangeAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("StackedBarChart3D".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createStackedBarChart3D((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else if ("WaterfallChart".equalsIgnoreCase(chartType)) {
            chart = ChartFactory.createWaterfallChart((String)conf.getTitle(), (String)conf.getCategoryAxisLabel(), (String)conf.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)conf.getOrientation(), (boolean)conf.isGenerateLegend(), (boolean)conf.isGenerateTooltips(), (boolean)conf.isGenerateUrls());
            JFreeChartFactory.setCategoryChartParameters(chart, conf);
        } else {
            logger.error((Object)"Illegal chartype. Choose one of AreaChart BarChart BarChart3D LineChart LineChart3D MultiplePieChart MultiplePieChart3D PieChart PieChart3D RingChart StackedAreaChart StackedBarChart StackedBarChart3D WaterfallChart");
        }
        JFreeChartFactory.setCommonParameters(chart, conf);
        return chart;
    }

    private static void setCategoryChartParameters(JFreeChart chart, Configuration config) throws XPathException {
        JFreeChartFactory.setCategoryRange(chart, config);
        JFreeChartFactory.setCategoryItemLabelGenerator(chart, config);
        JFreeChartFactory.setSeriesColors(chart, config);
        JFreeChartFactory.setAxisColors(chart, config);
    }

    private static void setCategoryRange(JFreeChart chart, Configuration config) {
        Double rangeLowerBound = config.getRangeLowerBound();
        Double rangeUpperBound = config.getRangeUpperBound();
        if (rangeLowerBound != null) {
            ((CategoryPlot)chart.getPlot()).getRangeAxis().setLowerBound(rangeLowerBound.doubleValue());
        }
        if (rangeUpperBound != null) {
            ((CategoryPlot)chart.getPlot()).getRangeAxis().setUpperBound(rangeUpperBound.doubleValue());
        }
    }

    private static void setCategoryItemLabelGenerator(JFreeChart chart, Configuration config) throws XPathException {
        String className = config.getCategoryItemLabelGeneratorClass();
        CategoryItemLabelGenerator generator = null;
        if (className != null) {
            try {
                Class<?> generatorClass = Class.forName(className);
                Class[] argsClass = new Class[]{String.class, NumberFormat.class};
                String param = config.getCategoryItemLabelGeneratorParameter();
                DecimalFormat fmt = new DecimalFormat(config.getCategoryItemLabelGeneratorNumberFormat());
                Object[] args = new Object[]{param, fmt};
                Constructor<?> argsConstructor = generatorClass.getConstructor(argsClass);
                generator = (CategoryItemLabelGenerator)argsConstructor.newInstance(args);
            }
            catch (Exception e) {
                throw new XPathException("Cannot instantiate CategoryItemLabelGeneratorClass: " + className + ", exception: " + e);
            }
            CategoryItemRenderer renderer = ((CategoryPlot)chart.getPlot()).getRenderer();
            renderer.setBaseItemLabelGenerator(generator);
            renderer.setItemLabelsVisible(true);
        }
    }

    private static void setSeriesColors(JFreeChart chart, Configuration config) {
        String seriesColors = config.getSeriesColors();
        if (seriesColors != null) {
            CategoryItemRenderer renderer = ((CategoryPlot)chart.getPlot()).getRenderer();
            StringTokenizer st = new StringTokenizer(seriesColors, ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String colorName = st.nextToken().trim();
                Color color = null;
                try {
                    color = Colour.getColor(colorName);
                }
                catch (XPathException e) {
                    // empty catch block
                }
                if (color != null) {
                    renderer.setSeriesPaint(i, (Paint)color);
                } else {
                    logger.warn((Object)("Invalid colour name or hex value specified for SeriesColors: " + colorName + ", default colour will be used instead."));
                }
                ++i;
            }
        }
    }

    private static void setAxisColors(JFreeChart chart, Configuration config) {
        Color categoryAxisColor = config.getCategoryAxisColor();
        Color valueAxisColor = config.getValueAxisColor();
        if (categoryAxisColor != null) {
            ((CategoryPlot)chart.getPlot()).getDomainAxis().setLabelPaint((Paint)categoryAxisColor);
        }
        if (valueAxisColor != null) {
            ((CategoryPlot)chart.getPlot()).getRangeAxis().setLabelPaint((Paint)valueAxisColor);
        }
    }

    private static void setPieChartParameters(JFreeChart chart, Configuration config) {
        JFreeChartFactory.setPieSectionLabel(chart, config);
        JFreeChartFactory.setSectionColors(chart, config);
    }

    private static void setPieSectionLabel(JFreeChart chart, Configuration config) {
        String pieSectionLabel = config.getPieSectionLabel();
        String pieSectionNumberFormat = config.getPieSectionNumberFormat();
        String pieSectionPercentFormat = config.getPieSectionPercentFormat();
        if (pieSectionLabel != null) {
            ((PiePlot)chart.getPlot()).setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(pieSectionLabel, (NumberFormat)new DecimalFormat(pieSectionNumberFormat), (NumberFormat)new DecimalFormat(pieSectionPercentFormat)));
        }
    }

    private static void setSectionColors(JFreeChart chart, Configuration config) {
        String sectionColors = config.getSectionColors();
        String sectionColorsDelimiter = config.getSectionColorsDelimiter();
        if (sectionColors != null) {
            PiePlot plot = (PiePlot)chart.getPlot();
            StringTokenizer st = new StringTokenizer(sectionColors, sectionColorsDelimiter);
            while (st.hasMoreTokens()) {
                String sectionName = st.nextToken().trim();
                String colorName = "";
                if (st.hasMoreTokens()) {
                    colorName = st.nextToken().trim();
                }
                Color color = null;
                try {
                    color = Colour.getColor(colorName);
                }
                catch (XPathException e) {
                    // empty catch block
                }
                if (color != null) {
                    plot.setSectionPaint((Comparable)((Object)sectionName), (Paint)color);
                    continue;
                }
                logger.warn((Object)("Invalid colour name or hex value specified for SectionColors: " + colorName + ", default colour will be used instead. Section Name: " + sectionName));
            }
        }
    }

    private static void setCommonParameters(JFreeChart chart, Configuration config) {
        JFreeChartFactory.setColors(chart, config);
    }

    private static void setColors(JFreeChart chart, Configuration config) {
        Color titleColor = config.getTitleColor();
        Color chartBackgroundColor = config.getChartBackgroundColor();
        Color plotBackgroundColor = config.getPlotBackgroundColor();
        if (titleColor != null) {
            chart.getTitle().setPaint((Paint)titleColor);
        }
        if (chartBackgroundColor != null) {
            chart.setBackgroundPaint((Paint)chartBackgroundColor);
        }
        if (plotBackgroundColor != null) {
            chart.getPlot().setBackgroundPaint((Paint)plotBackgroundColor);
        }
    }
}

