/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jfreechart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.storage.serializers.Serializer;
import org.exist.validation.internal.node.NodeInputStream;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.modules.jfreechart.Configuration;
import org.exist.xquery.modules.jfreechart.JFreeChartFactory;
import org.exist.xquery.modules.jfreechart.render.Renderer;
import org.exist.xquery.modules.jfreechart.render.RendererFactory;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.jfree.chart.JFreeChart;

public class JFreeCharting
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(JFreeCharting.class);
    private static final String function1Txt = "Render chart using JFreechart. Check documentation on http://www.jfree.org/jfreechart/ for details about chart types, parameters and data structures.";
    private static final String function2Txt = "Render chart using JFreechart. Check documentation on http://www.jfree.org/jfreechart/ for details about chart types, parameters and data structures. Output is directly streamed into the servlet output stream.";
    private static final String chartText = "The type of chart to render.  Supported chart types: LineChart, LineChart3D, MultiplePieChart, MultiplePieChart3D, PieChart, PieChart3D, RingChart, StackedAreaChart, StackedBarChart, StackedBarChart3D, WaterfallChart.";
    private static final String parametersText = "The configuration for the chart.  The configuration should be supplied as follows: <configuration><param1>Value1</param1><param2>Value2</param2>/<configuration>.  Supported parameters: width height title categoryAxisLabel timeAxisLabel valueAxisLabel domainAxisLabel rangeAxisLabel pieSectionLabel pieSectionNumberFormat pieSectionPercentFormat orientation titleColor chartBackgroundColor plotBackgroundColor rangeLowerBound rangeUpperrBound categoryItemLabelGeneratorClass seriesColors sectionColors sectionColorsDelimiter categoryAxisColor valueAxisColortimeAxisColor order legend tooltips urls.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("render", "http://exist-db.org/xquery/jfreechart", "jfreechart"), "Render chart using JFreechart. Check documentation on http://www.jfree.org/jfreechart/ for details about chart types, parameters and data structures.", new SequenceType[]{new FunctionParameterSequenceType("chart-type", 22, 2, "The type of chart to render.  Supported chart types: LineChart, LineChart3D, MultiplePieChart, MultiplePieChart3D, PieChart, PieChart3D, RingChart, StackedAreaChart, StackedBarChart, StackedBarChart3D, WaterfallChart."), new FunctionParameterSequenceType("configuration", -1, 2, "The configuration for the chart.  The configuration should be supplied as follows: <configuration><param1>Value1</param1><param2>Value2</param2>/<configuration>.  Supported parameters: width height title categoryAxisLabel timeAxisLabel valueAxisLabel domainAxisLabel rangeAxisLabel pieSectionLabel pieSectionNumberFormat pieSectionPercentFormat orientation titleColor chartBackgroundColor plotBackgroundColor rangeLowerBound rangeUpperrBound categoryItemLabelGeneratorClass seriesColors sectionColors sectionColorsDelimiter categoryAxisColor valueAxisColortimeAxisColor order legend tooltips urls."), new FunctionParameterSequenceType("data", -1, 2, "The CategoryDataset or PieDataset, supplied as JFreechart XML.")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "the generated PNG image file")), new FunctionSignature(new QName("stream-render", "http://exist-db.org/xquery/jfreechart", "jfreechart"), "Render chart using JFreechart. Check documentation on http://www.jfree.org/jfreechart/ for details about chart types, parameters and data structures. Output is directly streamed into the servlet output stream.", new SequenceType[]{new FunctionParameterSequenceType("chart-type", 22, 2, "The type of chart to render.  Supported chart types: LineChart, LineChart3D, MultiplePieChart, MultiplePieChart3D, PieChart, PieChart3D, RingChart, StackedAreaChart, StackedBarChart, StackedBarChart3D, WaterfallChart."), new FunctionParameterSequenceType("configuration", -1, 2, "The configuration for the chart.  The configuration should be supplied as follows: <configuration><param1>Value1</param1><param2>Value2</param2>/<configuration>.  Supported parameters: width height title categoryAxisLabel timeAxisLabel valueAxisLabel domainAxisLabel rangeAxisLabel pieSectionLabel pieSectionNumberFormat pieSectionPercentFormat orientation titleColor chartBackgroundColor plotBackgroundColor rangeLowerBound rangeUpperrBound categoryItemLabelGeneratorClass seriesColors sectionColors sectionColorsDelimiter categoryAxisColor valueAxisColortimeAxisColor order legend tooltips urls."), new FunctionParameterSequenceType("data", -1, 2, "The CategoryDataset or PieDataset, supplied as JFreechart XML.")}, new SequenceType(10, 1))};

    public JFreeCharting(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].isEmpty() || args[2].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            String chartType = args[0].getStringValue();
            Configuration config = new Configuration();
            config.parse(((NodeValue)args[1].itemAt(0)).getNode());
            Serializer serializer = this.context.getBroker().getSerializer();
            NodeValue node = (NodeValue)args[2].itemAt(0);
            NodeInputStream is = new NodeInputStream(serializer, node);
            JFreeChart chart = null;
            try {
                chart = JFreeChartFactory.createJFreeChart(chartType, config, (InputStream)is);
            }
            catch (IllegalArgumentException ex) {
                throw new XPathException((Expression)this, ex.getMessage());
            }
            if (chart == null) {
                throw new XPathException((Expression)this, "Unable to create chart '" + chartType + "'");
            }
            Renderer renderer = RendererFactory.getRenderer(config.getImageType());
            if (this.isCalledAs("render")) {
                byte[] image = renderer.render(chart, config);
                return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(image));
            }
            ResponseWrapper response = this.getResponseWrapper(this.context);
            this.writeToResponseWrapper(config, response, chart, renderer);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new XPathException((Expression)this, ex.getMessage());
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private ResponseWrapper getResponseWrapper(XQueryContext context) throws XPathException {
        ResponseModule myModule = (ResponseModule)context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException((Expression)this, "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException((Expression)this, signatures[1].toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        return response;
    }

    private void writeToResponseWrapper(Configuration config, ResponseWrapper response, JFreeChart chart, Renderer renderer) throws XPathException {
        OutputStream os = null;
        try {
            response.setContentType(renderer.getContentType());
            String contentEncoding = renderer.getContentEncoding();
            if (contentEncoding != null) {
                response.setHeader("Content-Encoding", contentEncoding);
            }
            os = response.getOutputStream();
            renderer.render(chart, config, os);
        }
        catch (IOException ex) {
            try {
                LOG.error((Object)ex);
                throw new XPathException((Expression)this, "IO issue while serializing image. " + ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

