/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jfreechart.render;

import org.apache.log4j.Logger;
import org.exist.xquery.modules.jfreechart.render.PNGrenderer;
import org.exist.xquery.modules.jfreechart.render.Renderer;

public class RendererFactory {
    private static final Logger LOG = Logger.getLogger(RendererFactory.class);

    public static Renderer getRenderer(String type) {
        Renderer retVal = null;
        if (type == null) {
            type = "png";
        }
        type = type.toUpperCase();
        try {
            String renderer = "org.exist.xquery.modules.jfreechart.render." + type + "renderer";
            Class<?> clazz = Class.forName(renderer);
            Object obj = clazz.newInstance();
            if (obj instanceof Renderer) {
                retVal = (Renderer)obj;
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)ex.getMessage());
        }
        catch (InstantiationException ex) {
            LOG.error((Object)ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            LOG.error((Object)ex.getMessage());
        }
        if (retVal == null) {
            LOG.debug((Object)"Fall back to default renderer");
            retVal = new PNGrenderer();
        }
        return retVal;
    }
}

