/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.jndi.JNDIModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class CloseContextFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(CloseContextFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("close-context", "http://exist-db.org/xquery/jndi", "jndi"), "Closes a JNDI Context", new SequenceType[]{new FunctionParameterSequenceType("directory-context", 31, 2, "The directory context handle from a jndi:get-dir-context() call")}, new SequenceType(11, 1))};

    public CloseContextFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        long ctxID = ((IntegerValue)args[0].itemAt(0)).getLong();
        JNDIModule.closeJNDIContext(this.context, ctxID);
        return Sequence.EMPTY_SEQUENCE;
    }
}

