/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.jndi.JNDIModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class DeleteFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(DeleteFunction.class);
    public static final String DSML_NAMESPACE = "http://www.dsml.org/DSML";
    public static final String DSML_PREFIX = "dsml";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("delete", "http://exist-db.org/xquery/jndi", "jndi"), "Delete a JNDI Directory entry.", new SequenceType[]{new FunctionParameterSequenceType("directory-context", 31, 2, "The directory context handle from a jndi:get-dir-context() call"), new FunctionParameterSequenceType("dn", 22, 2, "The Distinguished Name")}, new SequenceType(11, 1))};

    public DeleteFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!args[0].isEmpty() && !args[1].isEmpty()) {
            String dn = args[1].getStringValue();
            try {
                long ctxID = ((IntegerValue)args[0].itemAt(0)).getLong();
                DirContext ctx = (DirContext)JNDIModule.retrieveJNDIContext(this.context, ctxID);
                if (ctx == null) {
                    logger.error((Object)("jndi:delete() - Invalid JNDI context handle provided: " + ctxID));
                } else {
                    ctx.destroySubcontext(dn);
                }
            }
            catch (NamingException ne) {
                logger.error((Object)("jndi:delete() Delete failed for dn [" + dn + "]: "), (Throwable)ne);
                throw new XPathException((Expression)this, "jndi:delete() Delete failed for dn [" + dn + "]: ", (Throwable)ne);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

