/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.jndi.JNDIModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Node;

public class GetDirContextFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(GetDirContextFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-dir-context", "http://exist-db.org/xquery/jndi", "jndi"), "Opens a JNDI Directory Context.", new SequenceType[]{new FunctionParameterSequenceType("properties", 1, 3, "The JNDI Directory Context environment properties to be set in the form <properties><property name=\"\" value=\"\"/></properties>.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "the directory context handle"))};

    public GetDirContextFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            InitialDirContext dirCtx = null;
            Properties env = ModuleUtils.parseProperties((Node)((NodeValue)args[0].itemAt(0)).getNode());
            dirCtx = new InitialDirContext(env);
            return new IntegerValue(JNDIModule.storeJNDIContext(this.context, dirCtx));
        }
        catch (NamingException ne) {
            logger.error((Object)"jndi:get-dir-context() Cannot get JNDI directory context: ", (Throwable)ne);
            throw new XPathException((Expression)this, "jndi:get-dir-context() Cannot get JNDI directory context: " + ne);
        }
    }
}

