/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.jndi.CloseContextFunction;
import org.exist.xquery.modules.jndi.CreateFunction;
import org.exist.xquery.modules.jndi.DeleteFunction;
import org.exist.xquery.modules.jndi.GetDirContextFunction;
import org.exist.xquery.modules.jndi.ModifyFunction;
import org.exist.xquery.modules.jndi.RenameFunction;
import org.exist.xquery.modules.jndi.SearchFunction;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JNDIModule
extends AbstractInternalModule {
    protected static final Logger LOG = Logger.getLogger(JNDIModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/jndi";
    public static final String PREFIX = "jndi";
    public static final String INCLUSION_DATE = "2008-12-04";
    public static final String RELEASED_IN_VERSION = "eXist-1.4";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GetDirContextFunction.signatures[0], GetDirContextFunction.class), new FunctionDef(CloseContextFunction.signatures[0], CloseContextFunction.class), new FunctionDef(SearchFunction.signatures[0], SearchFunction.class), new FunctionDef(SearchFunction.signatures[1], SearchFunction.class), new FunctionDef(CreateFunction.signatures[0], CreateFunction.class), new FunctionDef(DeleteFunction.signatures[0], DeleteFunction.class), new FunctionDef(RenameFunction.signatures[0], RenameFunction.class), new FunctionDef(ModifyFunction.signatures[0], ModifyFunction.class)};
    public static final String JNDICONTEXTS_VARIABLE = "_eXist_jndi_contexts";
    private static long currentContextID = System.currentTimeMillis();

    public JNDIModule(Map<String, List<? extends Object>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing JNDI queries against Directories, returning XML representations of the results.";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    public static final Context retrieveJNDIContext(XQueryContext context, long ctxID) {
        Context jndiContext = null;
        HashMap contexts = (HashMap)context.getXQueryContextVar(JNDICONTEXTS_VARIABLE);
        if (contexts != null) {
            jndiContext = (Context)contexts.get(new Long(ctxID));
        }
        return jndiContext;
    }

    public static final synchronized long storeJNDIContext(XQueryContext context, Context jndiContext) {
        HashMap<Long, Context> contexts = (HashMap<Long, Context>)context.getXQueryContextVar(JNDICONTEXTS_VARIABLE);
        if (contexts == null) {
            contexts = new HashMap<Long, Context>();
        }
        long ctxID = JNDIModule.getID();
        contexts.put(new Long(ctxID), jndiContext);
        context.setXQueryContextVar(JNDICONTEXTS_VARIABLE, contexts);
        return ctxID;
    }

    public static final void closeJNDIContext(XQueryContext context, long ctxID) {
        HashMap contexts = (HashMap)context.getXQueryContextVar(JNDICONTEXTS_VARIABLE);
        JNDIModule.closeJNDIContext(context, ctxID, contexts);
        context.setXQueryContextVar(JNDICONTEXTS_VARIABLE, (Object)contexts);
    }

    private static final void closeJNDIContext(XQueryContext context, long ctxID, HashMap contexts) {
        Context ctx = null;
        if (contexts != null && (ctx = (Context)contexts.get(new Long(ctxID))) != null) {
            try {
                ctx.close();
                contexts.remove(ctxID);
            }
            catch (NamingException ne) {
                LOG.error((Object)"Unable to close JNDI Context", (Throwable)ne);
            }
        }
    }

    private static final void closeAllJNDIContexts(XQueryContext xqueryContext) {
        HashMap contexts = (HashMap)xqueryContext.getXQueryContextVar(JNDICONTEXTS_VARIABLE);
        if (contexts != null) {
            Set keys = contexts.keySet();
            for (Long ctxID : keys) {
                JNDIModule.closeJNDIContext(xqueryContext, ctxID, contexts);
            }
            xqueryContext.setXQueryContextVar(JNDICONTEXTS_VARIABLE, (Object)contexts);
        }
    }

    private static synchronized long getID() {
        return currentContextID++;
    }

    public void reset(XQueryContext xqueryContext) {
        super.reset(xqueryContext);
        JNDIModule.closeAllJNDIContexts(xqueryContext);
    }

    protected static BasicAttributes parseAttributes(Sequence arg) {
        Node container;
        BasicAttributes attributes = new BasicAttributes();
        if (!arg.isEmpty() && (container = ((NodeValue)arg.itemAt(0)).getNode()) != null && container.getNodeType() == 1) {
            NodeList attrs = ((Element)container).getElementsByTagName("attribute");
            for (int i = 0; i < attrs.getLength(); ++i) {
                Element attr = (Element)attrs.item(i);
                String name = attr.getAttribute("name");
                String value = attr.getAttribute("value");
                String ordered = attr.getAttribute("ordered");
                if (name != null && value != null) {
                    Attribute existingAttr = attributes.get(name);
                    if (existingAttr != null) {
                        existingAttr.add(value);
                        continue;
                    }
                    attributes.put(new BasicAttribute(name, value, ordered != null && ordered.equalsIgnoreCase("true")));
                    continue;
                }
                LOG.warn((Object)"Name or value attribute missing for attribute");
            }
        }
        return attributes;
    }
}

