/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.jndi.JNDIModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModifyFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(ModifyFunction.class);
    public static final String DSML_NAMESPACE = "http://www.dsml.org/DSML";
    public static final String DSML_PREFIX = "dsml";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("modify", "http://exist-db.org/xquery/jndi", "jndi"), "Modify a JNDI Directory entry.", new SequenceType[]{new FunctionParameterSequenceType("directory-context", 31, 2, "The directory context handle from a jndi:get-dir-context() call"), new FunctionParameterSequenceType("dn", 22, 2, "The Distinguished Name"), new FunctionParameterSequenceType("attributes", 1, 2, "The entry attributes to be set in the form <attributes><attribute name=\"\" value=\"\" operation=\"add | replace | remove\"/></attributes>.  You can also optionally specify ordered=\"true\" for an attribute.")}, new SequenceType(11, 1))};

    public ModifyFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!args[0].isEmpty() && !args[1].isEmpty()) {
            String dn = args[1].getStringValue();
            try {
                long ctxID = ((IntegerValue)args[0].itemAt(0)).getLong();
                DirContext ctx = (DirContext)JNDIModule.retrieveJNDIContext(this.context, ctxID);
                if (ctx == null) {
                    logger.error((Object)("jndi:modify() - Invalid JNDI context handle provided: " + ctxID));
                } else {
                    ModificationItem[] items = this.parseAttributes(args[2]);
                    if (items.length > 0) {
                        ctx.modifyAttributes(dn, items);
                    }
                }
            }
            catch (NamingException ne) {
                logger.error((Object)("jndi:modify() Modify failed for dn [" + dn + "]: "), (Throwable)ne);
                throw new XPathException((Expression)this, "jndi:modify() Modify failed for dn [" + dn + "]: " + ne);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private ModificationItem[] parseAttributes(Sequence arg) throws XPathException {
        Node container;
        ArrayList<ModificationItem> items = new ArrayList<ModificationItem>();
        ModificationItem[] mi = new ModificationItem[1];
        if (!arg.isEmpty() && (container = ((NodeValue)arg.itemAt(0)).getNode()) != null && container.getNodeType() == 1) {
            NodeList attrs = ((Element)container).getElementsByTagName("attribute");
            for (int i = 0; i < attrs.getLength(); ++i) {
                Element attr = (Element)attrs.item(i);
                String name = attr.getAttribute("name");
                String value = attr.getAttribute("value");
                String op = attr.getAttribute("operation");
                String ordered = attr.getAttribute("ordered");
                if (name != null && value != null && op != null) {
                    int opCode = 0;
                    if (op.equalsIgnoreCase("add")) {
                        opCode = 1;
                    } else if (op.equalsIgnoreCase("replace")) {
                        opCode = 2;
                    } else if (op.equalsIgnoreCase("remove")) {
                        opCode = 3;
                    }
                    if (opCode == 0) {
                        logger.error((Object)("jndi:modify() - Invalid operation code: [" + op + "]"));
                        throw new XPathException((Expression)this, "jndi:modify() - Invalid operation code: [" + op + "]");
                    }
                    Attribute existingAttr = null;
                    for (int j = items.size() - 1; j >= 0; --j) {
                        ModificationItem item = (ModificationItem)items.get(j);
                        if (!name.equals(item.getAttribute().getID())) continue;
                        if (item.getModificationOp() != opCode || opCode == 3) break;
                        existingAttr = item.getAttribute();
                        break;
                    }
                    if (existingAttr != null) {
                        existingAttr.add(value);
                        continue;
                    }
                    items.add(new ModificationItem(opCode, new BasicAttribute(name, value, ordered != null && ordered.equalsIgnoreCase("true"))));
                    continue;
                }
                logger.warn((Object)"Name, value or operation attribute missing for attribute");
            }
        }
        return items.toArray(mi);
    }
}

