/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jndi;

import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.jndi.JNDIModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SearchFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(SearchFunction.class);
    public static final String DSML_NAMESPACE = "http://www.dsml.org/DSML";
    public static final String DSML_PREFIX = "dsml";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("search", "http://exist-db.org/xquery/jndi", "jndi"), "Searches a JNDI Directory by attributes.", new SequenceType[]{new FunctionParameterSequenceType("directory-context", 31, 2, "The directory context handle from a jndi:get-dir-context() call"), new FunctionParameterSequenceType("dn", 22, 2, "The Distinguished Name"), new FunctionParameterSequenceType("search-attributes", 1, 2, "The search attributes in the form <attributes><attribute name=\"\" value=\"\"/></attributes>.")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the search results in DSML format")), new FunctionSignature(new QName("search", "http://exist-db.org/xquery/jndi", "jndi"), "Searches a JNDI Directory by filter.", new SequenceType[]{new FunctionParameterSequenceType("directory-context", 31, 2, "The directory context handle from a jndi:get-dir-context() call"), new FunctionParameterSequenceType("dn", 22, 2, "The Distinguished Name"), new FunctionParameterSequenceType("filter", 22, 2, "The filter.  The format and interpretation of filter follows RFC 2254 with the following interpretations for 'attr' and 'value'  mentioned in the RFC. 'attr' is the attribute's identifier. 'value' is the string represention the attribute's value. The translation of this string representation into the attribute's value is directory-specific. "), new FunctionParameterSequenceType("scope", 22, 2, "The scope, which has a value of 'object', 'onelevel' or 'subtree'")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the search results in DSML format"))};

    public SearchFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence xmlResult = Sequence.EMPTY_SEQUENCE;
        if (!args[0].isEmpty() && !args[1].isEmpty()) {
            String dn = args[1].getStringValue();
            try {
                long ctxID = ((IntegerValue)args[0].itemAt(0)).getLong();
                DirContext ctx = (DirContext)JNDIModule.retrieveJNDIContext(this.context, ctxID);
                if (ctx == null) {
                    logger.error((Object)("jndi:search() - Invalid JNDI context handle provided: " + ctxID));
                } else {
                    NamingEnumeration<SearchResult> results = null;
                    if (args.length == 3) {
                        BasicAttributes attributes = JNDIModule.parseAttributes(args[2]);
                        results = ctx.search(dn, (Attributes)attributes);
                    } else {
                        int scopeCode = 0;
                        String filter = args[2].getStringValue();
                        String scope = args[3].getStringValue();
                        if (scope.equalsIgnoreCase("object")) {
                            scopeCode = 0;
                        } else if (scope.equalsIgnoreCase("onelevel")) {
                            scopeCode = 1;
                        } else if (scope.equalsIgnoreCase("subtree")) {
                            scopeCode = 2;
                        }
                        results = ctx.search(dn, filter, new SearchControls(scopeCode, 0L, 0, null, false, false));
                    }
                    xmlResult = this.renderSearchResultsAsDSML(results, dn);
                }
            }
            catch (NameNotFoundException nf) {
                logger.warn((Object)("jndi:search() Not found for dn [" + dn + "]"), (Throwable)nf);
            }
            catch (NamingException ne) {
                logger.error((Object)("jndi:search() Search failed for dn [" + dn + "]: "), (Throwable)ne);
                throw new XPathException((Expression)this, "jndi:search() Search failed for dn [" + dn + "]: " + ne);
            }
        }
        return xmlResult;
    }

    private Sequence renderSearchResultsAsDSML(NamingEnumeration results, String dn) throws NamingException {
        Sequence xmlResult = Sequence.EMPTY_SEQUENCE;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName(DSML_PREFIX, DSML_NAMESPACE, DSML_PREFIX), null);
        builder.addAttribute(new QName("dn", null, null), dn);
        builder.startElement(new QName("directory-entries", DSML_NAMESPACE, DSML_PREFIX), null);
        while (results.hasMore()) {
            SearchResult result = (SearchResult)results.next();
            builder.startElement(new QName("entry", DSML_NAMESPACE, DSML_PREFIX), null);
            builder.addAttribute(new QName("dn", null, null), result.getName());
            Attribute ocattr = result.getAttributes().get("objectClass");
            if (ocattr != null) {
                builder.startElement(new QName("objectclass", DSML_NAMESPACE, DSML_PREFIX), null);
                for (int i = 0; i < ocattr.size(); ++i) {
                    Object value = ocattr.get(i);
                    builder.startElement(new QName("oc-value", DSML_NAMESPACE, DSML_PREFIX), null);
                    builder.characters((CharSequence)value.toString());
                    builder.endElement();
                }
                builder.endElement();
            }
            NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
            while (attrs.hasMore()) {
                Attribute attr = attrs.next();
                String name = attr.getID();
                if (name.equals("objectClass")) continue;
                builder.startElement(new QName("attr", DSML_NAMESPACE, DSML_PREFIX), null);
                builder.addAttribute(new QName("name", null, null), name);
                for (int i = 0; i < attr.size(); ++i) {
                    Object value = attr.get(i);
                    builder.startElement(new QName("value", DSML_NAMESPACE, DSML_PREFIX), null);
                    if (name.equals("userPassword")) {
                        builder.characters((CharSequence)new String((byte[])value));
                    } else {
                        builder.characters((CharSequence)value.toString());
                    }
                    builder.endElement();
                }
                builder.endElement();
            }
            builder.endElement();
        }
        builder.endElement();
        builder.endElement();
        xmlResult = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResult;
    }
}

