/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class MailFolderFunctions
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(MailFolderFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-mail-folder", "http://exist-db.org/xquery/mail", "mail"), "Opens a mail folder.", new SequenceType[]{new FunctionParameterSequenceType("mail-store-handle", 31, 2, "The mail store handle retrieved from mail:get-mail-store()"), new FunctionParameterSequenceType("foldername", 22, 2, "The name of the folder to open")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the folder handle.")), new FunctionSignature(new QName("close-mail-folder", "http://exist-db.org/xquery/mail", "mail"), "Closes a mail folder.", new SequenceType[]{new FunctionParameterSequenceType("mail-folder-handle", 31, 2, "The mail folder handle retrieved from mail:get-mail-folder()"), new FunctionParameterSequenceType("expunge", 23, 2, "A boolean that specifies whether to expunge the folder on close.")}, new SequenceType(11, 1))};

    public MailFolderFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("get-mail-folder")) {
            Sequence mailFolder = this.getMailFolder(args, contextSequence);
            return mailFolder;
        }
        if (this.isCalledAs("close-mail-folder")) {
            Sequence closeMailFolder = this.closeMailFolder(args, contextSequence);
            return closeMailFolder;
        }
        throw new XPathException((Expression)this, "Invalid function name");
    }

    private Sequence getMailFolder(Sequence[] args, Sequence contextSequence) throws XPathException {
        Folder folder;
        if (args[0].isEmpty() || args[1].isEmpty()) {
            throw new XPathException((Expression)this, "Store handle and/or folder name not specified");
        }
        long storeHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Store store = MailModule.retrieveStore(this.context, storeHandle);
        if (store == null) {
            throw new XPathException((Expression)this, "Invalid Store handle specified");
        }
        String name = args[1].getStringValue();
        try {
            folder = store.getFolder(name);
            folder.open(2);
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to open mail folder", (Throwable)me);
        }
        return new IntegerValue(MailModule.storeFolder(this.context, folder));
    }

    private Sequence closeMailFolder(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Folder handle not specified");
        }
        boolean expunge = ((BooleanValue)args[1].itemAt(0)).effectiveBooleanValue();
        long folderHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Folder folder = MailModule.retrieveFolder(this.context, folderHandle);
        if (folder == null) {
            throw new XPathException((Expression)this, "Invalid Folder handle specified");
        }
        try {
            folder.close(expunge);
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to close mail folder", (Throwable)me);
        }
        finally {
            MailModule.removeFolder(this.context, folderHandle);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

