/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.mail.MailFolderFunctions;
import org.exist.xquery.modules.mail.MailSessionFunctions;
import org.exist.xquery.modules.mail.MailStoreFunctions;
import org.exist.xquery.modules.mail.MessageListFunctions;
import org.exist.xquery.modules.mail.SendEmailFunction;

public class MailModule
extends AbstractInternalModule {
    private static final Logger LOG = Logger.getLogger(MailModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/mail";
    public static final String PREFIX = "mail";
    public static final String INCLUSION_DATE = "2005-05-12, 2009-03-14";
    public static final String RELEASED_IN_VERSION = "eXist-1.2 (JavaMail-based in trunk)";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(MailSessionFunctions.signatures[0], MailSessionFunctions.class), new FunctionDef(MailStoreFunctions.signatures[0], MailStoreFunctions.class), new FunctionDef(MailStoreFunctions.signatures[1], MailStoreFunctions.class), new FunctionDef(MailFolderFunctions.signatures[0], MailFolderFunctions.class), new FunctionDef(MailFolderFunctions.signatures[1], MailFolderFunctions.class), new FunctionDef(MessageListFunctions.signatures[0], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[1], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[2], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[3], MessageListFunctions.class), new FunctionDef(SendEmailFunction.signatures[0], SendEmailFunction.class), new FunctionDef(SendEmailFunction.deprecated, SendEmailFunction.class)};
    public static final String SESSIONS_CONTEXTVAR = "_eXist_mail_sessions";
    public static final String STORES_CONTEXTVAR = "_eXist_mail_stores";
    public static final String FOLDERS_CONTEXTVAR = "_eXist_mail_folders";
    public static final String FOLDERMSGLISTS_CONTEXTVAR = "_eXist_folder_message_lists";
    public static final String MSGLISTS_CONTEXTVAR = "_eXist_mail_message_lists";
    private static long currentSessionHandle = System.currentTimeMillis();

    public MailModule(Map<String, List<? extends Object>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing email related functions";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    static Session retrieveSession(XQueryContext context, long sessionHandle) {
        return (Session)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)SESSIONS_CONTEXTVAR, (long)sessionHandle);
    }

    static long storeSession(XQueryContext context, Session session) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)SESSIONS_CONTEXTVAR, (Object)session);
    }

    static Store retrieveStore(XQueryContext context, long storeHandle) {
        return (Store)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (long)storeHandle);
    }

    static long storeStore(XQueryContext context, Store store) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (Object)store);
    }

    static void removeStore(XQueryContext context, final long storeHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Store>(){

            public void modify(Map<Long, Store> map) {
                map.remove(storeHandle);
            }
        });
    }

    private static void closeAllStores(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<Store>(){

            public void modify(Map<Long, Store> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, Store> entry) {
                Store store = entry.getValue();
                try {
                    store.close();
                }
                catch (MessagingException me) {
                    LOG.warn((Object)("Unable to close Mail Store: " + me.getMessage()), (Throwable)me);
                }
            }
        });
    }

    static Folder retrieveFolder(XQueryContext context, long folderHandle) {
        return (Folder)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (long)folderHandle);
    }

    static long storeFolder(XQueryContext context, Folder folder) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (Object)folder);
    }

    static void removeFolder(final XQueryContext context, final long folderHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Folder>(){

            public void modify(Map<Long, Folder> map) {
                ModuleUtils.modifyContextMap((XQueryContext)context, (String)MailModule.FOLDERMSGLISTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Map<Long, Message[]>>(){

                    public void modify(Map<Long, Map<Long, Message[]>> map) {
                        final Map<Long, Message[]> folderMsgList = map.get(folderHandle);
                        ModuleUtils.modifyContextMap((XQueryContext)context, (String)MailModule.MSGLISTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Message[]>(){

                            public void modify(Map<Long, Message[]> map) {
                                for (Long msgListKey : folderMsgList.keySet()) {
                                    map.remove(msgListKey);
                                }
                            }
                        });
                        map.remove(folderHandle);
                    }
                });
                map.remove(folderHandle);
            }
        });
    }

    private static void closeAllFolders(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<Folder>(){

            public void modify(Map<Long, Folder> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, Folder> entry) {
                Folder folder = entry.getValue();
                try {
                    folder.close(false);
                }
                catch (MessagingException me) {
                    LOG.warn((Object)("Unable to close Mail Folder: " + me.getMessage()), (Throwable)me);
                }
            }
        });
    }

    static Message[] retrieveMessageList(XQueryContext context, long msgListHandle) {
        return (Message[])ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (long)msgListHandle);
    }

    static long storeMessageList(XQueryContext context, final Message[] msgList, final long folderHandle) {
        final long msgListHandle = ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (Object)msgList);
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERMSGLISTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Map<Long, Message[]>>(){

            public void modify(Map<Long, Map<Long, Message[]>> map) {
                Map<Long, Message[]> folderMsgList = map.get(folderHandle);
                if (folderMsgList == null) {
                    folderMsgList = new HashMap<Long, Message[]>();
                    map.put(folderHandle, folderMsgList);
                }
                folderMsgList.put(msgListHandle, msgList);
            }
        });
        return msgListHandle;
    }

    static void removeMessageList(XQueryContext context, final long msgListHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Message[]>(){

            public void modify(Map<Long, Message[]> map) {
                map.remove(msgListHandle);
            }
        });
    }

    private static void closeAllMessageLists(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapModifier<Message[]>(){

            public void modify(Map<Long, Message[]> map) {
                map.clear();
            }
        });
    }

    public void reset(XQueryContext context) {
        super.reset(context);
        MailModule.closeAllMessageLists(context);
        MailModule.closeAllFolders(context);
        MailModule.closeAllStores(context);
    }
}

