/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.util.Properties;
import javax.mail.Session;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Node;

public class MailSessionFunctions
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(MailSessionFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-mail-session", "http://exist-db.org/xquery/mail", "mail"), "Open's a JavaMail session.", new SequenceType[]{new FunctionParameterSequenceType("properties", 1, 3, "An optional JavaMail session properties in the form <properties><property name=\"\" value=\"\"/></properties>.  The JavaMail properties are spelled out in Appendix A of the JavaMail specifications.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the session handle."))};

    public MailSessionFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Properties props = new Properties();
        if (args.length == 1) {
            props = ModuleUtils.parseProperties((Node)((NodeValue)args[0].itemAt(0)).getNode());
        }
        Session session = Session.getInstance((Properties)props, null);
        IntegerValue integerValue = new IntegerValue(MailModule.storeSession(this.context, session));
        return integerValue;
    }
}

