/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class MailStoreFunctions
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(MailStoreFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-mail-store", "http://exist-db.org/xquery/mail", "mail"), "Opens a mail store. Host/User/Password/Protocol values will be obtained from the session.", new SequenceType[]{new FunctionParameterSequenceType("mail-handle", 31, 2, "The JavaMail session handle retrieved from mail:get-mail-session()")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the store handle.")), new FunctionSignature(new QName("close-mail-store", "http://exist-db.org/xquery/mail", "mail"), "Closes a mail store.", new SequenceType[]{new FunctionParameterSequenceType("mail-store-handle", 31, 2, "The mail store handle retrieved from mail:get-mail-store()")}, new SequenceType(11, 1))};

    public MailStoreFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("get-mail-store")) {
            Sequence mailStore = this.getMailStore(args, contextSequence);
            return mailStore;
        }
        if (this.isCalledAs("close-mail-store")) {
            Sequence closeMailStore = this.closeMailStore(args, contextSequence);
            return closeMailStore;
        }
        throw new XPathException((Expression)this, "Invalid function name");
    }

    private Sequence getMailStore(Sequence[] args, Sequence contextSequence) throws XPathException {
        Store store;
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Session handle not specified");
        }
        long sessionHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Session session = MailModule.retrieveSession(this.context, sessionHandle);
        if (session == null) {
            throw new XPathException((Expression)this, "Invalid Session handle specified");
        }
        try {
            String password = session.getProperty("mail." + session.getProperty("mail.store.protocol") + ".password");
            if (password == null) {
                password = session.getProperty("mail.password");
            }
            store = session.getStore();
            store.connect(null, null, password);
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to open mail store", (Throwable)me);
        }
        return new IntegerValue(MailModule.storeStore(this.context, store));
    }

    private Sequence closeMailStore(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Store handle not specified");
        }
        long storeHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Store store = MailModule.retrieveStore(this.context, storeHandle);
        if (store == null) {
            throw new XPathException((Expression)this, "Invalid Store handle specified");
        }
        try {
            store.close();
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to close mail store", (Throwable)me);
        }
        finally {
            MailModule.removeStore(this.context, storeHandle);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

