/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageListFunctions
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(MessageListFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-message-list", "http://exist-db.org/xquery/mail", "mail"), "Returns a message list of all messages in a folder.", new SequenceType[]{new FunctionParameterSequenceType("mail-folder-handle", 31, 2, "The mail folder handle retrieved from mail:get-mail-folder()")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the message list handle.")), new FunctionSignature(new QName("search-message-list", "http://exist-db.org/xquery/mail", "mail"), "Searches messages in a folder. Search terms are of the form <searchTerm type=\"xxx\">...</searchTerm>.  Valid types include: not, and, or, from, subject, body, recipient, header, flag, sent, received. <searchTerm type=\"not\"> requires a single nested child search term. <searchTerm type=\"and\"> and <searchTerm type=\"or\"> must have one or more nested child search terms. <searchTerm type=\"from\" pattern=\"pat\">, <searchTerm type=\"subject\" pattern=\"pat\"> and <searchTerm type=\"body\" pattern=\"pat\">  require a pattern attribute and will search for a substring that matches the pattern. <searchTerm type=\"recipient\" pattern=\"pat\" recipientType=\"to|cc|bcc\"> requires pattern and recipientType attributes. <searchTerm type=\"header\" pattern=\"pat\" name=\"Content-Type\"> requires pattern and name attributes. <searchTerm type=\"flag\" flag=\"answered|deleted|draft|recent|seen\" value=\"true|false\"> requires flag and value attributes. <searchTerm type=\"sent\" comparison=\"eq|gt|ge|lt|le|ne\" format=\"format\" date=\"date\"> and <searchTerm type=\"received\" comparison=\"eq|gt|ge|lt|le|ne\" format=\"format\" date=\"date\"> require comparison, format and date attributes. The format string should conform to Java SimpleDateFormat specifications and the date string must conform to the specified format string.", new SequenceType[]{new FunctionParameterSequenceType("mail-folder-handle", 31, 2, "The mail folder handle retrieved from mail:get-mail-folder()"), new FunctionParameterSequenceType("search-parameters", 1, 2, "The xml fragment defining the search terms")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the message list handle.")), new FunctionSignature(new QName("get-message-list-as-xml", "http://exist-db.org/xquery/mail", "mail"), "Returns a message list of all messages in a folder as XML.  If there are no messages in the list, an empty sequence will be returned", new SequenceType[]{new FunctionParameterSequenceType("message-list-handle", 31, 2, "The message list handle retrieved from mail:get-message-list() or mail:search-message-list()"), new FunctionParameterSequenceType("include-headers", 23, 2, "A boolean specifying whether to include message headers")}, (SequenceType)new FunctionReturnSequenceType(1, 3, "the list of all messages in a folder as XML")), new FunctionSignature(new QName("close-message-list", "http://exist-db.org/xquery/mail", "mail"), "Closes a message list.", new SequenceType[]{new FunctionParameterSequenceType("message-list-handle", 31, 2, "The message list handle retrieved from mail:get-message-list() or mail:search-message-list()")}, new SequenceType(11, 1))};
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String[] PREFETCH_HEADERS = new String[]{"Return-Path", "Delivered-To", "Received", "Date", "From", "To", "Message-ID", "Subject", "MIME-Version", "Content-Type", "Content-Transfer-Encoding", "X-Mailer", "X-Priority"};

    public MessageListFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("get-message-list")) {
            Sequence messageList = this.getMessageList(args, contextSequence);
            return messageList;
        }
        if (this.isCalledAs("search-message-list")) {
            Sequence searchMessageList = this.searchMessageList(args, contextSequence);
            return searchMessageList;
        }
        if (this.isCalledAs("get-message-list-as-xml")) {
            Sequence messageListAsXML = this.getMessageListAsXML(args, contextSequence);
            return messageListAsXML;
        }
        if (this.isCalledAs("close-message-list")) {
            Sequence closeMessageList = this.closeMessageList(args, contextSequence);
            return closeMessageList;
        }
        throw new XPathException((Expression)this, "Invalid function name");
    }

    private Sequence getMessageList(Sequence[] args, Sequence contextSequence) throws XPathException {
        Message[] msgList;
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Folder handle not specified");
        }
        long folderHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Folder folder = MailModule.retrieveFolder(this.context, folderHandle);
        if (folder == null) {
            throw new XPathException((Expression)this, "Invalid Folder handle specified");
        }
        try {
            msgList = folder.getMessages();
            this.prefetchMessages(folder, msgList);
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to get mail list", (Throwable)me);
        }
        return new IntegerValue(MailModule.storeMessageList(this.context, msgList, folderHandle));
    }

    private Sequence searchMessageList(Sequence[] args, Sequence contextSequence) throws XPathException {
        Message[] msgList;
        if (args[0].isEmpty() || args[1].isEmpty()) {
            throw new XPathException((Expression)this, "Folder handle or Search Terms not specified");
        }
        long folderHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Folder folder = MailModule.retrieveFolder(this.context, folderHandle);
        if (folder == null) {
            throw new XPathException((Expression)this, "Invalid Folder handle specified");
        }
        Node searchTermsXML = ((NodeValue)args[1].itemAt(0)).getNode();
        try {
            msgList = folder.search(this.parseSearchTerms(searchTermsXML));
            this.prefetchMessages(folder, msgList);
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to get mail list", (Throwable)me);
        }
        return new IntegerValue(MailModule.storeMessageList(this.context, msgList, folderHandle));
    }

    private void prefetchMessages(Folder folder, Message[] msgList) throws MessagingException {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.ENVELOPE);
        for (int i = 0; i < PREFETCH_HEADERS.length; ++i) {
            fp.add(PREFETCH_HEADERS[i]);
        }
        folder.fetch(msgList, fp);
    }

    private Sequence getMessageListAsXML(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence ret = Sequence.EMPTY_SEQUENCE;
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Message List handle not specified");
        }
        long msgListHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Message[] msgList = MailModule.retrieveMessageList(this.context, msgListHandle);
        if (msgList == null) {
            throw new XPathException((Expression)this, "Invalid Message List handle specified");
        }
        if (msgList.length > 0) {
            boolean includeHeaders = args[1].effectiveBooleanValue();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(new QName("messages", "http://exist-db.org/xquery/mail", "mail"), null);
            builder.addAttribute(new QName("count", null, null), String.valueOf(msgList.length));
            try {
                for (int i = 0; i < msgList.length; ++i) {
                    Enumeration headers;
                    Address[] bcc;
                    Address[] cc;
                    Message message = msgList[i];
                    builder.startElement(new QName("message", "http://exist-db.org/xquery/mail", "mail"), null);
                    builder.addAttribute(new QName("number", null, null), String.valueOf(i));
                    if (message.getSentDate() != null) {
                        builder.startElement(new QName("sent", "http://exist-db.org/xquery/mail", "mail"), null);
                        builder.characters((CharSequence)this.formatDate(message.getSentDate()));
                        builder.endElement();
                    }
                    if (message.getReceivedDate() != null) {
                        builder.startElement(new QName("received", "http://exist-db.org/xquery/mail", "mail"), null);
                        builder.characters((CharSequence)this.formatDate(message.getReceivedDate()));
                        builder.endElement();
                    }
                    if (message.getFrom() != null) {
                        builder.startElement(new QName("from", "http://exist-db.org/xquery/mail", "mail"), null);
                        builder.characters((CharSequence)message.getFrom()[0].toString());
                        builder.endElement();
                    }
                    builder.startElement(new QName("recipients", "http://exist-db.org/xquery/mail", "mail"), null);
                    Address[] to = message.getRecipients(Message.RecipientType.TO);
                    if (to != null) {
                        for (int j = 0; j < to.length; ++j) {
                            builder.startElement(new QName("recipient", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("type", null, null), "to");
                            builder.characters((CharSequence)to[j].toString());
                            builder.endElement();
                        }
                    }
                    if ((cc = message.getRecipients(Message.RecipientType.CC)) != null) {
                        for (int j = 0; j < cc.length; ++j) {
                            builder.startElement(new QName("recipient", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("type", null, null), "cc");
                            builder.characters((CharSequence)cc[j].toString());
                            builder.endElement();
                        }
                    }
                    if ((bcc = message.getRecipients(Message.RecipientType.BCC)) != null) {
                        for (int j = 0; j < cc.length; ++j) {
                            builder.startElement(new QName("recipient", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("type", null, null), "bcc");
                            builder.characters((CharSequence)bcc[j].toString());
                            builder.endElement();
                        }
                    }
                    builder.endElement();
                    Flags flags = message.getFlags();
                    Flags.Flag[] sf = flags.getSystemFlags();
                    String[] uf = flags.getUserFlags();
                    if (sf.length > 0 || uf.length > 0) {
                        int f;
                        builder.startElement(new QName("flags", "http://exist-db.org/xquery/mail", "mail"), null);
                        for (f = 0; f < sf.length; ++f) {
                            if (sf[f] == Flags.Flag.ANSWERED) {
                                builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                                builder.addAttribute(new QName("type", null, null), "answered");
                                builder.endElement();
                                continue;
                            }
                            if (sf[f] == Flags.Flag.DELETED) {
                                builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                                builder.addAttribute(new QName("type", null, null), "deleted");
                                builder.endElement();
                                continue;
                            }
                            if (sf[f] == Flags.Flag.DRAFT) {
                                builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                                builder.addAttribute(new QName("type", null, null), "draft");
                                builder.endElement();
                                continue;
                            }
                            if (sf[f] == Flags.Flag.FLAGGED) {
                                builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                                builder.addAttribute(new QName("type", null, null), "flagged");
                                builder.endElement();
                                continue;
                            }
                            if (sf[f] == Flags.Flag.RECENT) {
                                builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                                builder.addAttribute(new QName("type", null, null), "recent");
                                builder.endElement();
                                continue;
                            }
                            if (sf[f] != Flags.Flag.SEEN) continue;
                            builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("type", null, null), "seen");
                            builder.endElement();
                        }
                        for (f = 0; f < uf.length; ++f) {
                            builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("type", null, null), "user");
                            builder.addAttribute(new QName("value", null, null), uf[f]);
                            builder.endElement();
                        }
                        builder.endElement();
                    }
                    if (includeHeaders && (headers = message.getAllHeaders()).hasMoreElements()) {
                        builder.startElement(new QName("headers", "http://exist-db.org/xquery/mail", "mail"), null);
                        while (headers.hasMoreElements()) {
                            Header header = (Header)headers.nextElement();
                            builder.startElement(new QName("header", "http://exist-db.org/xquery/mail", "mail"), null);
                            builder.addAttribute(new QName("name", null, null), header.getName());
                            builder.addAttribute(new QName("value", null, null), header.getValue());
                            builder.endElement();
                        }
                        builder.endElement();
                    }
                    builder.startElement(new QName("subject", "http://exist-db.org/xquery/mail", "mail"), null);
                    builder.characters((CharSequence)message.getSubject());
                    builder.endElement();
                    builder.endElement();
                }
            }
            catch (MessagingException me) {
                throw new XPathException((Expression)this, "Failed to retrieve messages from list", (Throwable)me);
            }
            builder.endElement();
            ret = (NodeValue)builder.getDocument().getDocumentElement();
        }
        return ret;
    }

    private String formatDate(Date date) {
        String formatted = "";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String temp = sdf.format(date);
        formatted = temp.substring(0, temp.length() - 2) + ":" + temp.substring(temp.length() - 2);
        return formatted;
    }

    private Sequence closeMessageList(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Message List handle not specified");
        }
        long msgListHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        MailModule.removeMessageList(this.context, msgListHandle);
        return Sequence.EMPTY_SEQUENCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SearchTerm parseSearchTerms(Node terms) throws XPathException {
        NotTerm st = null;
        if (terms.getNodeType() == 1 && terms.getLocalName().equalsIgnoreCase("searchTerm")) {
            String type = ((Element)terms).getAttribute("type");
            if (type == null) throw new XPathException((Expression)this, "Invalid Search Term type specified: null");
            if (type.equalsIgnoreCase("not")) {
                st = new NotTerm(this.parseChildSearchTerm(terms));
            } else if (type.equalsIgnoreCase("and")) {
                st = new AndTerm(this.parseChildSearchTerms(terms));
            } else if (type.equalsIgnoreCase("or")) {
                st = new OrTerm(this.parseChildSearchTerms(terms));
            } else if (type.equalsIgnoreCase("from")) {
                st = this.parseFromTerm(terms);
            } else if (type.equalsIgnoreCase("subject")) {
                st = this.parseSubjectTerm(terms);
            } else if (type.equalsIgnoreCase("body")) {
                st = this.parseBodyTerm(terms);
            } else if (type.equalsIgnoreCase("to") || type.equalsIgnoreCase("recipient")) {
                st = this.parseRecipientTerm(terms);
            } else if (type.equalsIgnoreCase("header")) {
                st = this.parseHeaderTerm(terms);
            } else if (type.equalsIgnoreCase("flag")) {
                st = this.parseFlagTerm(terms);
            } else if (type.equalsIgnoreCase("sent")) {
                st = this.parseSentDateTerm(terms);
            } else {
                if (!type.equalsIgnoreCase("received")) throw new XPathException((Expression)this, "Invalid Search Term type specified: " + type);
                st = this.parseReceivedDateTerm(terms);
            }
        }
        if (st != null) return st;
        throw new XPathException((Expression)this, "Invalid Search Terms specified");
    }

    private SearchTerm parseChildSearchTerm(Node terms) throws XPathException {
        SearchTerm st = null;
        NodeList children = terms.getChildNodes();
        if (children.getLength() != 1) {
            throw new XPathException((Expression)this, "Only one child term is allowed for term with type: " + ((Element)terms).getAttribute("type"));
        }
        Node child = children.item(0);
        st = this.parseSearchTerms(child);
        return st;
    }

    private SearchTerm[] parseChildSearchTerms(Node terms) throws XPathException {
        ArrayList<SearchTerm> st = new ArrayList<SearchTerm>();
        NodeList children = terms.getChildNodes();
        if (children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                st.add(this.parseSearchTerms(child));
            }
        } else {
            throw new XPathException((Expression)this, "At least one child term is required for term with type: " + ((Element)terms).getAttribute("type"));
        }
        return st.toArray(new SearchTerm[0]);
    }

    private SearchTerm parseFromTerm(Node terms) throws XPathException {
        FromStringTerm st = null;
        String pattern = ((Element)terms).getAttribute("pattern");
        if (pattern == null || pattern.length() <= 0) {
            throw new XPathException((Expression)this, "Pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        st = new FromStringTerm(pattern);
        return st;
    }

    private SearchTerm parseSubjectTerm(Node terms) throws XPathException {
        SubjectTerm st = null;
        String pattern = ((Element)terms).getAttribute("pattern");
        if (pattern == null || pattern.length() <= 0) {
            throw new XPathException((Expression)this, "Pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        st = new SubjectTerm(pattern);
        return st;
    }

    private SearchTerm parseBodyTerm(Node terms) throws XPathException {
        BodyTerm st = null;
        String pattern = ((Element)terms).getAttribute("pattern");
        if (pattern == null || pattern.length() <= 0) {
            throw new XPathException((Expression)this, "Pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        st = new BodyTerm(pattern);
        return st;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SearchTerm parseRecipientTerm(Node terms) throws XPathException {
        RecipientStringTerm st = null;
        String pattern = ((Element)terms).getAttribute("pattern");
        String type = ((Element)terms).getAttribute("recipientType");
        if (type == null) throw new XPathException((Expression)this, "recipientType not specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (type.length() == 0) {
            throw new XPathException((Expression)this, "recipientType not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        if (pattern == null) throw new XPathException((Expression)this, "Pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (pattern.length() <= 0) throw new XPathException((Expression)this, "Pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        Message.RecipientType rtype = null;
        if (type.equalsIgnoreCase("to")) {
            rtype = Message.RecipientType.TO;
            return new RecipientStringTerm(rtype, pattern);
        } else if (type.equalsIgnoreCase("cc")) {
            rtype = Message.RecipientType.CC;
            return new RecipientStringTerm(rtype, pattern);
        } else {
            if (!type.equalsIgnoreCase("bcc")) throw new XPathException((Expression)this, "Invalid recipientType: " + type + ", for term with type: " + ((Element)terms).getAttribute("type"));
            rtype = Message.RecipientType.BCC;
        }
        return new RecipientStringTerm(rtype, pattern);
    }

    private SearchTerm parseHeaderTerm(Node terms) throws XPathException {
        HeaderTerm st = null;
        String pattern = ((Element)terms).getAttribute("pattern");
        String name = ((Element)terms).getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new XPathException((Expression)this, "name not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        if (pattern == null || pattern.length() <= 0) {
            throw new XPathException((Expression)this, "pattern attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        st = new HeaderTerm(name, pattern);
        return st;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SearchTerm parseFlagTerm(Node terms) throws XPathException {
        FlagTerm st = null;
        String flag = ((Element)terms).getAttribute("flag");
        String value = ((Element)terms).getAttribute("value");
        if (value == null) throw new XPathException((Expression)this, "value not specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (value.length() == 0) {
            throw new XPathException((Expression)this, "value not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        if (flag == null) throw new XPathException((Expression)this, "flag attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (flag.length() <= 0) throw new XPathException((Expression)this, "flag attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        Flags flags = null;
        if (flag.equalsIgnoreCase("answered")) {
            flags = new Flags(Flags.Flag.ANSWERED);
            return new FlagTerm(flags, value.equalsIgnoreCase("true"));
        } else if (flag.equalsIgnoreCase("deleted")) {
            flags = new Flags(Flags.Flag.DELETED);
            return new FlagTerm(flags, value.equalsIgnoreCase("true"));
        } else if (flag.equalsIgnoreCase("draft")) {
            flags = new Flags(Flags.Flag.DRAFT);
            return new FlagTerm(flags, value.equalsIgnoreCase("true"));
        } else if (flag.equalsIgnoreCase("recent")) {
            flags = new Flags(Flags.Flag.RECENT);
            return new FlagTerm(flags, value.equalsIgnoreCase("true"));
        } else {
            if (!flag.equalsIgnoreCase("seen")) throw new XPathException((Expression)this, "Invalid flag: " + flag + ", for term with type: " + ((Element)terms).getAttribute("type"));
            flags = new Flags(Flags.Flag.SEEN);
        }
        return new FlagTerm(flags, value.equalsIgnoreCase("true"));
    }

    private SearchTerm parseSentDateTerm(Node terms) throws XPathException {
        SentDateTerm st = null;
        String value = ((Element)terms).getAttribute("date");
        String format = ((Element)terms).getAttribute("format");
        if (value == null || value.length() == 0) {
            throw new XPathException((Expression)this, "value not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        if (format == null || format.length() == 0) {
            throw new XPathException((Expression)this, "format not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        int cp = this.parseComparisonAttribute(terms);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date date = sdf.parse(value);
            st = new SentDateTerm(cp, date);
        }
        catch (ParseException pe) {
            throw new XPathException((Expression)this, "Cannot parse date value: " + value + ", using format: " + format + ", for term with type: " + ((Element)terms).getAttribute("type"));
        }
        return st;
    }

    private SearchTerm parseReceivedDateTerm(Node terms) throws XPathException {
        ReceivedDateTerm st = null;
        String value = ((Element)terms).getAttribute("date");
        String format = ((Element)terms).getAttribute("format");
        if (value == null || value.length() == 0) {
            throw new XPathException((Expression)this, "value not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        if (format == null || format.length() == 0) {
            throw new XPathException((Expression)this, "format not specified for term with type: " + ((Element)terms).getAttribute("type"));
        }
        int cp = this.parseComparisonAttribute(terms);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date date = sdf.parse(value);
            st = new ReceivedDateTerm(cp, date);
        }
        catch (ParseException pe) {
            throw new XPathException((Expression)this, "Cannot parse date value: " + value + ", using format: " + format + ", for term with type: " + ((Element)terms).getAttribute("type"));
        }
        return st;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseComparisonAttribute(Node terms) throws XPathException {
        int cp = 3;
        String comp = ((Element)terms).getAttribute("comparison");
        if (comp == null) throw new XPathException((Expression)this, "comparison attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (comp.length() <= 0) throw new XPathException((Expression)this, "comparison attribute must be specified for term with type: " + ((Element)terms).getAttribute("type"));
        if (comp.equalsIgnoreCase("eq")) {
            return 3;
        }
        if (comp.equalsIgnoreCase("ge")) {
            return 6;
        }
        if (comp.equalsIgnoreCase("gt")) {
            return 5;
        }
        if (comp.equalsIgnoreCase("le")) {
            return 1;
        }
        if (comp.equalsIgnoreCase("lt")) {
            return 2;
        }
        if (!comp.equalsIgnoreCase("ne")) throw new XPathException((Expression)this, "Invalid comparison: " + comp + ", for term with type: " + ((Element)terms).getAttribute("type"));
        return 4;
    }
}

