/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.Base64Encoder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.system.GetVersion;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SendEmailFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(SendEmailFunction.class);
    private final int MIME_BASE64_MAX_LINE_LENGTH = 76;
    private String charset;
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("send-email", "http://exist-db.org/xquery/mail", "mail"), "Sends an email through the SMTP Server.", new SequenceType[]{new FunctionParameterSequenceType("email", 1, 6, "The email message in the following format: <mail> <from/> <reply-to/> <to/> <cc/> <bcc/> <subject/> <message> <text/> <xhtml/> </message> <attachment filename=\"\" mimetype=\"\">xs:base64Binary</attachment> </mail>."), new FunctionParameterSequenceType("server", 22, 3, "The SMTP server.  If empty, then it tries to use the local sendmail program."), new FunctionParameterSequenceType("charset", 22, 3, "The charset value used in the \"Content-Type\" message header (Defaults to UTF-8)")}, (SequenceType)new FunctionReturnSequenceType(23, 6, "true if the email message was successfully sent"));
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("send-email", "http://exist-db.org/xquery/mail", "mail"), "Sends an email using javax.mail messaging libraries.", new SequenceType[]{new FunctionParameterSequenceType("mail-handle", 37, 2, "The JavaMail session handle retrieved from mail:get-mail-session()"), new FunctionParameterSequenceType("email", 1, 6, "The email message in the following format: <mail> <from/> <reply-to/> <to/> <cc/> <bcc/> <subject/> <message> <text/> <xhtml/> </message> <attachment filename=\"\" mimetype=\"\">xs:base64Binary</attachment> </mail>.")}, new SequenceType(11, 1))};

    public SendEmailFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length == 3) {
            return this.deprecatedSendEmail(args, contextSequence);
        }
        return this.sendEmail(args, contextSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence sendEmail(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Session handle not specified");
        }
        long sessionHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Session session = MailModule.retrieveSession(this.context, sessionHandle);
        if (session == null) {
            throw new XPathException((Expression)this, "Invalid Session handle specified");
        }
        try {
            List<Message> messages = this.parseInputEmails(session, args[1]);
            String proto = session.getProperty("mail.transport.protocol");
            if (proto == null) {
                proto = "smtp";
            }
            Transport t = session.getTransport(proto);
            try {
                if (session.getProperty("mail." + proto + ".auth") != null) {
                    t.connect(session.getProperty("mail." + proto + ".user"), session.getProperty("mail." + proto + ".password"));
                }
                for (Message msg : messages) {
                    t.sendMessage(msg, msg.getAllRecipients());
                }
            }
            finally {
                t.close();
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        catch (TransformerException te) {
            throw new XPathException((Expression)this, "Could not Transform XHTML Message Body: " + te.getMessage(), (Throwable)te);
        }
        catch (MessagingException smtpe) {
            throw new XPathException((Expression)this, "Could not send message(s): " + smtpe.getMessage(), (Throwable)smtpe);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, "Attachment in some message could not be prepared: " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (Throwable t) {
            throw new XPathException((Expression)this, "Unexpected error from JavaMail layer (Is your message well structured?): " + t.getMessage(), t);
        }
    }

    public Sequence deprecatedSendEmail(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            this.charset = !args[2].isEmpty() ? args[2].getStringValue() : "UTF-8";
            ArrayList<Element> mailElements = new ArrayList<Element>();
            if (args[0].getItemCount() > 1 && args[0] instanceof ValueSequence) {
                for (int i = 0; i < args[0].getItemCount(); ++i) {
                    mailElements.add((Element)args[0].itemAt(i));
                }
            } else {
                mailElements.add((Element)args[0].itemAt(0));
            }
            List<Mail> mails = this.parseMailElement(mailElements);
            ValueSequence results = new ValueSequence();
            if (!args[1].isEmpty()) {
                List<Boolean> mailResults = this.sendBySMTP(mails, args[1].getStringValue());
                for (Boolean mailResult : mailResults) {
                    results.add((Item)BooleanValue.valueOf((boolean)mailResult));
                }
            } else {
                for (Mail mail : mails) {
                    boolean result = this.sendBySendmail(mail);
                    results.add((Item)BooleanValue.valueOf((boolean)result));
                }
            }
            return results;
        }
        catch (TransformerException te) {
            throw new XPathException((Expression)this, "Could not Transform XHTML Message Body: " + te.getMessage(), (Throwable)te);
        }
        catch (SMTPException smtpe) {
            throw new XPathException((Expression)this, "Could not send message(s)" + smtpe.getMessage(), (Throwable)smtpe);
        }
    }

    private List<Message> parseInputEmails(Session session, Sequence arg) throws IOException, MessagingException, TransformerException {
        ArrayList<Element> mailElements = new ArrayList<Element>();
        if (arg.getItemCount() > 1 && arg instanceof ValueSequence) {
            for (int i = 0; i < arg.getItemCount(); ++i) {
                mailElements.add((Element)arg.itemAt(i));
            }
        } else {
            mailElements.add((Element)arg.itemAt(0));
        }
        return this.parseMessageElement(session, mailElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBySendmail(Mail mail) {
        PrintWriter out = null;
        try {
            ArrayList<String> allrecipients = new ArrayList<String>();
            allrecipients.addAll(mail.getTo());
            allrecipients.addAll(mail.getCC());
            allrecipients.addAll(mail.getBCC());
            String recipients = "";
            for (int x = 0; x < allrecipients.size(); ++x) {
                recipients = ((String)allrecipients.get(x)).indexOf("<") != -1 ? recipients + " " + ((String)allrecipients.get(x)).substring(((String)allrecipients.get(x)).indexOf("<") + 1, ((String)allrecipients.get(x)).indexOf(">")) : recipients + " " + (String)allrecipients.get(x);
            }
            Process p = Runtime.getRuntime().exec("/usr/sbin/sendmail" + recipients);
            out = new PrintWriter(new OutputStreamWriter(p.getOutputStream(), this.charset));
            this.writeMessage(out, mail);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        LOG.info((Object)("send-email() message sent using Sendmail " + new Date()));
        return true;
    }

    private List<Boolean> sendBySMTP(List<Mail> mails, String SMTPServer) throws SMTPException {
        int TCP_PROTOCOL_SMTP = 25;
        String smtpResult = "";
        Socket smtpSock = null;
        BufferedReader smtpIn = null;
        PrintWriter smtpOut = null;
        ArrayList<Boolean> sendMailResults = new ArrayList<Boolean>();
        try {
            smtpSock = new Socket(SMTPServer, 25);
            smtpIn = new BufferedReader(new InputStreamReader(smtpSock.getInputStream()));
            smtpOut = new PrintWriter(new OutputStreamWriter(smtpSock.getOutputStream(), this.charset));
            smtpResult = smtpIn.readLine();
            if (!smtpResult.substring(0, 3).toString().equals("220")) {
                String errMsg = "Error - SMTP Server not ready: '" + smtpResult + "'";
                LOG.error((Object)errMsg);
                throw new SMTPException(errMsg);
            }
            smtpOut.println("HELO " + InetAddress.getLocalHost().getHostName());
            smtpOut.flush();
            smtpResult = smtpIn.readLine();
            if (!smtpResult.substring(0, 3).toString().equals("250")) {
                String errMsg = "Error - SMTP HELO Failed: '" + smtpResult + "'";
                LOG.error((Object)errMsg);
                throw new SMTPException(errMsg);
            }
            for (Mail mail : mails) {
                boolean mailResult = this.writeSMTPMessage(mail, smtpOut, smtpIn);
                sendMailResults.add(mailResult);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new SMTPException((Throwable)ioe);
        }
        finally {
            try {
                if (smtpOut != null) {
                    smtpOut.close();
                }
                if (smtpIn != null) {
                    smtpIn.close();
                }
                if (smtpSock != null) {
                    smtpSock.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
        LOG.info((Object)("send-email() message(s) sent using SMTP " + new Date()));
        return sendMailResults;
    }

    private boolean writeSMTPMessage(Mail mail, PrintWriter smtpOut, BufferedReader smtpIn) {
        try {
            String smtpResult = "";
            if (mail.getFrom().indexOf("<") != -1) {
                smtpOut.println("MAIL FROM:<" + mail.getFrom().substring(mail.getFrom().indexOf("<") + 1, mail.getFrom().indexOf(">")) + ">");
            } else {
                smtpOut.println("MAIL FROM:<" + mail.getFrom() + ">");
            }
            smtpOut.flush();
            smtpResult = smtpIn.readLine();
            if (!smtpResult.substring(0, 3).toString().equals("250")) {
                LOG.error((Object)("Error - SMTP MAIL FROM failed: " + smtpResult));
                return false;
            }
            ArrayList<String> allrecipients = new ArrayList<String>();
            allrecipients.addAll(mail.getTo());
            allrecipients.addAll(mail.getCC());
            allrecipients.addAll(mail.getBCC());
            for (int x = 0; x < allrecipients.size(); ++x) {
                if (((String)allrecipients.get(x)).indexOf("<") != -1) {
                    smtpOut.println("RCPT TO:<" + ((String)allrecipients.get(x)).substring(((String)allrecipients.get(x)).indexOf("<") + 1, ((String)allrecipients.get(x)).indexOf(">")) + ">");
                } else {
                    smtpOut.println("RCPT TO:<" + (String)allrecipients.get(x) + ">");
                }
                smtpOut.flush();
                smtpResult = smtpIn.readLine();
                if (smtpResult.substring(0, 3).toString().equals("250")) continue;
                LOG.error((Object)("Error - SMTP RCPT TO failed: " + smtpResult));
            }
            smtpOut.println("DATA");
            smtpOut.flush();
            smtpResult = smtpIn.readLine();
            if (!smtpResult.substring(0, 3).toString().equals("354")) {
                LOG.error((Object)("Error - SMTP DATA failed: " + smtpResult));
                return false;
            }
            this.writeMessage(smtpOut, mail);
            smtpResult = smtpIn.readLine();
            if (!smtpResult.substring(0, 3).toString().equals("250")) {
                LOG.error((Object)("Error - Message not accepted: " + smtpResult));
                return false;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            return false;
        }
        return true;
    }

    private void writeMessage(PrintWriter out, Mail aMail) throws IOException {
        int x;
        String Version2 = this.eXistVersion();
        String MultipartBoundary = "eXist.multipart." + Version2;
        out.println("From: " + this.encode64Address(aMail.getFrom()));
        if (aMail.getReplyTo() != null) {
            out.println("Reply-To: " + this.encode64Address(aMail.getReplyTo()));
        }
        for (x = 0; x < aMail.countTo(); ++x) {
            out.println("To: " + this.encode64Address(aMail.getTo(x)));
        }
        for (x = 0; x < aMail.countCC(); ++x) {
            out.println("CC: " + this.encode64Address(aMail.getCC(x)));
        }
        for (x = 0; x < aMail.countBCC(); ++x) {
            out.println("BCC: " + this.encode64Address(aMail.getBCC(x)));
        }
        out.println("Date: " + this.getDateRFC822());
        out.println("Subject: " + this.encode64(aMail.getSubject()));
        out.println("X-Mailer: eXist " + Version2 + " mail:send-email()");
        out.println("MIME-Version: 1.0");
        boolean multipartAlternative = false;
        String multipartBoundary = null;
        if (aMail.attachmentIterator().hasNext()) {
            multipartBoundary = MultipartBoundary;
        } else if (!aMail.getText().equals("") && !aMail.getXHTML().equals("")) {
            multipartAlternative = true;
            multipartBoundary = MultipartBoundary + "_alt";
        }
        if (multipartBoundary != null) {
            out.println("Content-Type: " + (multipartAlternative ? "multipart/alternative" : "multipart/mixed") + "; boundary=\"" + multipartBoundary + "\";");
            out.println();
            out.println("Error your mail client is not MIME Compatible");
            out.println("--" + multipartBoundary);
        }
        if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
            out.println("Content-Type: multipart/alternative; boundary=\"" + MultipartBoundary + "_alt\";");
            out.println("--" + MultipartBoundary + "_alt");
        }
        if (!aMail.getText().toString().equals("")) {
            out.println("Content-Type: text/plain; charset=" + this.charset);
            out.println("Content-Transfer-Encoding: 8bit");
            out.println();
            out.println(aMail.getText());
            if (multipartBoundary != null) {
                if (!aMail.getXHTML().toString().equals("") || aMail.attachmentIterator().hasNext()) {
                    if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                        out.println("--" + MultipartBoundary + "_alt");
                    } else {
                        out.println("--" + multipartBoundary);
                    }
                } else if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                    out.println("--" + MultipartBoundary + "_alt--");
                } else {
                    out.println("--" + multipartBoundary + "--");
                }
            }
        }
        if (!aMail.getXHTML().toString().equals("")) {
            out.println("Content-Type: text/html; charset=" + this.charset);
            out.println("Content-Transfer-Encoding: 8bit");
            out.println();
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
            out.println(aMail.getXHTML());
            if (multipartBoundary != null) {
                if (aMail.attachmentIterator().hasNext()) {
                    if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                        out.println("--" + MultipartBoundary + "_alt--");
                        out.println("--" + multipartBoundary);
                    } else {
                        out.println("--" + multipartBoundary);
                    }
                } else if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                    out.println("--" + MultipartBoundary + "_alt--");
                } else {
                    out.println("--" + multipartBoundary + "--");
                }
            }
        }
        if (aMail.attachmentIterator().hasNext()) {
            Iterator<MailAttachment> itAttachment = aMail.attachmentIterator();
            while (itAttachment.hasNext()) {
                MailAttachment ma = itAttachment.next();
                out.println("Content-Type: " + ma.getMimeType() + "; name=\"" + ma.getFilename() + "\"");
                out.println("Content-Transfer-Encoding: base64");
                out.println("Content-Description: " + ma.getFilename());
                out.println("Content-Disposition: attachment; filename=\"" + ma.getFilename() + "\"");
                out.println();
                char[] buf = new char[76];
                int read = -1;
                StringReader attachmentDataReader = new StringReader(ma.getData());
                while ((read = ((Reader)attachmentDataReader).read(buf, 0, 76)) > -1) {
                    out.println(String.valueOf(buf, 0, read));
                }
                if (!itAttachment.hasNext()) continue;
                out.println("--" + multipartBoundary);
            }
            out.println("--" + multipartBoundary + "--");
        }
        out.println();
        out.println(".");
        out.flush();
    }

    private String eXistVersion() throws IOException {
        Properties sysProperties = new Properties();
        sysProperties.load(GetVersion.class.getClassLoader().getResourceAsStream("org/exist/system.properties"));
        return sysProperties.getProperty("product-version", "unknown version");
    }

    private List<Mail> parseMailElement(List<Element> mailElements) throws TransformerException {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        for (Element mailElement : mailElements) {
            if (!mailElement.getLocalName().equals("mail")) continue;
            Mail mail = new Mail();
            for (Node child = mailElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.hasChildNodes()) continue;
                if (child.getLocalName().equals("from")) {
                    mail.setFrom(child.getFirstChild().getNodeValue());
                }
                if (child.getLocalName().equals("reply-to")) {
                    mail.setReplyTo(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("to")) {
                    mail.addTo(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("cc")) {
                    mail.addCC(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("bcc")) {
                    mail.addBCC(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("subject")) {
                    mail.setSubject(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("message")) {
                    for (Node bodyPart = child.getFirstChild(); bodyPart != null; bodyPart = bodyPart.getNextSibling()) {
                        if (bodyPart.getLocalName().equals("text")) {
                            mail.setText(bodyPart.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!bodyPart.getLocalName().equals("xhtml")) continue;
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        DOMSource source = new DOMSource(bodyPart.getFirstChild());
                        StringWriter strWriter = new StringWriter();
                        StreamResult result = new StreamResult(strWriter);
                        transformer.transform(source, result);
                        mail.setXHTML(strWriter.toString());
                    }
                    continue;
                }
                if (!child.getLocalName().equals("attachment")) continue;
                Element attachment = (Element)child;
                MailAttachment ma = new MailAttachment(attachment.getAttribute("filename"), attachment.getAttribute("mimetype"), attachment.getFirstChild().getNodeValue());
                mail.addAttachment(ma);
            }
            mails.add(mail);
        }
        return mails;
    }

    private List<Message> parseMessageElement(Session session, List<Element> mailElements) throws IOException, MessagingException, TransformerException {
        ArrayList<Message> mails = new ArrayList<Message>();
        for (Element mailElement : mailElements) {
            if (!mailElement.getLocalName().equals("mail")) continue;
            MimeMessage msg = new MimeMessage(session);
            ArrayList<InternetAddress> replyTo = new ArrayList<InternetAddress>();
            boolean fromWasSet = false;
            MimeBodyPart body = null;
            MimeMultipart multibody = null;
            ArrayList<MimeBodyPart> attachments = new ArrayList<MimeBodyPart>();
            CharSequence firstContent = null;
            String firstContentType = null;
            String firstCharset = null;
            String firstEncoding = null;
            for (Node child = mailElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                StreamResult result;
                StringWriter strWriter;
                DOMSource source;
                Transformer transformer;
                TransformerFactory transFactory;
                CharSequence content;
                if (child.getNodeType() != 1 || !child.hasChildNodes()) continue;
                if (child.getLocalName().equals("from")) {
                    InternetAddress[] addressFrom = new InternetAddress[]{new InternetAddress(child.getFirstChild().getNodeValue())};
                    msg.addFrom((Address[])addressFrom);
                    fromWasSet = true;
                    continue;
                }
                if (child.getLocalName().equals("reply-to")) {
                    replyTo.add(new InternetAddress(child.getFirstChild().getNodeValue()));
                    msg.setReplyTo((Address[])replyTo.toArray(new InternetAddress[0]));
                    continue;
                }
                if (child.getLocalName().equals("to")) {
                    msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(child.getFirstChild().getNodeValue()));
                    continue;
                }
                if (child.getLocalName().equals("cc")) {
                    msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(child.getFirstChild().getNodeValue()));
                    continue;
                }
                if (child.getLocalName().equals("bcc")) {
                    msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(child.getFirstChild().getNodeValue()));
                    continue;
                }
                if (child.getLocalName().equals("subject")) {
                    msg.setSubject(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("header")) {
                    msg.addHeader(((Element)child).getAttribute("name"), child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("message")) {
                    Node bodyPart = child.getFirstChild();
                    while (bodyPart != null) {
                        if (bodyPart.getNodeType() != 1) continue;
                        Element elementBodyPart = (Element)bodyPart;
                        content = null;
                        String contentType = null;
                        if (bodyPart.getLocalName().equals("text")) {
                            content = bodyPart.getFirstChild().getNodeValue();
                            contentType = "plain";
                        } else if (bodyPart.getLocalName().equals("xhtml")) {
                            transFactory = TransformerFactory.newInstance();
                            transformer = transFactory.newTransformer();
                            source = new DOMSource(bodyPart.getFirstChild());
                            strWriter = new StringWriter();
                            result = new StreamResult(strWriter);
                            transformer.transform(source, result);
                            content = strWriter.toString();
                            contentType = "html";
                        } else if (bodyPart.getLocalName().equals("generic")) {
                            content = elementBodyPart.getFirstChild().getNodeValue();
                            contentType = elementBodyPart.getAttribute("type");
                        }
                        if (content != null && contentType != null && contentType.length() > 0) {
                            String charset = elementBodyPart.getAttribute("charset");
                            String encoding = elementBodyPart.getAttribute("encoding");
                            if (body != null && multibody == null) {
                                multibody = new MimeMultipart("alternative");
                                multibody.addBodyPart(body);
                            }
                            if (charset == null || charset.length() == 0) {
                                charset = "UTF-8";
                            }
                            if (encoding == null || encoding.length() == 0) {
                                encoding = "quoted-printable";
                            }
                            if (body == null) {
                                firstContent = content;
                                firstCharset = charset;
                                firstContentType = contentType;
                                firstEncoding = encoding;
                            }
                            body = new MimeBodyPart();
                            body.setText((String)content, charset, contentType);
                            if (encoding != null) {
                                body.setHeader("Content-Transfer-Encoding", encoding);
                            }
                            if (multibody != null) {
                                multibody.addBodyPart((BodyPart)body);
                            }
                        }
                        bodyPart = bodyPart.getNextSibling();
                    }
                    continue;
                }
                if (!child.getLocalName().equals("attachment")) continue;
                Element attachment = (Element)child;
                MimeBodyPart part = new MimeBodyPart();
                content = new StringBuilder();
                for (Node attachChild = attachment.getFirstChild(); attachChild != null; attachChild = attachChild.getNextSibling()) {
                    if (attachChild.getNodeType() == 1) {
                        transFactory = TransformerFactory.newInstance();
                        transformer = transFactory.newTransformer();
                        source = new DOMSource(attachChild);
                        strWriter = new StringWriter();
                        result = new StreamResult(strWriter);
                        transformer.transform(source, result);
                        ((StringBuilder)content).append(strWriter.toString());
                        continue;
                    }
                    ((StringBuilder)content).append(attachChild.getNodeValue());
                }
                part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(((StringBuilder)content).toString(), attachment.getAttribute("mimetype"))));
                part.setFileName(attachment.getAttribute("filename"));
                attachments.add(part);
            }
            if (!fromWasSet) {
                msg.setFrom();
            }
            if (attachments.size() > 0) {
                if (multibody == null) {
                    multibody = new MimeMultipart();
                    if (body != null) {
                        multibody.addBodyPart(body);
                    }
                }
                for (MimeBodyPart part : attachments) {
                    multibody.addBodyPart((BodyPart)part);
                }
            }
            if (multibody != null) {
                msg.setContent(multibody);
            } else if (body != null) {
                msg.setText(firstContent, firstCharset, firstContentType);
                if (firstEncoding != null) {
                    msg.setHeader("Content-Transfer-Encoding", firstEncoding);
                }
            }
            msg.saveChanges();
            mails.add((Message)msg);
        }
        return mails;
    }

    private String getDateRFC822() {
        String tSecond;
        String tMinute;
        String dateString = new String();
        Calendar rightNow = Calendar.getInstance();
        switch (rightNow.get(7)) {
            case 2: {
                dateString = "Mon";
                break;
            }
            case 3: {
                dateString = "Tue";
                break;
            }
            case 4: {
                dateString = "Wed";
                break;
            }
            case 5: {
                dateString = "Thu";
                break;
            }
            case 6: {
                dateString = "Fri";
                break;
            }
            case 7: {
                dateString = "Sat";
                break;
            }
            case 1: {
                dateString = "Sun";
            }
        }
        dateString = dateString + ", ";
        dateString = dateString + rightNow.get(5);
        dateString = dateString + " ";
        switch (rightNow.get(2)) {
            case 0: {
                dateString = dateString + "Jan";
                break;
            }
            case 1: {
                dateString = dateString + "Feb";
                break;
            }
            case 2: {
                dateString = dateString + "Mar";
                break;
            }
            case 3: {
                dateString = dateString + "Apr";
                break;
            }
            case 4: {
                dateString = dateString + "May";
                break;
            }
            case 5: {
                dateString = dateString + "Jun";
                break;
            }
            case 6: {
                dateString = dateString + "Jul";
                break;
            }
            case 7: {
                dateString = dateString + "Aug";
                break;
            }
            case 8: {
                dateString = dateString + "Sep";
                break;
            }
            case 9: {
                dateString = dateString + "Oct";
                break;
            }
            case 10: {
                dateString = dateString + "Nov";
                break;
            }
            case 11: {
                dateString = dateString + "Dec";
            }
        }
        dateString = dateString + " ";
        dateString = dateString + rightNow.get(1);
        dateString = dateString + " ";
        String tHour = Integer.toString(rightNow.get(11));
        if (tHour.length() == 1) {
            tHour = "0" + tHour;
        }
        if ((tMinute = Integer.toString(rightNow.get(12))).length() == 1) {
            tMinute = "0" + tMinute;
        }
        if ((tSecond = Integer.toString(rightNow.get(13))).length() == 1) {
            tSecond = "0" + tSecond;
        }
        dateString = dateString + tHour + ":" + tMinute + ":" + tSecond + " ";
        String tzSign = new String();
        String tzHours = new String();
        String tzMinutes = new String();
        TimeZone thisTZ = rightNow.getTimeZone();
        int tzOffset = thisTZ.getOffset(rightNow.getTime().getTime());
        tzOffset /= 1000;
        if ((tzOffset /= 60) > 1) {
            tzSign = "+";
        } else {
            tzSign = "-";
            tzOffset *= -1;
        }
        if (tzOffset >= 60) {
            if ((tzHours = tzHours + tzOffset / 60).length() == 1) {
                tzHours = "0" + tzHours;
            }
            if ((tzMinutes = tzMinutes + tzOffset % 60).length() == 1) {
                tzMinutes = "0" + tzMinutes;
            }
        } else {
            tzHours = "00";
            if ((tzMinutes = tzMinutes + tzOffset).length() == 1) {
                tzMinutes = "0" + tzMinutes;
            }
        }
        dateString = dateString + tzSign + tzHours + tzMinutes;
        return dateString;
    }

    private String encode64(String str) throws UnsupportedEncodingException {
        Base64Encoder enc = new Base64Encoder();
        enc.translate(str.getBytes(this.charset));
        String result = new String(enc.getCharArray());
        result = result.replaceAll("\n", "?=\n =?" + this.charset + "?B?");
        result = "=?" + this.charset + "?B?" + result + "?=";
        return result;
    }

    private String encode64Address(String str) throws UnsupportedEncodingException {
        int idx = str.indexOf("<");
        String result = idx != -1 ? this.encode64(str.substring(0, idx)) + " " + str.substring(idx) : str;
        return result;
    }

    private class Mail {
        private String from = "";
        private String replyTo = null;
        private List<String> to = new ArrayList<String>();
        private List<String> cc = new ArrayList<String>();
        private List<String> bcc = new ArrayList<String>();
        private String subject = "";
        private String text = "";
        private String xhtml = "";
        private List<MailAttachment> attachment = new ArrayList<MailAttachment>();

        private Mail() {
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getFrom() {
            return this.from;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void addTo(String to) {
            this.to.add(to);
        }

        public int countTo() {
            return this.to.size();
        }

        public String getTo(int index) {
            return this.to.get(index);
        }

        public List<String> getTo() {
            return this.to;
        }

        public void addCC(String cc) {
            this.cc.add(cc);
        }

        public int countCC() {
            return this.cc.size();
        }

        public String getCC(int index) {
            return this.cc.get(index);
        }

        public List<String> getCC() {
            return this.cc;
        }

        public void addBCC(String bcc) {
            this.bcc.add(bcc);
        }

        public int countBCC() {
            return this.bcc.size();
        }

        public String getBCC(int index) {
            return this.bcc.get(index);
        }

        public List<String> getBCC() {
            return this.bcc;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setXHTML(String xhtml) {
            this.xhtml = xhtml;
        }

        public String getXHTML() {
            return this.xhtml;
        }

        public void addAttachment(MailAttachment ma) {
            this.attachment.add(ma);
        }

        public Iterator<MailAttachment> attachmentIterator() {
            return this.attachment.iterator();
        }
    }

    private class MailAttachment {
        private String filename;
        private String mimeType;
        private String data;

        public MailAttachment(String filename, String mimeType, String data) {
            this.filename = filename;
            this.mimeType = mimeType;
            this.data = data;
        }

        public String getData() {
            return this.data;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    private class SMTPException
    extends Exception {
        private static final long serialVersionUID = 4859093648476395159L;

        public SMTPException(String message) {
            super(message);
        }

        public SMTPException(Throwable cause) {
            super(cause);
        }
    }
}

