/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.math;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class TwoParamFunctions
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(TwoParamFunctions.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("atan2", "http://exist-db.org/xquery/math"), "Returns the angle theta from the conversion of rectangular coordinates (x, y) to polar coordinates (r, theta).", new SequenceType[]{new FunctionParameterSequenceType("y", 34, 2, "The y coordinate"), new FunctionParameterSequenceType("x", 34, 2, "The x coordinate")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the theta component of the point (r, theta) in polar coordinates that corresponds to the point (x, y) in Cartesian coordinates."), "Replaced by http://www.w3.org/2005/xpath-functions/math/#atan2"), new FunctionSignature(new QName("power", "http://exist-db.org/xquery/math"), "Returns the value of $value raised to the power of $power.", new SequenceType[]{new FunctionParameterSequenceType("value", 34, 2, "The value"), new FunctionParameterSequenceType("power", 34, 2, "The power to raise the value to")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the result"), "Replaced by http://www.w3.org/2005/xpath-functions/math/#pow")};

    public TwoParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        double calcValue = 0.0;
        String functionName = this.getSignature().getName().getLocalName();
        AtomicValue seqA = args[0].convertTo(34);
        NumericValue valueA = (NumericValue)seqA.itemAt(0).convertTo(34);
        AtomicValue seqB = args[1].convertTo(34);
        NumericValue valueB = (NumericValue)seqB.itemAt(0).convertTo(34);
        if ("atan2".equals(functionName)) {
            calcValue = Math.atan2(valueA.getDouble(), valueB.getDouble());
        } else if ("power".equals(functionName)) {
            calcValue = Math.pow(valueA.getDouble(), valueB.getDouble());
        } else {
            throw new XPathException((Expression)this, "Function " + functionName + " not found.");
        }
        DoubleValue result = new DoubleValue(calcValue);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", (Sequence)result);
        }
        return result;
    }
}

