/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.persistentlogin;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.persistentlogin.PersistentLogin;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class PersistentLoginFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("register", "http://exist-db.org/xquery/persistentlogin", "plogin"), "Try to log in the user and create a one-time login token. The token can be stored to a cookie and used to log in (via the login function) as the same user without providing credentials. However, for security reasons the token will be valid only for the next request to the login function and is deleted afterwards. If the user is valid and the token could be generated, the supplied callback function is called with 4 arguments: $token as xs:string, $user as xs:string, $password as xs:string, $timeToLive as xs:duration.", new SequenceType[]{new FunctionParameterSequenceType("user", 22, 2, "user name"), new FunctionParameterSequenceType("password", 22, 3, "password"), new FunctionParameterSequenceType("timeToLive", 53, 2, "duration for which the user is remembered"), new FunctionParameterSequenceType("onLogin", 101, 3, "callback function to be called when the login succeeds")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "result of the callback function or the empty sequence")), new FunctionSignature(new QName("login", "http://exist-db.org/xquery/persistentlogin", "plogin"), "Try to log in the user based on the supplied token. If the login succeeds, the provided callback function is called with 4 arguments: $token as xs:string, $user as xs:string, $password as xs:string, $timeToLive as duration. $token will be a new token which can be used for the next request. The old token is deleted.", new SequenceType[]{new FunctionParameterSequenceType("token", 22, 2, "a valid one-time token"), new FunctionParameterSequenceType("onLogin", 101, 3, "callback function to be called when the login succeeds")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "result of the callback function or the empty sequence")), new FunctionSignature(new QName("invalidate", "http://exist-db.org/xquery/persistentlogin", "plogin"), "Invalidate the supplied one-time token, so it can no longer be used to log in.", new SequenceType[]{new FunctionParameterSequenceType("token", 22, 2, "a valid one-time token")}, (SequenceType)new FunctionReturnSequenceType(10, 2, "empty sequence"))};
    private AnalyzeContextInfo cachedContextInfo;

    public PersistentLoginFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("register")) {
            String user = args[0].getStringValue();
            String pass = null;
            if (!args[1].isEmpty()) {
                pass = args[1].getStringValue();
            }
            DurationValue timeToLive = (DurationValue)args[2].itemAt(0);
            FunctionReference callback = null;
            if (!args[3].isEmpty()) {
                callback = (FunctionReference)args[3].itemAt(0);
            }
            return this.register(user, pass, timeToLive, callback);
        }
        if (this.isCalledAs("login")) {
            String token = args[0].getStringValue();
            FunctionReference callback = null;
            if (!args[1].isEmpty()) {
                callback = (FunctionReference)args[1].itemAt(0);
            }
            return this.authenticate(token, callback);
        }
        PersistentLogin.getInstance().invalidate(args[0].getStringValue());
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence register(String user, String pass, DurationValue timeToLive, FunctionReference callback) throws XPathException {
        if (this.login(user, pass)) {
            PersistentLogin.LoginDetails details = PersistentLogin.getInstance().register(user, pass, timeToLive);
            return this.callback(callback, null, details);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence authenticate(String token, FunctionReference callback) throws XPathException {
        PersistentLogin.LoginDetails data = PersistentLogin.getInstance().lookup(token);
        if (data == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.login(data.getUser(), data.getPassword())) {
            return this.callback(callback, token, data);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private boolean login(String user, String pass) throws XPathException {
        try {
            SecurityManager sm = BrokerPool.getInstance().getSecurityManager();
            Subject subject = sm.authenticate(user, (Object)pass);
            if (subject == null) {
                return false;
            }
            this.context.getBroker().setSubject(subject);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
        catch (EXistException e) {
            return false;
        }
    }

    private Sequence callback(FunctionReference func, String oldToken, PersistentLogin.LoginDetails details) throws XPathException {
        Sequence[] args = new Sequence[4];
        String newToken = details.toString();
        args[0] = oldToken != null && oldToken.equals(newToken) ? Sequence.EMPTY_SEQUENCE : new StringValue(newToken);
        args[1] = new StringValue(details.getUser());
        args[2] = new StringValue(details.getPassword());
        args[3] = details.getTimeToLive();
        func.analyze(this.cachedContextInfo);
        return func.evalFunction(null, null, args);
    }
}

