/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.exist.dom.QName;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJob;
import org.exist.security.Subject;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class GetScheduledJobs
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-scheduled-jobs", "http://exist-db.org/xquery/scheduler", "scheduler"), "Gets the details of all scheduled jobs in the form: <scheduler:jobs xmlns:scheduler=\"http://exist-db.org/xquery/scheduler\" count=\"iJobs\">    <scheduler:group name=\"group\">        <scheduler:job name=\"\">            <scheduler:trigger name=\"\">                <expression></expression>                <state></state>                <start></start>                <end></end>                <previous></previous>                <next></next>                <final></final>            </scheduler:trigger>        </scheduler:job>    </scheduler:group></scheduler:jobs>", null, (SequenceType)new FunctionReturnSequenceType(-1, 2, "the XML containing the list of jobs"));
    private Scheduler scheduler = null;

    public GetScheduledJobs(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Subject user = this.context.getUser();
        boolean userhasDBARole = user.hasDbaRole();
        StringBuilder xmlBuf = new StringBuilder();
        int iJobs = 0;
        List groups = this.scheduler.getJobGroupNames();
        List scheduledJobs = this.scheduler.getScheduledJobs();
        for (int g = 0; g < groups.size(); ++g) {
            if (!userhasDBARole && !((String)groups.get(g)).equals(UserJob.JOB_GROUP)) continue;
            xmlBuf.append("<scheduler:group name=\"" + (String)groups.get(g) + "\">");
            for (int j = 0; j < scheduledJobs.size(); ++j) {
                if (!((ScheduledJobInfo)scheduledJobs.get(j)).getGroup().equals(groups.get(g))) continue;
                xmlBuf.append("<scheduler:job name=\"" + ((ScheduledJobInfo)scheduledJobs.get(j)).getName() + "\">");
                xmlBuf.append("<scheduler:trigger name=\"" + ((ScheduledJobInfo)scheduledJobs.get(j)).getTriggerName() + "\">");
                xmlBuf.append("<expression>");
                xmlBuf.append(((ScheduledJobInfo)scheduledJobs.get(j)).getTriggerExpression());
                xmlBuf.append("</expression>");
                xmlBuf.append("<state>");
                xmlBuf.append(((ScheduledJobInfo)scheduledJobs.get(j)).getTriggerState());
                xmlBuf.append("</state>");
                xmlBuf.append("<start>");
                xmlBuf.append(new DateTimeValue(((ScheduledJobInfo)scheduledJobs.get(j)).getStartTime()));
                xmlBuf.append("</start>");
                xmlBuf.append("<end>");
                Date endTime = ((ScheduledJobInfo)scheduledJobs.get(j)).getEndTime();
                if (endTime != null) {
                    xmlBuf.append(new DateTimeValue(endTime));
                }
                xmlBuf.append("</end>");
                xmlBuf.append("<previous>");
                Date previousTime = ((ScheduledJobInfo)scheduledJobs.get(j)).getPreviousFireTime();
                if (previousTime != null) {
                    xmlBuf.append(new DateTimeValue(((ScheduledJobInfo)scheduledJobs.get(j)).getPreviousFireTime()));
                }
                xmlBuf.append("</previous>");
                xmlBuf.append("<next>");
                Date nextTime = ((ScheduledJobInfo)scheduledJobs.get(j)).getNextFireTime();
                if (nextTime != null) {
                    xmlBuf.append(new DateTimeValue());
                }
                xmlBuf.append("</next>");
                xmlBuf.append("<final>");
                Date finalTime = ((ScheduledJobInfo)scheduledJobs.get(j)).getFinalFireTime();
                if (endTime != null && finalTime != null) {
                    xmlBuf.append(new DateTimeValue());
                }
                xmlBuf.append("</final>");
                xmlBuf.append("</scheduler:trigger>");
                xmlBuf.append("</scheduler:job>");
                ++iJobs;
            }
            xmlBuf.append("</scheduler:group>");
        }
        xmlBuf.insert(0, "<scheduler:jobs xmlns:scheduler=\"http://exist-db.org/xquery/scheduler\" count=\"" + iJobs + "\">");
        xmlBuf.append("</scheduler:jobs>");
        try {
            return ModuleUtils.stringToXML((XQueryContext)this.context, (String)xmlBuf.toString());
        }
        catch (SAXException se) {
            throw new XPathException((Expression)this, se.getMessage(), (Throwable)se);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
    }
}

