/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import org.exist.dom.QName;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJob;
import org.exist.security.Subject;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class PauseScheduledJob
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("pause-scheduled-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Pause the named job in the scheduler. Will only pause user scheduled jobs!", new SequenceType[]{new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job in the scheduler")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "the success of the pausing of the named job"));
    private Scheduler scheduler = null;

    public PauseScheduledJob(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String jobName = args[0].getStringValue();
        Subject user = this.context.getUser();
        if (!user.hasDbaRole()) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.valueOf((boolean)this.scheduler.pauseJob(jobName, UserJob.JOB_GROUP));
    }
}

