/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.AppendingSAXAdapter;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.ReferenceNode;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.PreparedStatementWithSQL;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.modules.sql.SQLUtils;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ExecuteFunction
extends BasicFunction {
    private static final Logger LOG = Logger.getLogger(ExecuteFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("execute", "http://exist-db.org/xquery/sql", "sql"), "Executes a SQL statement against a SQL db using the connection indicated by the connection handle.", new SequenceType[]{new FunctionParameterSequenceType("connection-handle", 37, 2, "The connection handle"), new FunctionParameterSequenceType("sql-statement", 22, 2, "The SQL statement"), new FunctionParameterSequenceType("make-node-from-column-name", 23, 2, "The flag that indicates whether the xml nodes should be formed from the column names (in this mode a space in a Column Name will be replaced by an underscore!)")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the results")), new FunctionSignature(new QName("execute", "http://exist-db.org/xquery/sql", "sql"), "Executes a prepared SQL statement against a SQL db.", new SequenceType[]{new FunctionParameterSequenceType("connection-handle", 37, 2, "The connection handle"), new FunctionParameterSequenceType("statement-handle", 31, 2, "The prepared statement handle"), new FunctionParameterSequenceType("parameters", 1, 3, "Parameters for the prepared statement. e.g. <sql:parameters><sql:param sql:type=\"varchar\">value</sql:param></sql:parameters>"), new FunctionParameterSequenceType("make-node-from-column-name", 23, 2, "The flag that indicates whether the xml nodes should be formed from the column names (in this mode a space in a Column Name will be replaced by an underscore!)")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the results"))};
    private static final String PARAMETERS_ELEMENT_NAME = "parameters";
    private static final String PARAM_ELEMENT_NAME = "param";
    private static final String TYPE_ATTRIBUTE_NAME = "type";

    public ExecuteFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        Connection con = SQLModule.retrieveConnection(this.context, connectionUID);
        if (con == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean preparedStmt = false;
        String sql = null;
        Statement stmt = null;
        boolean executeResult = false;
        ResultSet rs = null;
        try {
            boolean makeNodeFromColumnName = false;
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            int iRow = 0;
            if (args.length == 3) {
                sql = args[1].getStringValue();
                stmt = con.createStatement();
                makeNodeFromColumnName = ((BooleanValue)args[2].itemAt(0)).effectiveBooleanValue();
                executeResult = stmt.execute(sql);
            } else if (args.length == 4) {
                preparedStmt = true;
                long statementUID = ((IntegerValue)args[1].itemAt(0)).getLong();
                PreparedStatementWithSQL stmtWithSQL = SQLModule.retrievePreparedStatement(this.context, statementUID);
                sql = stmtWithSQL.getSql();
                stmt = stmtWithSQL.getStmt();
                makeNodeFromColumnName = ((BooleanValue)args[3].itemAt(0)).effectiveBooleanValue();
                if (!args[2].isEmpty()) {
                    this.setParametersOnPreparedStatement(stmt, (Element)args[2].itemAt(0));
                }
                executeResult = ((PreparedStatement)stmt).execute();
            }
            if (executeResult) {
                rs = stmt.getResultSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int iColumns = rsmd.getColumnCount();
                builder.startDocument();
                builder.startElement(new QName("result", "http://exist-db.org/xquery/sql", "sql"), null);
                builder.addAttribute(new QName("count", null, null), String.valueOf(-1));
                while (rs.next()) {
                    builder.startElement(new QName("row", "http://exist-db.org/xquery/sql", "sql"), null);
                    builder.addAttribute(new QName("index", null, null), String.valueOf(rs.getRow()));
                    for (int i = 0; i < iColumns; ++i) {
                        String columnName = rsmd.getColumnLabel(i + 1);
                        if (columnName == null) continue;
                        String colElement = "field";
                        if (makeNodeFromColumnName && columnName.length() > 0) {
                            colElement = SQLUtils.escapeXmlAttr(columnName.replace(' ', '_'));
                        }
                        builder.startElement(new QName(colElement, "http://exist-db.org/xquery/sql", "sql"), null);
                        if (!makeNodeFromColumnName || columnName.length() <= 0) {
                            String name = columnName.length() > 0 ? SQLUtils.escapeXmlAttr(columnName) : "Column: " + String.valueOf(i + 1);
                            builder.addAttribute(new QName("name", null, null), name);
                        }
                        builder.addAttribute(new QName(TYPE_ATTRIBUTE_NAME, "http://exist-db.org/xquery/sql", "sql"), rsmd.getColumnTypeName(i + 1));
                        builder.addAttribute(new QName(TYPE_ATTRIBUTE_NAME, "http://www.w3.org/2001/XMLSchema", "xs"), Type.getTypeName((int)SQLUtils.sqlTypeToXMLType(rsmd.getColumnType(i + 1))));
                        if (rsmd.getColumnType(i + 1) == 2009) {
                            try {
                                SQLXML sqlXml = rs.getSQLXML(i + 1);
                                if (rs.wasNull()) {
                                    builder.addAttribute(new QName("null", "http://exist-db.org/xquery/sql", "sql"), "true");
                                }
                                SAXParserFactory factory = SAXParserFactory.newInstance();
                                factory.setNamespaceAware(true);
                                InputSource src = new InputSource(sqlXml.getCharacterStream());
                                SAXParser parser = factory.newSAXParser();
                                XMLReader xr = parser.getXMLReader();
                                AppendingSAXAdapter adapter = new AppendingSAXAdapter(builder);
                                xr.setContentHandler((ContentHandler)adapter);
                                xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
                                xr.parse(src);
                            }
                            catch (Exception e) {
                                throw new XPathException("Could not parse column of type SQLXML: " + e.getMessage(), (Throwable)e);
                            }
                        } else {
                            String colValue = rs.getString(i + 1);
                            if (rs.wasNull()) {
                                builder.addAttribute(new QName("null", "http://exist-db.org/xquery/sql", "sql"), "true");
                            } else if (colValue != null) {
                                builder.characters((CharSequence)SQLUtils.escapeXmlText(colValue));
                            }
                        }
                        builder.endElement();
                    }
                    builder.endElement();
                    ++iRow;
                }
                builder.endElement();
            } else {
                builder.startDocument();
                builder.startElement(new QName("result", "http://exist-db.org/xquery/sql", "sql"), null);
                builder.addAttribute(new QName("updateCount", null, null), String.valueOf(stmt.getUpdateCount()));
                builder.endElement();
            }
            NodeValue node = (NodeValue)builder.getDocument().getDocumentElement();
            Node count = node.getNode().getAttributes().getNamedItem("count");
            if (count != null) {
                count.setNodeValue(String.valueOf(iRow));
            }
            builder.endDocument();
            NodeValue i = node;
            return i;
        }
        catch (SQLException sqle) {
            Element parametersElement;
            LOG.error((Object)("sql:execute() Caught SQLException \"" + sqle.getMessage() + "\" for SQL: \"" + sql + "\""), (Throwable)sqle);
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(new QName("exception", "http://exist-db.org/xquery/sql", "sql"), null);
            boolean recoverable = false;
            if (sqle instanceof SQLRecoverableException) {
                recoverable = true;
            }
            builder.addAttribute(new QName("recoverable", null, null), String.valueOf(recoverable));
            builder.startElement(new QName("state", "http://exist-db.org/xquery/sql", "sql"), null);
            builder.characters((CharSequence)sqle.getSQLState());
            builder.endElement();
            builder.startElement(new QName("message", "http://exist-db.org/xquery/sql", "sql"), null);
            String state = sqle.getMessage();
            if (state != null) {
                builder.characters((CharSequence)state);
            }
            builder.endElement();
            builder.startElement(new QName("stack-trace", "http://exist-db.org/xquery/sql", "sql"), null);
            ByteArrayOutputStream bufStackTrace = new ByteArrayOutputStream();
            sqle.printStackTrace(new PrintStream((OutputStream)bufStackTrace));
            builder.characters((CharSequence)new String(bufStackTrace.toByteArray()));
            builder.endElement();
            builder.startElement(new QName("sql", "http://exist-db.org/xquery/sql", "sql"), null);
            builder.characters((CharSequence)SQLUtils.escapeXmlText(sql));
            builder.endElement();
            if (stmt instanceof PreparedStatement && (parametersElement = (Element)args[2].itemAt(0)).getNamespaceURI().equals("http://exist-db.org/xquery/sql") && parametersElement.getLocalName().equals(PARAMETERS_ELEMENT_NAME)) {
                NodeList paramElements = parametersElement.getElementsByTagNameNS("http://exist-db.org/xquery/sql", PARAM_ELEMENT_NAME);
                builder.startElement(new QName(PARAMETERS_ELEMENT_NAME, "http://exist-db.org/xquery/sql", "sql"), null);
                for (int i = 0; i < paramElements.getLength(); ++i) {
                    Element param = (Element)paramElements.item(i);
                    String value = param.getFirstChild().getNodeValue();
                    String type = param.getAttributeNS("http://exist-db.org/xquery/sql", TYPE_ATTRIBUTE_NAME);
                    builder.startElement(new QName(PARAM_ELEMENT_NAME, "http://exist-db.org/xquery/sql", "sql"), null);
                    builder.addAttribute(new QName(TYPE_ATTRIBUTE_NAME, "http://exist-db.org/xquery/sql", "sql"), type);
                    builder.characters((CharSequence)SQLUtils.escapeXmlText(value));
                    builder.endElement();
                }
                builder.endElement();
            }
            builder.startElement(new QName("xquery", "http://exist-db.org/xquery/sql", "sql"), null);
            builder.addAttribute(new QName("line", null, null), String.valueOf(this.getLine()));
            builder.addAttribute(new QName("column", null, null), String.valueOf(this.getColumn()));
            builder.endElement();
            builder.endElement();
            builder.endDocument();
            NodeValue nodeValue = (NodeValue)builder.getDocument().getDocumentElement();
            return nodeValue;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                    LOG.warn((Object)"Unable to cleanup JDBC results", (Throwable)se);
                }
                rs = null;
            }
            if (!preparedStmt && stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException se) {
                    LOG.warn((Object)"Unable to cleanup JDBC results", (Throwable)se);
                }
                stmt = null;
            }
        }
    }

    private void setParametersOnPreparedStatement(Statement stmt, Element parametersElement) throws SQLException, XPathException {
        if (parametersElement.getNamespaceURI().equals("http://exist-db.org/xquery/sql") && parametersElement.getLocalName().equals(PARAMETERS_ELEMENT_NAME)) {
            NodeList paramElements = parametersElement.getElementsByTagNameNS("http://exist-db.org/xquery/sql", PARAM_ELEMENT_NAME);
            for (int i = 0; i < paramElements.getLength(); ++i) {
                Element param = (Element)paramElements.item(i);
                Node child = param.getFirstChild();
                if (child instanceof ReferenceNode) {
                    child = ((ReferenceNode)child).getReference().getNode();
                }
                String value = child.getNodeValue();
                String type = param.getAttributeNS("http://exist-db.org/xquery/sql", TYPE_ATTRIBUTE_NAME);
                int sqlType = SQLUtils.sqlTypeFromString(type);
                if (sqlType == 93) {
                    DateTimeValue dv = new DateTimeValue(value);
                    Timestamp timestampValue = new Timestamp(dv.getDate().getTime());
                    ((PreparedStatement)stmt).setTimestamp(i + 1, timestampValue);
                    continue;
                }
                ((PreparedStatement)stmt).setObject(i + 1, (Object)value, sqlType);
            }
        }
    }
}

