/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetJNDIConnectionFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(GetJNDIConnectionFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-jndi-connection", "http://exist-db.org/xquery/sql", "sql"), "Opens a connection to a SQL Database.", new SequenceType[]{new FunctionParameterSequenceType("jndi-name", 22, 2, "The JNDI name")}, (SequenceType)new FunctionParameterSequenceType("handle", 37, 3, "an xs:long representing the connection handle")), new FunctionSignature(new QName("get-jndi-connection", "http://exist-db.org/xquery/sql", "sql"), "Opens a connection to a SQL Database.", new SequenceType[]{new FunctionParameterSequenceType("jndi-name", 22, 2, "The JNDI name"), new FunctionParameterSequenceType("username", 22, 2, "The username"), new FunctionParameterSequenceType("password", 22, 2, "The password")}, (SequenceType)new FunctionParameterSequenceType("handle", 37, 3, "an xs:long representing the connection handle"))};

    public GetJNDIConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            Connection con = null;
            String jndiName = args[0].getStringValue();
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            if (args.length == 1) {
                con = ds.getConnection();
            }
            if (args.length == 3) {
                String jndiUser = args[1].getStringValue();
                String jndiPassword = args[2].getStringValue();
                con = ds.getConnection(jndiUser, jndiPassword);
            }
            return new IntegerValue(SQLModule.storeConnection(this.context, con));
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, e.getMessage());
        }
    }
}

