/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

public final class SQLUtils {
    public static int sqlTypeFromString(String sqlType) {
        if ((sqlType = sqlType.toUpperCase()).equals("ARRAY")) {
            return 2003;
        }
        if (sqlType.equals("BIGINT")) {
            return -5;
        }
        if (sqlType.equals("BINARY")) {
            return -2;
        }
        if (sqlType.equals("BIT")) {
            return -7;
        }
        if (sqlType.equals("BLOB")) {
            return 2004;
        }
        if (sqlType.equals("BOOLEAN")) {
            return 16;
        }
        if (sqlType.equals("CHAR")) {
            return 1;
        }
        if (sqlType.equals("CLOB")) {
            return 2005;
        }
        if (sqlType.equals("DECIMAL")) {
            return 3;
        }
        if (sqlType.equals("DOUBLE")) {
            return 8;
        }
        if (sqlType.equals("FLOAT")) {
            return 6;
        }
        if (sqlType.equals("LONGVARCHAR")) {
            return -1;
        }
        if (sqlType.equals("NUMERIC")) {
            return 2;
        }
        if (sqlType.equals("SMALLINT")) {
            return 5;
        }
        if (sqlType.equals("TINYINT")) {
            return -6;
        }
        if (sqlType.equals("INTEGER")) {
            return 4;
        }
        if (sqlType.equals("VARCHAR")) {
            return 12;
        }
        if (sqlType.equals("SQLXML")) {
            return 2009;
        }
        if (sqlType.equals("TIMESTAMP")) {
            return 93;
        }
        return 12;
    }

    public static int sqlTypeToXMLType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return -1;
            }
            case -5: {
                return 38;
            }
            case -2: {
                return 26;
            }
            case -7: {
                return 38;
            }
            case 2004: {
                return 26;
            }
            case 16: {
                return 23;
            }
            case 1: {
                return 22;
            }
            case 2005: {
                return 22;
            }
            case 3: {
                return 32;
            }
            case 8: {
                return 34;
            }
            case 6: {
                return 33;
            }
            case -1: {
                return 22;
            }
            case 2: {
                return 30;
            }
            case 5: {
                return 38;
            }
            case -6: {
                return 38;
            }
            case 4: {
                return 31;
            }
            case 12: {
                return 22;
            }
            case 2009: {
                return -1;
            }
            case 93: {
                return 50;
            }
        }
        return 12;
    }

    public static String escapeXmlText(String text) {
        String work = null;
        if (text != null) {
            work = text.replaceAll("\\&", "\\&amp;");
            work = work.replaceAll("<", "\\&lt;");
            work = work.replaceAll(">", "\\&gt;");
        }
        return work;
    }

    public static String escapeXmlAttr(String attr) {
        String work = null;
        if (attr != null) {
            work = SQLUtils.escapeXmlText(attr);
            work = work.replaceAll("'", "\\&apos;");
            work = work.replaceAll("\"", "\\&quot;");
        }
        return work;
    }
}

