/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xmlcalabash;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.drivers.Main;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.SAXAdapter;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ProcessFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(ProcessFunction.class);
    private XProcRuntime runtime = null;
    String outputResult;
    public static final FunctionSignature signature = new FunctionSignature(new QName("process", "http://xmlcalabash.com", "xmlcalabash"), "Function which invokes xmlcalabash XProc processor.", new SequenceType[]{new FunctionParameterSequenceType("pipeline", 22, 2, "XProc Pipeline"), new FunctionParameterSequenceType("output", 22, 2, "Output result")}, (SequenceType)new FunctionReturnSequenceType(11, 3, "return type"));

    public ProcessFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String pipelineURI = args[0].getStringValue();
        String outputURI = args[1].getStringValue();
        try {
            String[] calabash_args = new String[]{"-oresult=" + outputURI, pipelineURI};
            PrintStream stdout = System.out;
            Main main = new Main();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            System.setOut(new PrintStream((OutputStream)byteStream, true));
            main.run(calabash_args);
            this.outputResult = byteStream.toString();
            System.setOut(stdout);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        StringReader reader = new StringReader(this.outputResult);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(reader);
            XMLReader xr = null;
            if (xr == null) {
                SAXParser parser = factory.newSAXParser();
                xr = parser.getXMLReader();
            }
            SAXAdapter adapter = new SAXAdapter(this.context);
            xr.setContentHandler((ContentHandler)adapter);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            xr.parse(src);
            return (DocumentImpl)adapter.getDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XPathException((Expression)this, "Error while constructing XML parser: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
    }
}

