/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xslfo;

import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.xquery.modules.xslfo.ProcessorAdapter;
import org.exist.xquery.value.NodeValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ApacheFopProcessorAdapter
implements ProcessorAdapter {
    private static final Logger LOG = Logger.getLogger(ApacheFopProcessorAdapter.class);
    private final FopFactory fopFactory = FopFactory.newInstance();

    @Override
    public ContentHandler getContentHandler(DBBroker broker, NodeValue configFile, Properties parameters, String mimeType, OutputStream os) throws SAXException {
        if (configFile != null) {
            FopConfigurationBuilder cfgBuilder = new FopConfigurationBuilder(broker);
            Configuration cfg = cfgBuilder.buildFromNode(configFile);
            this.fopFactory.setUserConfig(cfg);
        }
        FOUserAgent foUserAgent = this.setupFOUserAgent(this.fopFactory.newFOUserAgent(), parameters);
        Fop fop = this.fopFactory.newFop(mimeType, foUserAgent, os);
        return fop.getDefaultHandler();
    }

    @Override
    public void cleanup() {
    }

    private FOUserAgent setupFOUserAgent(FOUserAgent foUserAgent, Properties parameters) {
        foUserAgent.setProducer("eXist-db with Apache FOP");
        if (parameters != null) {
            for (Map.Entry<Object, Object> paramEntry : parameters.entrySet()) {
                String key = (String)paramEntry.getKey();
                String value = (String)paramEntry.getValue();
                if (key.equals("FOPauthor")) {
                    foUserAgent.setAuthor(value);
                    continue;
                }
                if (key.equals("FOPtitle")) {
                    foUserAgent.setTitle(value);
                    continue;
                }
                if (key.equals("FOPkeywords")) {
                    foUserAgent.setTitle(value);
                    continue;
                }
                if (!key.equals("FOPdpi")) continue;
                try {
                    foUserAgent.setTargetResolution(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)("Unable to set DPI to: " + value));
                }
            }
        }
        return foUserAgent;
    }

    private class FopConfigurationBuilder
    extends DefaultConfigurationBuilder {
        DBBroker broker;

        public FopConfigurationBuilder(DBBroker broker) {
            this.broker = null;
            this.broker = broker;
        }

        public FopConfigurationBuilder(DBBroker broker, boolean enableNamespaces) {
            super(enableNamespaces);
            this.broker = null;
            this.broker = broker;
        }

        public Configuration buildFromNode(NodeValue configFile) throws SAXException {
            SAXConfigurationHandler handler = this.getHandler();
            handler.clear();
            configFile.toSAX(this.broker, (ContentHandler)handler, new Properties());
            return handler.getConfiguration();
        }
    }
}

