/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.util.Logger;

public class ClasspathStorage
extends Storage {
    private String myRoot;
    private static final Logger LOG = Logger.getLogger(ClasspathStorage.class);

    public ClasspathStorage(String root) {
        this.myRoot = root;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Storage.PackageResolver makePackageResolver(String rsrc_name, String abbrev) throws PackageException {
        String pkg_root = this.myRoot.replace('.', '/') + "/" + rsrc_name + "/";
        return new ClasspathResolver(pkg_root, abbrev, rsrc_name);
    }

    public InputStream resolveRsrc(String path) throws PackageException {
        String rsrc = this.myRoot.replace('.', '/') + "/" + path;
        ClassLoader loader = ClasspathStorage.class.getClassLoader();
        InputStream res = loader.getResourceAsStream(rsrc);
        LOG.fine("Resolve resource ''{0}'' to: {1}", path, res);
        return res;
    }

    public String toString() {
        return "Classpath storage in " + this.myRoot;
    }

    public static class ClasspathResolver
    extends Storage.PackageResolver {
        private String myPkgRoot;
        private String myContent;
        private String myRsrcName;
        private ClassLoader myLoader;

        public ClasspathResolver(String pkg_root, String abbrev, String rsrc_name) throws PackageException {
            this.myPkgRoot = pkg_root;
            this.myRsrcName = rsrc_name;
            this.myLoader = ClasspathResolver.class.getClassLoader();
            this.myContent = ClasspathResolver.getContent(this.myLoader, pkg_root, abbrev);
        }

        private static String getContent(ClassLoader loader, String pkg_root, String abbrev) throws PackageException {
            String old_style = pkg_root + abbrev + "/";
            String new_style = pkg_root + "content/";
            URL old_url = loader.getResource(old_style);
            URL new_url = loader.getResource(new_style);
            LOG.finer("Content dir ''{0}'' is ''{1}'', and ''{2}'' is ''{3}''", new_style, new_url, old_style, old_url);
            if (old_url == null && new_url == null) {
                String msg = "None of content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            if (old_url != null && new_url != null) {
                String msg = "Both content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            if (old_url == null) {
                return new_style;
            }
            LOG.info("Warning: package uses old-style content dir: ''{0}''", old_style);
            return old_style;
        }

        public String getResourceName() {
            return this.myRsrcName;
        }

        public StreamSource resolveResource(String path) throws PackageException {
            return this.resolveWithin(path, this.myPkgRoot);
        }

        public StreamSource resolveComponent(String path) throws PackageException {
            return this.resolveWithin(path, this.myContent);
        }

        private StreamSource resolveWithin(String path, String root) throws PackageException {
            String rsrc;
            InputStream in;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((in = this.myLoader.getResourceAsStream(rsrc = root + path)) == null) {
                return null;
            }
            URL sysid = this.myLoader.getResource(rsrc);
            if (sysid == null) {
                throw new PackageException("The resource exists, but has no URL: " + rsrc);
            }
            StreamSource src = new StreamSource(in);
            src.setSystemId(sysid.toString());
            return src;
        }

        public void removePackage() throws PackageException {
            throw new PackageException("Remove operation not supported on the classpath storage");
        }
    }
}

