/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.Extension;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.parser.DescriptorParser;

public abstract class DescriptorExtension
extends Extension {
    protected String myDescriptorName;

    public DescriptorExtension(String extension_name, String descriptor_name) {
        super(extension_name);
        this.myDescriptorName = descriptor_name;
    }

    public void init(Repository repo, Package pkg) throws PackageException {
        StreamSource desc;
        try {
            desc = pkg.getResolver().resolveResource(this.myDescriptorName);
        }
        catch (Storage.NotExistException ex) {
            return;
        }
        InputStream desc_in = desc.getInputStream();
        XMLStreamReader parser = DescriptorParser.XS_HELPER.makeDescriptorParser(desc_in);
        DescriptorParser.XS_HELPER.ensureDocument(parser);
        this.parseDescriptor(parser, pkg);
    }

    protected abstract void parseDescriptor(XMLStreamReader var1, Package var2) throws PackageException;
}

