/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.expath.pkg.repo.PackageException;

public class FileHelper {
    public static void ensureDir(File dir) throws PackageException {
        if (!dir.exists()) {
            boolean res = dir.mkdir();
            if (!res) {
                throw new PackageException("Error creating the directory: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new PackageException("The directory is not a directory: " + dir);
        }
    }

    public static File makeTempDir(String prefix, File parent) throws PackageException {
        File tmp;
        Date now = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String today = fmt.format(now);
        try {
            tmp = File.createTempFile(prefix + "-" + today + "-", ".d", parent);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating a temporary file", ex);
        }
        if (!tmp.delete()) {
            throw new PackageException("Error removing the temporary file: " + tmp);
        }
        if (!tmp.mkdir()) {
            throw new PackageException("Error creating the temporary dir: " + tmp);
        }
        return tmp;
    }

    public static void renameTmpDir(File from, File to) throws PackageException {
        boolean failed;
        boolean bl = failed = !from.renameTo(to);
        if (failed && !System.getProperty("os.name").startsWith("Windows")) {
            throw new PackageException("Renaming '" + from + "' to '" + to + "' failed");
        }
        for (int i = 0; failed && i < 5; ++i) {
            System.gc();
            failed = !from.renameTo(to);
        }
        if (failed) {
            FileHelper.copyDir(from, to);
            boolean res = FileHelper.deleteDir(from);
            if (!res) {
                System.err.println("Error deleting dir: " + from);
            }
        }
    }

    private static void copyDir(File from, File to) throws PackageException {
        File[] files = from.listFiles();
        if (files == null) {
            throw new PackageException("Failed to list contents of " + from);
        }
        if (to.exists()) {
            throw new PackageException("Destination '" + to + "' exists");
        }
        if (!to.mkdirs()) {
            throw new PackageException("Destination '" + to + "' directory cannot be created");
        }
        if (!to.canWrite()) {
            throw new PackageException("Destination '" + to + "' cannot be written to");
        }
        for (File file : files) {
            File copied = new File(to, file.getName());
            if (file.isDirectory()) {
                FileHelper.copyDir(file, copied);
                continue;
            }
            try {
                int count;
                byte[] buffer = new byte[4096];
                FileInputStream in = new FileInputStream(file);
                FileOutputStream out = new FileOutputStream(copied);
                while ((count = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, count);
                }
            }
            catch (IOException ex) {
                throw new PackageException("Error copying '" + file + "' to '" + copied + "'", ex);
            }
        }
    }

    private static boolean deleteDir(File f) {
        if (f.isDirectory()) {
            boolean res = true;
            for (File child : f.listFiles()) {
                res = FileHelper.deleteDir(child) && res;
            }
            res = f.delete() && res;
            return res;
        }
        return f.delete();
    }
}

