/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.FileHelper;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.ZipHelper;
import org.expath.pkg.repo.parser.DescriptorParser;
import org.expath.pkg.repo.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemStorage
extends Storage {
    private File myRoot;
    private File myPrivate;
    private static final String ADD_PACKAGE_XSL = "org/expath/pkg/repo/rsrc/add-package.xsl";
    private static final String REMOVE_PACKAGE_XSL = "org/expath/pkg/repo/rsrc/remove-package.xsl";
    private static final Logger LOG = Logger.getLogger(FileSystemStorage.class);

    public FileSystemStorage(File root) throws PackageException {
        if (root == null) {
            throw new NullPointerException("The repository root directory is null");
        }
        if (!root.exists()) {
            String msg = "The repository root directory does not exist: " + root;
            throw new PackageException(msg);
        }
        if (!root.isDirectory()) {
            String msg = "The repository root directory is not a directory: " + root;
            throw new PackageException(msg);
        }
        this.myRoot = root;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Storage.PackageResolver makePackageResolver(String rsrc_name, String abbrev) throws PackageException {
        File pkg_root = rsrc_name == null ? null : new File(this.myRoot, rsrc_name);
        return new FileSystemResolver(pkg_root, abbrev, rsrc_name);
    }

    @Override
    public InputStream resolveRsrc(String path) throws PackageException {
        File f = new File(this.myRoot, path);
        if (!f.exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File exist but is not found: " + f, ex);
        }
    }

    public String toString() {
        return "File system storage in " + this.myRoot.getAbsolutePath();
    }

    public Package install(File xar_file, boolean force, UserInteractionStrategy interact, Repository repo, Map<String, Packages> packages) throws PackageException {
        Package p2;
        if (!xar_file.exists()) {
            throw new PackageException("Package file does not exist (" + xar_file + ")");
        }
        File priv_dir = this.ensurePrivateDir();
        File tmp_dir = FileHelper.makeTempDir("install", priv_dir);
        try {
            ZipHelper zip = new ZipHelper(xar_file);
            zip.unzip(tmp_dir);
        }
        catch (IOException ex) {
            throw new PackageException("Error unziping the package", ex);
        }
        interact.logInfo("Package unziped to " + tmp_dir);
        InputStream desc = this.resolveInPackageRoot(tmp_dir, "expath-pkg.xml");
        if (desc == null) {
            throw new PackageException("Package descriptor does NOT exist in: " + tmp_dir);
        }
        DescriptorParser parser = new DescriptorParser();
        Package pkg = parser.parse(desc, null, this, repo);
        File dest = null;
        String name = pkg.getName();
        String version = pkg.getVersion();
        Packages pp = packages.get(name);
        if (pp != null && (p2 = pp.version(version)) != null) {
            if (force || interact.ask("Force override " + name + " - " + version + "?", false)) {
                p2.removeContent();
                pp.remove(p2);
                if (pp.latest() == null) {
                    packages.remove(name);
                }
            } else {
                throw new PackageException("Same version of the package is already installed");
            }
        }
        if (dest == null) {
            dest = new File(this.myRoot, pkg.getAbbrev() + "-" + version);
            for (int i = 1; dest.exists() && i < 100; ++i) {
                dest = new File(this.myRoot, pkg.getAbbrev() + "-" + version + "__" + i);
            }
            if (dest.exists()) {
                String msg = "Impossible to find a non-existing dir in the repo, stopped at: ";
                throw new PackageException(msg + dest);
            }
        }
        FileHelper.renameTmpDir(tmp_dir, dest);
        ((FileSystemResolver)pkg.getResolver()).setPkgDir(dest);
        if (pp == null) {
            pp = new Packages(name);
            packages.put(name, pp);
        }
        pp.add(pkg);
        this.updatePackageLists(pkg);
        return pkg;
    }

    private void updatePackageLists(Package pkg) throws PackageException {
        File dir = this.ensurePrivateDir();
        File xml_file = new File(dir, "packages.xml");
        if (!xml_file.exists()) {
            this.createPackagesXml(xml_file, pkg);
        } else {
            this.updatePackagesXml(xml_file, pkg);
        }
        File txt_file = new File(dir, "packages.txt");
        if (!txt_file.exists()) {
            this.createPackagesTxt(txt_file, pkg);
        } else {
            this.updatePackagesTxt(txt_file, pkg);
        }
    }

    private synchronized File ensurePrivateDir() throws PackageException {
        if (this.myPrivate == null) {
            File dir = new File(this.myRoot, ".expath-pkg");
            FileHelper.ensureDir(dir);
            this.myPrivate = dir;
        }
        return this.myPrivate;
    }

    private void createPackagesXml(File file, Package pkg) throws PackageException {
        try {
            FileWriter out = new FileWriter(file);
            out.write("<packages xmlns=\"http://expath.org/ns/repo/packages\">\n");
            out.write("   <package name=\"");
            out.write(pkg.getName());
            out.write("\"\n");
            out.write("            dir=\"");
            out.write(((FileSystemResolver)pkg.getResolver()).getDirName());
            out.write("\"\n");
            out.write("            version=\"");
            out.write(pkg.getVersion());
            out.write("\"/>\n");
            out.write("</packages>\n");
            ((Writer)out).close();
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("Impossible to create the packages xml list: " + file, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating the packages xml list: " + file, ex);
        }
    }

    private void updatePackagesXml(File file, Package pkg) throws PackageException {
        try {
            ClassLoader loader = FileSystemStorage.class.getClassLoader();
            InputStream style_in = loader.getResourceAsStream(ADD_PACKAGE_XSL);
            if (style_in == null) {
                throw new PackageException("Resource not found: org/expath/pkg/repo/rsrc/add-package.xsl");
            }
            StreamSource style_src = new StreamSource(style_in);
            style_src.setSystemId(ADD_PACKAGE_XSL);
            Templates style = TransformerFactory.newInstance().newTemplates(style_src);
            StreamSource src = new StreamSource(file);
            StringWriter res_out = new StringWriter();
            StreamResult res = new StreamResult(res_out);
            Transformer trans = style.newTransformer();
            trans.setParameter("name", pkg.getName());
            trans.setParameter("dir", ((FileSystemResolver)pkg.getResolver()).getDirName());
            trans.setParameter("version", pkg.getVersion());
            trans.transform(src, res);
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(res_out.getBuffer().toString().getBytes());
            ((OutputStream)out).close();
        }
        catch (TransformerConfigurationException ex) {
            throw new PackageException("Impossible to compile the stylesheet: org/expath/pkg/repo/rsrc/add-package.xsl", ex);
        }
        catch (TransformerException ex) {
            throw new PackageException("Error transforming packages.xml", ex);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found (wtf? - I just transformed it): " + file, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + file, ex);
        }
    }

    private void createPackagesTxt(File file, Package pkg) throws PackageException {
        try {
            FileWriter out = new FileWriter(file);
            out.write(((FileSystemResolver)pkg.getResolver()).getDirName());
            out.write(" ");
            out.write(pkg.getName());
            out.write(" ");
            out.write(pkg.getVersion());
            out.write("\n");
            ((Writer)out).close();
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("Impossible to create the packages text list: " + file, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating the packages text list: " + file, ex);
        }
    }

    private void updatePackagesTxt(File file, Package pkg) throws PackageException {
        String pkg_name = pkg.getName();
        String pkg_dir = ((FileSystemResolver)pkg.getResolver()).getDirName();
        String pkg_version = pkg.getVersion();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            StringWriter buffer = new StringWriter();
            while ((line = in.readLine()) != null) {
                int pos = line.indexOf(32);
                String dir = line.substring(0, pos);
                int pos2 = line.indexOf(32, ++pos);
                String name = line.substring(pos, pos2);
                pos = pos2 + 1;
                pos2 = line.length();
                String version = line.substring(pos, pos2);
                if (dir.equals(pkg_dir) || name.equals(pkg_name) && version.equals(pkg_version)) continue;
                buffer.write(line);
                buffer.write("\n");
            }
            in.close();
            FileWriter out = new FileWriter(file);
            out.write(buffer.getBuffer().toString());
            out.write(pkg_dir);
            out.write(" ");
            out.write(pkg_name);
            out.write(" ");
            out.write(pkg_version);
            out.write("\n");
            ((Writer)out).close();
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + file, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + file, ex);
        }
    }

    private InputStream resolveInPackageRoot(File root, String path) throws PackageException {
        File f = new File(root, path);
        if (!f.exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File exists but is not found", ex);
        }
    }

    public class FileSystemResolver
    extends Storage.PackageResolver {
        private File myPkgDir;
        private String myRsrcName;
        private File myContentDir;
        private String myPkgAbbrev;

        public FileSystemResolver(File pkg_dir, String abbrev, String rsrc_name) throws PackageException {
            this.myPkgAbbrev = abbrev;
            this.myRsrcName = rsrc_name;
            this.setPkgDir(pkg_dir);
        }

        public String getResourceName() {
            return this.myRsrcName;
        }

        private void setPkgDir(File dir) throws PackageException {
            this.myPkgDir = dir;
            this.myContentDir = dir == null || this.myPkgAbbrev == null ? null : this.getContenDir(dir, this.myPkgAbbrev);
        }

        private File getContenDir(File pkg_dir, String abbrev) throws PackageException {
            File old_style = new File(pkg_dir, abbrev);
            File new_style = new File(pkg_dir, "content");
            boolean old_exists = old_style.exists();
            boolean new_exists = new_style.exists();
            boolean old_isdir = old_style.isDirectory();
            boolean new_isdir = new_style.isDirectory();
            LOG.finer("Content dir ''{0}'' (exists:{1}/isdir:{2}), and ''{3}'' (exists:{4}/isdir:{5})", new_style, new_exists, new_isdir, old_style, old_exists, old_isdir);
            if (!old_exists && !new_exists) {
                return null;
            }
            if (old_exists && new_exists) {
                String msg = "Both content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            if (new_exists) {
                if (!new_isdir) {
                    String msg = "Content dir is not a directory: '" + new_style + "'";
                    LOG.info(msg, new Object[0]);
                    throw new PackageException(msg);
                }
                return new_style;
            }
            if (!old_isdir) {
                String msg = "Content dir is not a directory: '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            LOG.info("Warning: package uses old-style content dir: ''{0}''", old_style);
            return old_style;
        }

        public File resolveResourceAsFile(String path) {
            return new File(this.myPkgDir, path);
        }

        public File resolveComponentAsFile(String path) {
            return new File(this.myContentDir, path);
        }

        public StreamSource resolveResource(String path) throws PackageException, Storage.NotExistException {
            return this.resolveWithin(path, this.myPkgDir);
        }

        public StreamSource resolveComponent(String path) throws PackageException, Storage.NotExistException {
            return this.resolveWithin(path, this.myContentDir);
        }

        private StreamSource resolveWithin(String path, File dir) throws PackageException, Storage.NotExistException {
            LOG.fine("Trying to resolve ''{0}'' within ''{1}''", path, dir);
            File f = new File(dir, path);
            if (!f.exists()) {
                String msg = "File '" + f + "' does not exist";
                LOG.fine(msg, new Object[0]);
                throw new Storage.NotExistException(msg);
            }
            try {
                FileInputStream in = new FileInputStream(f);
                StreamSource src = new StreamSource(in);
                src.setSystemId(f.toURI().toString());
                return src;
            }
            catch (FileNotFoundException ex) {
                String msg = "File '" + f + "' exists but is not found";
                LOG.severe(msg, new Object[0]);
                throw new PackageException(msg, ex);
            }
        }

        public void removePackage() throws PackageException {
            FileSystemStorage.this.ensurePrivateDir();
            String dir = this.getDirName();
            File xml_file = new File(FileSystemStorage.this.myPrivate, "packages.xml");
            this.removePackageInXml(xml_file, dir);
            File txt_file = new File(FileSystemStorage.this.myPrivate, "packages.txt");
            this.removePackageInTxt(txt_file, dir);
            this.deleteDirRecurse(this.myPkgDir);
        }

        private void removePackageInXml(File file, String dir) throws PackageException {
            try {
                ClassLoader loader = FileSystemStorage.class.getClassLoader();
                InputStream style_in = loader.getResourceAsStream(FileSystemStorage.REMOVE_PACKAGE_XSL);
                if (style_in == null) {
                    throw new PackageException("Resource not found: org/expath/pkg/repo/rsrc/remove-package.xsl");
                }
                StreamSource style_src = new StreamSource(style_in);
                style_src.setSystemId(FileSystemStorage.REMOVE_PACKAGE_XSL);
                Templates style = TransformerFactory.newInstance().newTemplates(style_src);
                StreamSource src = new StreamSource(file);
                StringWriter res_out = new StringWriter();
                StreamResult res = new StreamResult(res_out);
                Transformer trans = style.newTransformer();
                trans.setParameter("dir", dir);
                trans.transform(src, res);
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).write(res_out.getBuffer().toString().getBytes());
                ((OutputStream)out).close();
            }
            catch (TransformerConfigurationException ex) {
                throw new PackageException("Impossible to compile the stylesheet: org/expath/pkg/repo/rsrc/add-package.xsl", ex);
            }
            catch (TransformerException ex) {
                throw new PackageException("Error transforming packages.xml", ex);
            }
            catch (FileNotFoundException ex) {
                throw new PackageException("File not found (wtf? - I just transformed it): " + file, ex);
            }
            catch (IOException ex) {
                throw new PackageException("Error writing the file: " + file, ex);
            }
        }

        private void removePackageInTxt(File file, String dir) throws PackageException {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                StringWriter buffer = new StringWriter();
                while ((line = in.readLine()) != null) {
                    int pos = line.indexOf(32);
                    String d = line.substring(0, pos);
                    if (d.equals(dir)) continue;
                    buffer.write(line);
                    buffer.write("\n");
                }
                in.close();
                FileWriter out = new FileWriter(file);
                out.write(buffer.getBuffer().toString());
                ((Writer)out).close();
            }
            catch (FileNotFoundException ex) {
                throw new PackageException("File not found: " + file, ex);
            }
            catch (IOException ex) {
                throw new PackageException("Error writing the file: " + file, ex);
            }
        }

        private void deleteDirRecurse(File dir) throws PackageException {
            File[] children = dir.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.deleteDirRecurse(child);
                }
            }
            if (!dir.delete()) {
                throw new PackageException("Error deleting a dir: " + dir);
            }
        }

        private String getDirName() {
            return this.myPkgDir.getName();
        }
    }
}

