/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.Extension;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.parser.DescriptorParser;
import org.expath.pkg.repo.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements Universe {
    private Storage myStorage;
    private Map<String, Packages> myPackages = new HashMap<String, Packages>();
    private Map<String, Extension> myExtensions = new HashMap<String, Extension>();
    private static final Logger LOG = Logger.getLogger(Repository.class);

    public Repository(Storage storage) throws PackageException {
        LOG.info("Create a new repository with storage: {0}", storage);
        this.myStorage = storage;
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class);
        for (Extension e : loader) {
            this.registerExtension(e);
        }
        this.parsePublicUris();
    }

    public static Repository makeDefaultRepo() throws PackageException {
        return Repository.makeDefaultRepo(null);
    }

    public static Repository makeDefaultRepo(String dir) throws PackageException {
        if (dir == null) {
            dir = System.getProperty("expath.repo");
        }
        if (dir == null) {
            dir = System.getenv("EXPATH_REPO");
        }
        if (dir != null) {
            File f = new File(dir);
            if (!f.exists()) {
                throw new PackageException("Repo directory does not exist: " + dir);
            }
            if (!f.isDirectory()) {
                throw new PackageException("Repo is not a directory: " + dir);
            }
            try {
                FileSystemStorage storage = new FileSystemStorage(f);
                return new Repository(storage);
            }
            catch (PackageException ex) {
                throw new PackageException("Error setting the repo (" + dir + ")", ex);
            }
        }
        return null;
    }

    public final void registerExtension(Extension ext) throws PackageException {
        if (!this.myExtensions.containsKey(ext.getName())) {
            this.myExtensions.put(ext.getName(), ext);
            ext.init(this, this.myPackages);
        }
    }

    public Collection<Packages> listPackages() {
        return this.myPackages.values();
    }

    public Packages getPackages(String name) {
        return this.myPackages.get(name);
    }

    public static Repository createRepository(File dir) throws PackageException {
        File priv_dir;
        if (dir.exists()) {
            if (!dir.isDirectory() || dir.list() == null) {
                throw new PackageException("File exists and is not a directory (" + dir + ")");
            }
            if (dir.list().length > 0) {
                throw new PackageException("Directory exists and is not empty (" + dir + ")");
            }
        } else if (!dir.mkdir()) {
            throw new PackageException("Error creating the directory (" + dir + ")");
        }
        if (!(priv_dir = new File(dir, ".expath-pkg/")).mkdir()) {
            throw new PackageException("Error creating the private directory (" + priv_dir + ")");
        }
        return new Repository(new FileSystemStorage(dir));
    }

    public Package installPackage(File pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        if (this.myStorage.isReadOnly()) {
            throw new PackageException("The storage is read-only, package install not supported");
        }
        return this.doInstall(pkg, force, interact);
    }

    public Package installPackage(URI pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        File downloaded;
        if (this.myStorage.isReadOnly()) {
            throw new PackageException("The storage is read-only, package install not supported");
        }
        try {
            int i;
            URLConnection connection = pkg.toURL().openConnection();
            InputStream instream = connection.getInputStream();
            BufferedInputStream in = new BufferedInputStream(instream);
            String name = new File(pkg.getPath()).getName();
            downloaded = File.createTempFile(name + "-", "-expath-tmp.xar");
            FileOutputStream tmp = new FileOutputStream(downloaded);
            BufferedOutputStream out = new BufferedOutputStream(tmp);
            byte[] buf = new byte[4096];
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
            }
            out.close();
            in.close();
        }
        catch (MalformedURLException ex) {
            throw new PackageException("Error downloading the package", ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error downloading the package", ex);
        }
        return this.doInstall(downloaded, force, interact);
    }

    private Package doInstall(File xar_file, boolean force, UserInteractionStrategy interact) throws PackageException {
        if (!(this.myStorage instanceof FileSystemStorage)) {
            throw new PackageException("Install not supported for the storage " + this.myStorage.getClass());
        }
        FileSystemStorage filesystem = (FileSystemStorage)this.myStorage;
        Package pkg = filesystem.install(xar_file, force, interact, this, this.myPackages);
        for (Extension ext : this.myExtensions.values()) {
            ext.init(this, pkg);
        }
        return pkg;
    }

    public void removePackage(String pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        if (!interact.ask("Remove package " + pkg + "?", true)) {
            return;
        }
        Packages pp = this.myPackages.get(pkg);
        if (pp == null) {
            throw new PackageException("The package does not exist: " + pkg);
        }
        if (pp.packages().size() != 1) {
            throw new PackageException("The package has several versions installed: " + pkg);
        }
        pp.latest().removeContent();
        this.myPackages.remove(pkg);
    }

    public void removePackage(String pkg, String version, boolean force, UserInteractionStrategy interact) throws PackageException {
        if (!interact.ask("Remove package " + pkg + "?", true)) {
            return;
        }
        Packages pp = this.myPackages.get(pkg);
        if (pp == null) {
            throw new PackageException("The package does not exist: " + pkg);
        }
        Package p = pp.version(version);
        if (p == null) {
            throw new PackageException("The version " + version + " package does not exist for the package: " + pkg);
        }
        p.removeContent();
        pp.remove(p);
        if (pp.latest() == null) {
            this.myPackages.remove(pkg);
        }
    }

    @Override
    public StreamSource resolve(String href, URISpace space) throws PackageException {
        LOG.fine("Repository, resolve in {0}: ''{1}''", new Object[]{space, href});
        for (Packages pp : this.myPackages.values()) {
            Package p = pp.latest();
            StreamSource src = p.resolve(href, space);
            if (src == null) continue;
            return src;
        }
        return null;
    }

    @Override
    public StreamSource resolve(String href, URISpace space, boolean transitive) throws PackageException {
        return this.resolve(href, space);
    }

    private synchronized void parsePublicUris() throws PackageException {
        Set<String> packages = this.myStorage.listPackageDirectories();
        DescriptorParser parser = new DescriptorParser();
        for (String p : packages) {
            StreamSource desc;
            Storage.PackageResolver res = this.myStorage.makePackageResolver(p, null);
            try {
                desc = res.resolveResource("expath-pkg.xml");
            }
            catch (Storage.NotExistException ex) {
                throw new PackageException("Package descriptor does NOT exist in: " + p, ex);
            }
            Package pkg = parser.parse(desc.getInputStream(), p, this.myStorage, this);
            this.addPackage(pkg);
            for (Extension ext : this.myExtensions.values()) {
                ext.init(this, pkg);
            }
        }
    }

    void addPackage(Package pkg) {
        String name = pkg.getName();
        Packages pp = this.myPackages.get(name);
        if (pp == null) {
            pp = new Packages(name);
            this.myPackages.put(name, pp);
        }
        pp.add(pkg);
    }

    Repository() {
    }
}

