/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Storage {
    public abstract boolean isReadOnly();

    public abstract PackageResolver makePackageResolver(String var1, String var2) throws PackageException;

    public abstract InputStream resolveRsrc(String var1) throws PackageException;

    public Set<String> listPackageDirectories() throws PackageException {
        HashSet<String> result = new HashSet<String>();
        try {
            String line;
            InputStream stream = this.resolveRsrc(".expath-pkg/packages.txt");
            if (stream == null) {
                return result;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                int pos = line.indexOf(32);
                String dir = line.substring(0, pos);
                result.add(dir);
            }
            return result;
        }
        catch (IOException ex) {
            throw new PackageException("Error reading the package list", ex);
        }
    }

    public static class NotExistException
    extends Exception {
        public NotExistException(String msg) {
            super(msg);
        }

        public NotExistException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }

    public static abstract class PackageResolver {
        public abstract String getResourceName();

        public abstract StreamSource resolveResource(String var1) throws PackageException, NotExistException;

        public abstract StreamSource resolveComponent(String var1) throws PackageException, NotExistException;

        public abstract void removePackage() throws PackageException;
    }
}

