/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipHelper {
    private File myZip;

    public ZipHelper(File zip) {
        this.myZip = zip;
    }

    public File unzipToTmpDir() throws IOException {
        File tmpdir = File.createTempFile("expath-pkg-", ".d");
        tmpdir.delete();
        tmpdir.mkdir();
        tmpdir.deleteOnExit();
        this.unzip(tmpdir);
        return tmpdir;
    }

    public void unzip(File dest_dir) throws IOException {
        if (!dest_dir.exists()) {
            boolean res = dest_dir.mkdir();
            if (!res) {
                throw new IOException("Error creating the destination directory: " + dest_dir);
            }
        } else if (!dest_dir.isDirectory()) {
            throw new IOException("Destination is not a directory: " + dest_dir);
        }
        ZipFile archive = new ZipFile(this.myZip);
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            File dest = new File(dest_dir, entry.getName());
            File parent = dest.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            InputStream in = archive.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(dest);
            ZipHelper.copyInputStream(in, new BufferedOutputStream(out));
        }
        archive.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }
}

