/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.resolver;

import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PkgEntityResolver
implements EntityResolver {
    private Universe myUniverse;
    private URISpace mySpace;

    public PkgEntityResolver(Universe universe, URISpace space) {
        this.myUniverse = universe;
        this.mySpace = space;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        StreamSource resolved;
        try {
            resolved = this.myUniverse.resolve(systemId, this.mySpace);
        }
        catch (PackageException ex) {
            System.err.println("TODO: Error management. Something wrong in entity resolver...");
            ex.printStackTrace();
            return null;
        }
        if (resolved == null) {
            return null;
        }
        InputSource src = new InputSource(resolved.getInputStream());
        src.setSystemId(resolved.getSystemId());
        return src;
    }
}

