/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.APIAStubWrapper;
import fedora.client.Administrator;
import fedora.server.access.FedoraAPIA;
import fedora.server.access.FedoraAPIAServiceLocator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;

public abstract class APIAStubFactory {
    public static int SOCKET_TIMEOUT_SECONDS = 120;

    public static FedoraAPIA getStub(String protocol, String host, int port, String username, String password) throws MalformedURLException, ServiceException {
        FedoraAPIAServiceLocator locator = new FedoraAPIAServiceLocator(username, password, SOCKET_TIMEOUT_SECONDS);
        URL ourl = null;
        URL nurl = null;
        if (protocol.equalsIgnoreCase("http")) {
            ourl = new URL(locator.getFedoraAPIAPortSOAPHTTPAddress());
            nurl = APIAStubFactory.rewriteServiceURL(ourl, protocol, host, port, null);
            if (Administrator.INSTANCE == null) {
                return locator.getFedoraAPIAPortSOAPHTTP(nurl);
            }
            return new APIAStubWrapper(locator.getFedoraAPIAPortSOAPHTTP(nurl));
        }
        if (protocol.equalsIgnoreCase("https")) {
            ourl = new URL(locator.getFedoraAPIAPortSOAPHTTPSAddress());
            nurl = APIAStubFactory.rewriteServiceURL(ourl, protocol, host, port, null);
            if (Administrator.INSTANCE == null) {
                return locator.getFedoraAPIAPortSOAPHTTPS(nurl);
            }
            return new APIAStubWrapper(locator.getFedoraAPIAPortSOAPHTTPS(nurl));
        }
        throw new ServiceException("The protocol " + protocol + " is not supported by this service.");
    }

    public static FedoraAPIA getStubAltPath(String protocol, String host, int port, String path, String username, String password) throws MalformedURLException, ServiceException {
        FedoraAPIAServiceLocator locator = new FedoraAPIAServiceLocator(username, password, SOCKET_TIMEOUT_SECONDS);
        URL ourl = null;
        URL nurl = null;
        if (protocol.equalsIgnoreCase("http")) {
            ourl = new URL(locator.getFedoraAPIAPortSOAPHTTPAddress());
            nurl = APIAStubFactory.rewriteServiceURL(ourl, protocol, host, port, path);
            if (Administrator.INSTANCE == null) {
                return locator.getFedoraAPIAPortSOAPHTTP(nurl);
            }
            return new APIAStubWrapper(locator.getFedoraAPIAPortSOAPHTTP(nurl));
        }
        if (protocol.equalsIgnoreCase("https")) {
            ourl = new URL(locator.getFedoraAPIAPortSOAPHTTPSAddress());
            nurl = APIAStubFactory.rewriteServiceURL(ourl, protocol, host, port, path);
            if (Administrator.INSTANCE == null) {
                return locator.getFedoraAPIAPortSOAPHTTPS(nurl);
            }
            return new APIAStubWrapper(locator.getFedoraAPIAPortSOAPHTTPS(nurl));
        }
        throw new ServiceException("The protocol " + protocol + " is not supported by this service.");
    }

    private static URL rewriteServiceURL(URL ourl, String protocol, String host, int port, String path) throws MalformedURLException, ServiceException {
        StringBuffer nurl = new StringBuffer();
        if (protocol.equalsIgnoreCase("http")) {
            nurl.append("http://");
        } else if (protocol.equalsIgnoreCase("https")) {
            nurl.append("https://");
        } else {
            throw new ServiceException("The protocol " + protocol + " is not supported by this service.");
        }
        nurl.append(host);
        nurl.append(':');
        nurl.append(port);
        if (path == null || path.equals("")) {
            nurl.append(ourl.getPath());
            if (ourl.getQuery() != null && !ourl.getQuery().equals("")) {
                nurl.append('?');
                nurl.append(ourl.getQuery());
            }
            if (ourl.getRef() != null && !ourl.getRef().equals("")) {
                nurl.append('#');
                nurl.append(ourl.getRef());
            }
        } else {
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            nurl.append(path);
        }
        return new URL(nurl.toString());
    }
}

