/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.APIAStubFactory;
import fedora.client.BatchBuildGUI;
import fedora.client.BatchBuildIngestGUI;
import fedora.client.BatchIngestGUI;
import fedora.client.Downloader;
import fedora.client.FedoraClient;
import fedora.client.LoginDialog;
import fedora.client.NewObjectDialog;
import fedora.client.Uploader;
import fedora.client.actions.Login;
import fedora.client.actions.PurgeObject;
import fedora.client.actions.ViewObject;
import fedora.client.actions.ViewObjectXML;
import fedora.client.batch.BatchModify;
import fedora.client.batch.BatchModifyValidate;
import fedora.client.console.access.AccessConsole;
import fedora.client.console.management.ManagementConsole;
import fedora.client.export.ExportDialog;
import fedora.client.ingest.IngestDialog;
import fedora.client.search.Search;
import fedora.client.utility.ingest.XMLBuilder;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.swing.mdi.MDIDesktopPane;
import fedora.swing.mdi.WindowMenu;
import fedora.utilities.Log4J;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Administrator
extends JFrame {
    private static final Logger LOG = Logger.getLogger((String)Administrator.class.getName());
    private static final long serialVersionUID = 1L;
    private static MDIDesktopPane s_desktop;
    private static int s_maxButtonHeight;
    private JDialog m_aboutDialog;
    private static File s_lastDir;
    protected static File batchtoolLastDir;
    public static ClassLoader cl;
    public static JTextArea WATCH_AREA;
    private static Administrator s_instance;
    private final JLabel m_aboutPic;
    private final JLabel m_aboutText;
    private static String s_protocol;
    private static String s_host;
    private static int s_port;
    private static String s_user;
    private static String s_pass;
    public static JProgressBar PROGRESS;
    public static Downloader DOWNLOADER;
    public static Uploader UPLOADER;
    public static Color ACTIVE_COLOR;
    public static Color INACTIVE_COLOR;
    public static Color DELETED_COLOR;
    public static Color DEFAULT_COLOR;
    public static Color DESKTOP_COLOR;
    public static Color BACKGROUND_COLOR;
    public static FedoraAPIA APIA;
    public static FedoraAPIM APIM;
    public static File BASE_DIR;
    public static Administrator INSTANCE;
    private static ResourceBundle s_const;
    public static String VERSION;
    public static String RELEASE_DATE;

    public static final void showErrorDialog(Component parent, String title, String explanation, Exception e) {
        if (e instanceof AxisFault) {
            StringBuffer authzDetail = new StringBuffer("");
            Element[] getFaultDetails = ((AxisFault)e).getFaultDetails();
            if (getFaultDetails != null) {
                for (Element detail : getFaultDetails) {
                    if (!"Authz".equals(detail.getLocalName()) || !detail.hasChildNodes()) continue;
                    NodeList nodeList = detail.getChildNodes();
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        authzDetail.append(nodeList.item(j).getNodeValue());
                    }
                }
            }
            if (authzDetail.length() > 0) {
                explanation = authzDetail.toString();
            }
        }
        JOptionPane.showMessageDialog(parent, explanation, title, 0);
    }

    public Administrator(String protocol, String host, int port, String user, String pass) {
        super("Fedora Administrator");
        File f;
        INSTANCE = this;
        WATCH_AREA = new JTextArea();
        WATCH_AREA.setFont(new Font("monospaced", 0, 12));
        WATCH_AREA.setCaretPosition(0);
        s_maxButtonHeight = new JTextField((String)"test").getPreferredSize().height;
        BACKGROUND_COLOR = new JPanel().getBackground();
        if (host != null) {
            try {
                String baseURL = protocol + "://" + host + ":" + port + "/fedora";
                FedoraClient fc = new FedoraClient(baseURL, user, pass);
                APIA = fc.getAPIA();
                APIM = fc.getAPIM();
                this.setLoginInfo(protocol, host, port, user, pass);
            }
            catch (Exception e) {
                APIA = null;
                APIM = null;
            }
        }
        if (Constants.FEDORA_HOME != null && (f = new File(Constants.FEDORA_HOME)).exists() && f.isDirectory()) {
            s_lastDir = BASE_DIR = new File(f, "client");
        }
        cl = this.getClass().getClassLoader();
        this.m_aboutPic = new JLabel(new ImageIcon(cl.getResource("images/fedora/aboutadmin.gif")));
        this.m_aboutText = new JLabel("<html><p>Copyright 2008, Fedora Commons, Inc.</p><p>Copyright 2002-2007, The Rector and Visitors of the</p><p>University of Virginia and Cornell University.</p><p></p><p><b>License: </b>This software is subject to the terms of the</p><p>Apache License, Version 2.0 (the \"License\"); you may not use</p><p>this software except in compliance with the License. You may</p><p>obtain a copy of the License at:</p><blockquote>http://www.apache.org/licenses/</blockquote><p></p><p>Software distributed under the License is distributed on an \"AS IS\"</p><p>basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.</p><p>See the License for the specific language governing rights and</p><p>limitations under the License.</p><p></p><p>Version: " + VERSION + "</p>" + "<p>Release Date: " + RELEASE_DATE + "</p>" + "<p>See http://www.fedora-commons.org/ for more information.</p></html>");
        this.m_aboutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel splashPicAndText = new JPanel();
        splashPicAndText.setLayout(new BorderLayout());
        splashPicAndText.setBorder(BorderFactory.createLineBorder(Color.black, 5));
        splashPicAndText.add((Component)this.m_aboutPic, "Center");
        splashPicAndText.add((Component)this.m_aboutText, "South");
        JWindow splashScreen = new JWindow();
        splashScreen.getContentPane().add(splashPicAndText);
        splashScreen.pack();
        int xSize = splashScreen.getWidth();
        int ySize = splashScreen.getHeight();
        Dimension screenSize = this.getToolkit().getScreenSize();
        int xLoc = screenSize.width / 2 - xSize / 2;
        int yLoc = screenSize.height / 2 - ySize / 2;
        splashScreen.setBounds(xLoc, yLoc, xSize, ySize);
        splashScreen.setVisible(true);
        this.setIconImage(new ImageIcon(cl.getResource("images/fedora/fedora-icon16.gif")).getImage());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        s_desktop = new MDIDesktopPane();
        s_desktop.setBackground(DESKTOP_COLOR);
        s_desktop.setVisible(true);
        mainPanel.add((Component)new JScrollPane(s_desktop), "Center");
        PROGRESS = new JProgressBar(0, 2000);
        PROGRESS.setValue(0);
        PROGRESS.setStringPainted(true);
        PROGRESS.setString("");
        mainPanel.add((Component)PROGRESS, "South");
        this.getContentPane().add(mainPanel);
        this.setJMenuBar(this.createMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Administrator.this.dispose();
                System.exit(0);
            }
        });
        splashScreen.setVisible(false);
        s_instance = this;
        int xs = 850;
        int ys = 655;
        Dimension sz = this.getToolkit().getScreenSize();
        int xl = sz.width / 2 - xs / 2;
        int yl = sz.height / 2 - ys / 2;
        this.setBounds(xl, yl, xs, ys);
        this.setVisible(true);
        if (APIA == null || APIM == null) {
            new LoginDialog();
        }
        if (APIA == null || APIM == null) {
            this.dispose();
            System.exit(0);
        }
    }

    public static JDesktopPane getDesktop() {
        return s_desktop;
    }

    public void setLoginInfo(String protocol, String host, int port, String user, String pass) {
        s_protocol = protocol;
        s_host = host;
        s_port = port;
        s_user = user;
        s_pass = pass;
        try {
            DOWNLOADER = new Downloader(host, port, user, pass);
            UPLOADER = new Uploader(host, port, user, pass);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.doTitle();
    }

    public void doTitle() {
        this.setTitle("Fedora Administrator - " + s_user + "@" + s_host + ":" + s_port);
    }

    public static Administrator getInstance() {
        return s_instance;
    }

    public static JComponent constrainHeight(JComponent component) {
        int preferredWidth = component.getPreferredSize().width;
        component.setPreferredSize(new Dimension(preferredWidth, s_maxButtonHeight));
        component.setMaximumSize(new Dimension(2048, s_maxButtonHeight));
        component.setMinimumSize(new Dimension(preferredWidth, s_maxButtonHeight));
        return component;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenu fileNew = new JMenu("New");
        fileNew.setMnemonic(78);
        JMenuItem fileNewObject = new JMenuItem("Data Object", 79);
        fileNewObject.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        fileNewObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NewObjectDialog(XMLBuilder.OBJECT_TYPE.dataObject, "New Object");
            }
        });
        JMenuItem fileNewCModel = new JMenuItem("Content Model", 67);
        fileNewCModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NewObjectDialog(XMLBuilder.OBJECT_TYPE.contentModel, "New Content Model");
            }
        });
        JMenuItem fileNewSDef = new JMenuItem("Service Definition", 68);
        fileNewSDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NewObjectDialog(XMLBuilder.OBJECT_TYPE.serviceDefinition, "New Service Definition");
            }
        });
        JMenuItem fileNewSDep = new JMenuItem("Service Deployment", 77);
        fileNewSDep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NewObjectDialog(XMLBuilder.OBJECT_TYPE.serviceDeployment, "New Service Deployment");
            }
        });
        fileNew.add(fileNewObject);
        fileNew.add(fileNewCModel);
        fileNew.add(fileNewSDef);
        fileNew.add(fileNewSDep);
        JMenuItem fileOpen = new JMenuItem(new ViewObject());
        fileOpen.setMnemonic(79);
        fileOpen.setToolTipText("Launches a viewer/editor for an object and it's components.");
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenu fileIngest = new JMenu("Ingest");
        fileIngest.setMnemonic(73);
        JMenu fileIngestOne = new JMenu("One Object");
        fileIngestOne.setMnemonic(79);
        JMenuItem fileIngestOneFromFile = new JMenuItem("From File...", 70);
        fileIngestOneFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IngestDialog(IngestDialog.ONE_FROM_FILE);
            }
        });
        JMenuItem fileIngestOneFromRepository = new JMenuItem("From Repository...", 82);
        fileIngestOneFromRepository.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        fileIngestOneFromRepository.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IngestDialog(IngestDialog.ONE_FROM_REPOS);
            }
        });
        fileIngestOne.add(fileIngestOneFromFile);
        fileIngestOne.add(fileIngestOneFromRepository);
        JMenu fileIngestMultiple = new JMenu("Multiple Objects");
        fileIngestMultiple.setMnemonic(77);
        JMenuItem fileIngestMultipleFromFile = new JMenuItem("From Directory...", 68);
        fileIngestMultipleFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IngestDialog(IngestDialog.MULTI_FROM_DIR);
            }
        });
        JMenuItem fileIngestMultipleFromRepository = new JMenuItem("From Repository...", 82);
        fileIngestMultipleFromRepository.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IngestDialog(IngestDialog.MULTI_FROM_REPOS);
            }
        });
        fileIngestMultiple.add(fileIngestMultipleFromFile);
        fileIngestMultiple.add(fileIngestMultipleFromRepository);
        fileIngest.add(fileIngestOne);
        fileIngest.add(fileIngestMultiple);
        JMenu fileExport = new JMenu("Export");
        fileExport.setMnemonic(69);
        JMenuItem fileExportObject = new JMenuItem("One Object...");
        fileExportObject.setMnemonic(79);
        fileExportObject.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileExportObject.setToolTipText("Exports a serialized Digitial Object to disk.");
        fileExportObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ExportDialog(ExportDialog.ONE);
            }
        });
        JMenuItem fileExportMultiple = new JMenuItem("Multiple Objects...");
        fileExportMultiple.setMnemonic(77);
        fileExportMultiple.setToolTipText("Exports multiple serialized Digitial Objects to disk.");
        fileExportMultiple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ExportDialog(ExportDialog.MULTI);
            }
        });
        fileExport.add(fileExportObject);
        fileExport.add(fileExportMultiple);
        JMenuItem fileViewXML = new JMenuItem(new ViewObjectXML());
        fileViewXML.setMnemonic(86);
        fileViewXML.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        fileViewXML.setToolTipText("Launches a viewer for the internal XML of an object in the repository.");
        JMenuItem filePurge = new JMenuItem(new PurgeObject());
        filePurge.setMnemonic(80);
        filePurge.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        filePurge.setToolTipText("Permanently removes a Digitial Object from the repository.");
        JMenuItem fileLogin = new JMenuItem(new Login());
        fileLogin.setMnemonic(82);
        fileLogin.setToolTipText("Changes the working repository.");
        fileLogin.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenuItem fileExit = new JMenuItem("Exit", 88);
        fileExit.setToolTipText("Exits the application");
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.dispose();
                System.exit(0);
            }
        });
        fileMenu.add(fileNew);
        fileMenu.add(fileOpen);
        fileMenu.addSeparator();
        fileMenu.add(fileIngest);
        fileMenu.add(fileExport);
        fileMenu.addSeparator();
        fileMenu.add(filePurge);
        fileMenu.add(fileViewXML);
        fileMenu.addSeparator();
        fileMenu.add(fileLogin);
        fileMenu.add(fileExit);
        menuBar.add(fileMenu);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        JMenuItem toolsSearch = new JMenuItem("Search/Browse Repository", 83);
        toolsSearch.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        toolsSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createSearchRepository();
            }
        });
        toolsMenu.add(toolsSearch);
        JMenu toolsBatchSubMenu = new JMenu("Batch");
        JMenuItem toolsBatchBuild = new JMenuItem("Build Batch");
        toolsBatchBuild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createBatchBuildConsole();
            }
        });
        toolsBatchSubMenu.add(toolsBatchBuild);
        JMenuItem toolsBatchBuildIngest = new JMenuItem("Build and Ingest Batch");
        toolsBatchBuildIngest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createBatchBuildIngestConsole();
            }
        });
        toolsBatchSubMenu.add(toolsBatchBuildIngest);
        JMenuItem toolsBatchIngest = new JMenuItem("Ingest Batch");
        toolsBatchIngest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createBatchIngestConsole();
            }
        });
        toolsBatchSubMenu.add(toolsBatchIngest);
        JMenu toolsBatchModify = new JMenu("Modify Batch");
        toolsBatchModify.setMnemonic(77);
        JMenuItem executeBatchModify = new JMenuItem("Process Directives", 80);
        toolsBatchModify.setToolTipText("Modifies a batch of objects based on modify directives specified in a file on disk.");
        executeBatchModify.setToolTipText("Run the Batch Modify Utility.");
        executeBatchModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new BatchModify();
            }
        });
        toolsBatchModify.add(executeBatchModify);
        JMenuItem validateBatchModify = new JMenuItem("Validate Directives File", 86);
        validateBatchModify.setToolTipText("Validate the modify directives file against the batchModify XML Schema.");
        validateBatchModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new BatchModifyValidate();
            }
        });
        toolsBatchModify.add(validateBatchModify);
        toolsBatchSubMenu.add(toolsBatchModify);
        toolsMenu.addSeparator();
        toolsMenu.add(toolsBatchSubMenu);
        JMenuItem toolsAccess = new JMenuItem("Access API", 65);
        toolsAccess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createAccessConsole();
            }
        });
        JMenuItem toolsManagement = new JMenuItem("Management API", 77);
        toolsManagement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.createManagementConsole();
            }
        });
        JMenu toolsConsole = new JMenu("Console");
        toolsConsole.setMnemonic(67);
        toolsConsole.add(toolsAccess);
        toolsConsole.add(toolsManagement);
        toolsMenu.add(toolsConsole);
        menuBar.add(toolsMenu);
        WindowMenu windowMenu = new WindowMenu(s_desktop, "Window");
        windowMenu.setMnemonic(87);
        menuBar.add(windowMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem helpContents = new JMenuItem("Documentation", 68);
        String portPart = "";
        if (Administrator.getPort() != 80) {
            portPart = ":" + Administrator.getPort();
        }
        String documentationURL = Administrator.getProtocol() + "://" + Administrator.getHost() + portPart + "/userdocs/";
        helpContents.setToolTipText("See " + documentationURL);
        helpContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String portPart = "";
                if (Administrator.getPort() != 80) {
                    portPart = ":" + Administrator.getPort();
                }
                String documentationURL = Administrator.getProtocol() + "://" + Administrator.getHost() + portPart + "/userdocs/";
                JOptionPane.showMessageDialog(Administrator.getDesktop(), "For documentation, see " + documentationURL, "Fedora Documentation", 1);
            }
        });
        this.m_aboutDialog = new JDialog(this, "About Fedora Administrator", true);
        this.m_aboutDialog.getContentPane().add((Component)this.m_aboutPic, "Center");
        JButton aboutClose = new JButton("Close");
        JPanel infoAndButton = new JPanel();
        infoAndButton.setLayout(new BorderLayout());
        infoAndButton.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        infoAndButton.add(this.m_aboutText);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(aboutClose);
        infoAndButton.add((Component)buttonPane, "South");
        this.m_aboutDialog.getContentPane().add((Component)infoAndButton, "South");
        aboutClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.m_aboutDialog.setVisible(false);
            }
        });
        this.m_aboutDialog.pack();
        JMenuItem helpAbout = new JMenuItem("About Fedora Administrator", 65);
        helpAbout.setToolTipText("Gives brief information this application");
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Administrator.this.m_aboutDialog.setLocation(Administrator.this.getCenteredPos(Administrator.this.m_aboutDialog.getWidth(), Administrator.this.m_aboutDialog.getHeight()));
                Administrator.this.m_aboutDialog.setVisible(true);
            }
        });
        helpMenu.add(helpContents);
        helpMenu.addSeparator();
        helpMenu.add(helpAbout);
        menuBar.add(helpMenu);
        return menuBar;
    }

    public static File getLastDir() {
        return s_lastDir;
    }

    public static void setLastDir(File f) {
        s_lastDir = f;
    }

    protected void createSearchRepository() {
        Search frame = new Search();
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void createManagementConsole() {
        ManagementConsole frame = new ManagementConsole(this);
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void createAccessConsole() {
        AccessConsole frame = new AccessConsole(this);
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void createBatchBuildConsole() {
        BatchBuildGUI frame = new BatchBuildGUI(this, s_desktop);
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void createBatchBuildIngestConsole() {
        BatchBuildIngestGUI frame = new BatchBuildIngestGUI(this, s_desktop, s_host, s_port, s_user, s_pass);
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void createBatchIngestConsole() {
        BatchIngestGUI frame = new BatchIngestGUI(this, s_desktop, s_host, s_port, s_user, s_pass);
        frame.setVisible(true);
        s_desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public Point getCenteredPos(int xSize, int ySize) {
        Dimension screenSize = this.getToolkit().getScreenSize();
        int maxXPos = screenSize.width - xSize;
        int maxYPos = screenSize.height - ySize;
        int centerX = this.getX() + this.getWidth() / 2;
        int centerY = this.getY() + this.getHeight() / 2;
        int prefXPos = centerX - xSize / 2;
        int prefYPos = centerY - ySize / 2;
        if (prefXPos < 0) {
            prefXPos = 0;
        }
        if (prefXPos > maxXPos) {
            prefXPos = maxXPos;
        }
        if (prefYPos < 0) {
            prefYPos = 0;
        }
        if (prefYPos > maxYPos) {
            prefYPos = maxYPos;
        }
        return new Point(prefXPos, prefYPos);
    }

    public static String getProtocol() {
        return s_protocol;
    }

    public static String getHost() {
        return s_host;
    }

    public static int getPort() {
        return s_port;
    }

    public static String getUser() {
        return s_user;
    }

    public static String getPass() {
        return s_pass;
    }

    public static void main(String[] args) {
        Log4J.force();
        if (args.length == 1) {
            int socketTimeoutSeconds = 120;
            try {
                socketTimeoutSeconds = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            APIAStubFactory.SOCKET_TIMEOUT_SECONDS = socketTimeoutSeconds;
            LOG.info((Object)("Socket timeout set to " + socketTimeoutSeconds + " seconds"));
        }
        String protocol = null;
        String host = null;
        int port = 0;
        String user = null;
        String pass = null;
        Administrator administrator = new Administrator(protocol, host, port, user, pass);
    }

    static {
        ACTIVE_COLOR = new Color(180, 210, 180);
        INACTIVE_COLOR = new Color(210, 210, 180);
        DELETED_COLOR = new Color(210, 180, 180);
        DEFAULT_COLOR = new Color(185, 185, 185);
        DESKTOP_COLOR = new Color(46, 97, 116);
        APIA = null;
        APIM = null;
        INSTANCE = null;
        s_const = ResourceBundle.getBundle("fedora.client.resources.Client");
        VERSION = s_const.getString("version");
        RELEASE_DATE = s_const.getString("releaseDate");
    }
}

