/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.actions;

import fedora.client.Administrator;
import fedora.client.export.ExportOptionsDialog;
import fedora.client.utility.export.AutoExporter;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExportObject
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Set m_pids;
    private boolean m_prompt;

    public ExportObject() {
        super("One Object...");
        this.m_prompt = true;
    }

    public ExportObject(String pid) {
        super("Export...");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
    }

    public ExportObject(Set pids) {
        super("Export Objects...");
        this.m_pids = pids;
    }

    public void actionPerformed(ActionEvent ae) {
        block18: {
            AutoExporter exporter = null;
            try {
                exporter = new AutoExporter(Administrator.APIA, Administrator.APIM);
            }
            catch (Exception e) {
                Administrator.showErrorDialog(Administrator.getDesktop(), "Export Failure", e.getClass().getName() + ": " + e.getMessage(), e);
            }
            if (exporter != null) {
                if (this.m_prompt) {
                    String pid = JOptionPane.showInputDialog("Enter the PID.");
                    if (pid == null) {
                        return;
                    }
                    this.m_pids = new HashSet();
                    this.m_pids.add(pid);
                }
                Iterator pidIter = this.m_pids.iterator();
                if (this.m_pids.size() == 1) {
                    String pid = (String)pidIter.next();
                    try {
                        FileDialog dlg = new FileDialog((Frame)Administrator.INSTANCE, "Export object to...", 1);
                        if (Administrator.getLastDir() != null) {
                            dlg.setDirectory(Administrator.getLastDir().getPath());
                        }
                        dlg.setVisible(true);
                        if (dlg.getFile() == null) break block18;
                        File file = new File(new File(dlg.getDirectory()), dlg.getFile());
                        Administrator.setLastDir(file.getParentFile());
                        ExportOptionsDialog optsDialog = new ExportOptionsDialog("Select Options for Export");
                        if (optsDialog.getFormatSelection() != null) {
                            exporter.export(pid, optsDialog.getFormatSelection(), optsDialog.getContextSelection(), new FileOutputStream(file));
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), "Exported " + pid);
                        }
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Export Failure", e.getClass().getName() + ": " + e.getMessage(), e);
                    }
                } else {
                    try {
                        JFileChooser browse = Administrator.getLastDir() == null ? new JFileChooser() : new JFileChooser(Administrator.getLastDir());
                        browse.setApproveButtonText("Export");
                        browse.setApproveButtonMnemonic('E');
                        browse.setApproveButtonToolTipText("Exports to the selected directory.");
                        browse.setDialogTitle("Export to...");
                        browse.setDialogTitle("Choose export directory...");
                        browse.setFileSelectionMode(1);
                        int returnVal = browse.showOpenDialog(Administrator.getDesktop());
                        if (returnVal == 0) {
                            Administrator.setLastDir(browse.getSelectedFile());
                            ExportOptionsDialog optsDialog = new ExportOptionsDialog("Select Options for Export");
                            if (optsDialog.getFormatSelection() != null) {
                                while (pidIter.hasNext()) {
                                    String pid = (String)pidIter.next();
                                    StringBuffer buf = new StringBuffer();
                                    for (int i = 0; i < pid.length(); ++i) {
                                        char c = pid.charAt(i);
                                        if (c == ':') {
                                            buf.append('_');
                                            continue;
                                        }
                                        buf.append(c);
                                    }
                                    File outFile = new File(browse.getSelectedFile(), buf.toString() + ".xml");
                                    exporter.export(pid, optsDialog.getFormatSelection(), optsDialog.getContextSelection(), new FileOutputStream(outFile));
                                }
                                JOptionPane.showMessageDialog(Administrator.getDesktop(), "Exported " + this.m_pids.size() + " objects.");
                            }
                        }
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Export Failure", e.getClass().getName() + ": " + e.getMessage(), e);
                    }
                }
            }
        }
    }
}

