/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.actions;

import fedora.client.Administrator;
import fedora.client.objecteditor.ObjectEditorFrame;
import fedora.client.utility.AutoPurger;
import fedora.server.utilities.StringUtility;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class PurgeObject
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Set m_pids;
    private boolean m_prompt;
    private ObjectEditorFrame m_parent;

    public PurgeObject() {
        super("Purge Object...");
        this.m_prompt = true;
    }

    public PurgeObject(ObjectEditorFrame parent, String pid) {
        super("Purge Object");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
        this.m_parent = parent;
    }

    public PurgeObject(Set pids) {
        super("Purge Objects");
        this.m_pids = pids;
    }

    public PurgeObject(String pid) {
        super("Purge Object");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
    }

    public void actionPerformed(ActionEvent ae) {
        boolean failed = false;
        if (this.m_prompt) {
            String pid = JOptionPane.showInputDialog("Enter the PID.");
            if (pid == null) {
                return;
            }
            this.m_pids = new HashSet();
            this.m_pids.add(pid);
        }
        AutoPurger purger = null;
        try {
            purger = new AutoPurger(Administrator.APIM);
        }
        catch (Exception e) {
            Administrator.showErrorDialog(Administrator.getDesktop(), "Purge Failure", StringUtility.prettyPrint(e.getClass().getName() + ": " + e.getMessage(), 70, null), e);
        }
        if (purger != null) {
            Iterator pidIter = this.m_pids.iterator();
            if (this.m_pids.size() == 1) {
                String pid = (String)pidIter.next();
                String reason = JOptionPane.showInputDialog("Why are you permanently removing " + pid + "?");
                if (reason != null) {
                    try {
                        purger.purge(pid, reason, false);
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Purge Failure", StringUtility.prettyPrint(e.getClass().getName() + ": " + e.getMessage(), 70, null), e);
                        failed = true;
                    }
                    if (!failed) {
                        JOptionPane.showMessageDialog(Administrator.getDesktop(), "Purge succeeded.");
                        if (this.m_parent != null) {
                            this.m_parent.dispose();
                        }
                    }
                }
            } else {
                String reason = JOptionPane.showInputDialog("Why are you permanently removing these objects?");
                if (reason != null) {
                    while (pidIter.hasNext()) {
                        try {
                            String pid = (String)pidIter.next();
                            purger.purge(pid, reason, false);
                        }
                        catch (Exception e) {
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Purge Failure", StringUtility.prettyPrint(e.getClass().getName() + ": " + e.getMessage(), 70, null), e);
                            failed = true;
                        }
                    }
                    if (!failed) {
                        JOptionPane.showMessageDialog(Administrator.getDesktop(), "Purge of " + this.m_pids.size() + " objects succeeded.");
                    }
                }
            }
        }
    }
}

