/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.FedoraClient;
import fedora.client.Uploader;
import fedora.client.batch.BatchModifyXMLErrorHandler;
import fedora.client.batch.types.Datastream;
import fedora.client.batch.types.DigitalObject;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.ComparisonOperator;
import fedora.server.types.gen.Condition;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.utilities.StreamUtility;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BatchModifyParser
extends DefaultHandler
implements Constants {
    private static Uploader UPLOADER;
    private static FedoraAPIM APIM;
    private static FedoraAPIA APIA;
    private static PrintStream out;
    private int succeededCount = 0;
    private int failedCount = 0;
    private HashMap<String, String> nsPrefixMap;
    private HashMap<String, String> m_prefixUris;
    private StringBuffer m_dsXMLBuffer;
    private StringBuffer m_dsFirstElementBuffer;
    private ArrayList<String> m_dsPrefixes;
    private boolean m_inXMLMetadata;
    private boolean m_firstInlineXMLElement;
    private boolean addObject = false;
    private boolean modifyObject = false;
    private boolean purgeObject = false;
    private boolean addDatastream = false;
    private boolean modifyDatastream = false;
    private boolean purgeDatastream = false;
    private boolean setDatastreamState = false;
    private boolean setDatastreamVersionable = false;
    private boolean compareDatastreamChecksum = false;
    private Datastream m_ds;
    private DigitalObject m_obj;

    public BatchModifyParser(Uploader UPLOADER, FedoraAPIM APIM, FedoraAPIA APIA, InputStream in, PrintStream out) {
        BatchModifyParser.out = out;
        BatchModifyParser.APIM = APIM;
        BatchModifyParser.APIA = APIA;
        BatchModifyParser.UPLOADER = UPLOADER;
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxfactory = SAXParserFactory.newInstance();
            saxfactory.setValidating(true);
            SAXParser parser = saxfactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlReader.setErrorHandler(new BatchModifyXMLErrorHandler());
        }
        catch (Exception e) {
            BatchModifyParser.logParserError(e, null);
            this.failedCount = -1;
        }
        try {
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            BatchModifyParser.logParserError(e, null);
            this.failedCount = -1;
        }
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public int getSucceededCount() {
        return this.succeededCount;
    }

    public void startDocument() throws SAXException {
        this.nsPrefixMap = new HashMap();
        this.m_prefixUris = new HashMap();
    }

    public void endDocument() throws SAXException {
        this.nsPrefixMap = null;
        this.m_prefixUris = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_prefixUris.put(prefix, uri);
        this.nsPrefixMap.put(uri, prefix);
        if (this.m_inXMLMetadata && !this.m_dsPrefixes.contains(prefix) && !"".equals(prefix)) {
            this.m_dsPrefixes.add(prefix);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        StringBuffer sb = new StringBuffer();
        sb.append('&');
        sb.append(name);
        sb.append(';');
        char[] text = new char[sb.length()];
        sb.getChars(0, sb.length(), text, 0);
        this.characters(text, 0, text.length);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inXMLMetadata) {
            StreamUtility.enc(ch, start, length, this.m_dsXMLBuffer);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        block73: {
            if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("addObject")) {
                this.addObject = false;
                this.m_obj = new DigitalObject();
                this.m_obj.pid = attrs.getValue("pid");
                this.m_obj.label = attrs.getValue("label");
                this.m_obj.logMessage = attrs.getValue("logMessage");
                try {
                    if (this.m_obj.label.equals("")) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, null, "Object Label must be non-empty.");
                        return;
                    }
                    if (!this.m_obj.pid.equals("") && this.m_obj.pid.indexOf(":") < 1) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, null, "Custom PID should be of the form \"namespace:1234\"");
                        return;
                    }
                    this.addObject = true;
                }
                catch (Exception e) {
                    ++this.failedCount;
                    BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, "");
                }
            } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("modifyObject")) {
                this.modifyObject = false;
                this.m_obj = new DigitalObject();
                this.m_obj.pid = attrs.getValue("pid");
                this.m_obj.logMessage = attrs.getValue("logMessage");
                try {
                    if (!this.m_obj.pid.equals("") && this.m_obj.pid.indexOf(":") < 1) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, null, "Custom PID should be of the form \"namespace:1234\"");
                        return;
                    }
                    this.m_obj.label = attrs.getValue("label") != null ? attrs.getValue("label") : null;
                    this.m_obj.state = attrs.getValue("state") != null ? attrs.getValue("state") : null;
                    this.m_obj.ownerId = attrs.getValue("ownerId") != null ? attrs.getValue("ownerId") : null;
                    this.modifyObject = true;
                }
                catch (Exception e) {
                    ++this.failedCount;
                    BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, "");
                }
            } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("purgeObject")) {
                this.purgeObject = false;
                this.m_obj = new DigitalObject();
                this.m_obj.pid = attrs.getValue("pid");
                this.m_obj.logMessage = attrs.getValue("logMessage");
                try {
                    if (!this.m_obj.pid.equals("") && this.m_obj.pid.indexOf(":") < 1) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, null, "Custom PID should be of the form \"namespace:1234\"");
                        return;
                    }
                    this.m_obj.force = attrs.getValue("force") != null ? new Boolean(attrs.getValue("force")) : false;
                    this.purgeObject = true;
                }
                catch (Exception e) {
                    ++this.failedCount;
                    BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, "");
                }
            } else {
                if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("addDatastream")) {
                    try {
                        this.addDatastream = false;
                        this.m_ds = new Datastream();
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsControlGrp = attrs.getValue("dsControlGroupType");
                        this.m_ds.dsLabel = attrs.getValue("dsLabel");
                        this.m_ds.dsState = attrs.getValue("dsState");
                        this.m_ds.dsMIME = attrs.getValue("dsMIME");
                        this.m_ds.logMessage = attrs.getValue("logMessage");
                        this.m_ds.dsID = attrs.getValue("dsID") != null && !attrs.getValue("dsID").equals("") ? attrs.getValue("dsID") : null;
                        if (attrs.getValue("dsLocation") != null && !attrs.getValue("dsLocation").equals("")) {
                            this.m_ds.dsLocation = attrs.getValue("dsLocation");
                        }
                        if (attrs.getValue("formatURI") != null && !attrs.getValue("formatURI").equals("")) {
                            this.m_ds.formatURI = attrs.getValue("formatURI");
                        }
                        if (attrs.getValue("versionable") != null && !attrs.getValue("versionable").equals("")) {
                            this.m_ds.versionable = new Boolean(attrs.getValue("versionable"));
                        }
                        if (attrs.getValue("altIDs") != null && !attrs.getValue("altIDs").equals("")) {
                            this.m_ds.altIDs = attrs.getValue("altIDs").split(" ");
                        }
                        if (attrs.getValue("checksumType") != null && !attrs.getValue("checksumType").equals("")) {
                            this.m_ds.checksumType = attrs.getValue("checksumType");
                        }
                        if (attrs.getValue("checksum") != null && !attrs.getValue("checksum").equals("")) {
                            this.m_ds.checksum = attrs.getValue("checksum");
                        }
                        this.addDatastream = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                        return;
                    }
                }
                if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("purgeDatastream")) {
                    try {
                        this.purgeDatastream = false;
                        this.m_ds = new Datastream();
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsID = attrs.getValue("dsID");
                        this.m_ds.logMessage = attrs.getValue("logMessage");
                        if (attrs.getValue("asOfDate") != null && !attrs.getValue("asOfDate").equals("")) {
                            this.m_ds.asOfDate = attrs.getValue("asOfDate");
                        }
                        if (attrs.getValue("endDate") != null && !attrs.getValue("endDate").equals("")) {
                            this.m_ds.endDate = attrs.getValue("endDate");
                        }
                        if (attrs.getValue("force") != null && !attrs.getValue("force").equals("")) {
                            this.m_ds.force = new Boolean(attrs.getValue("force"));
                        }
                        this.purgeDatastream = true;
                    }
                    catch (Exception e) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                    }
                } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("modifyDatastream")) {
                    try {
                        fedora.server.types.gen.Datastream dsOrig = null;
                        this.modifyDatastream = false;
                        this.m_ds = new Datastream();
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsID = attrs.getValue("dsID");
                        this.m_ds.dsControlGrp = attrs.getValue("dsControlGroupType");
                        this.m_ds.logMessage = attrs.getValue("logMessage");
                        try {
                            dsOrig = APIM.getDatastream(this.m_ds.objectPID, this.m_ds.dsID, null);
                        }
                        catch (Exception e) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, null, "Datastream ID: " + this.m_ds.dsID + " does not exist" + " in the object: " + this.m_ds.objectPID + " .\n    Unable to modify" + "datastream.");
                            return;
                        }
                        if (dsOrig.getControlGroup().getValue().equalsIgnoreCase(this.m_ds.dsControlGrp)) {
                            this.m_ds.dsLabel = attrs.getValue("dsLabel") != null ? attrs.getValue("dsLabel") : dsOrig.getLabel();
                            this.m_ds.dsLocation = attrs.getValue("dsLocation") != null ? attrs.getValue("dsLocation") : dsOrig.getLocation();
                            this.m_ds.dsMIME = attrs.getValue("dsMIME") != null ? attrs.getValue("dsMIME") : dsOrig.getMIMEType();
                            this.m_ds.force = attrs.getValue("force") != null ? new Boolean(attrs.getValue("force")) : false;
                            this.m_ds.altIDs = attrs.getValue("altIDs") != null ? attrs.getValue("altIDs").split(" ") : dsOrig.getAltIDs();
                            this.m_ds.formatURI = attrs.getValue("formatURI") != null ? attrs.getValue("formatURI") : dsOrig.getFormatURI();
                            if (attrs.getValue("checksumType") != null) {
                                this.m_ds.checksumType = attrs.getValue("checksumType");
                            }
                            if (attrs.getValue("checksum") != null) {
                                this.m_ds.checksum = attrs.getValue("checksum");
                            }
                            this.modifyDatastream = true;
                            break block73;
                        }
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, null, " Datastream Control Group Type of: " + this.m_ds.dsControlGrp + " in directives file does not match control group" + " type in original datastream: " + dsOrig.getControlGroup().getValue());
                    }
                    catch (Exception e) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                    }
                } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("setDatastreamState")) {
                    try {
                        this.m_ds = new Datastream();
                        this.setDatastreamState = false;
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsID = attrs.getValue("dsID");
                        this.m_ds.dsState = attrs.getValue("dsState");
                        this.m_ds.logMessage = attrs.getValue("logMessage");
                        this.setDatastreamState = true;
                    }
                    catch (Exception e) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                    }
                } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("setDatastreamVersionable")) {
                    try {
                        this.m_ds = new Datastream();
                        this.setDatastreamVersionable = false;
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsID = attrs.getValue("dsID");
                        this.m_ds.versionable = new Boolean(attrs.getValue("versionable"));
                        this.m_ds.logMessage = attrs.getValue("logMessage");
                        this.setDatastreamVersionable = true;
                    }
                    catch (Exception e) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                    }
                } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("compareDatastreamChecksum")) {
                    try {
                        this.m_ds = new Datastream();
                        this.compareDatastreamChecksum = false;
                        this.m_ds.objectPID = attrs.getValue("pid");
                        this.m_ds.dsID = attrs.getValue("dsID");
                        if (attrs.getValue("asOfDate") != null && !attrs.getValue("asOfDate").equals("")) {
                            this.m_ds.asOfDate = attrs.getValue("asOfDate");
                        }
                        this.compareDatastreamChecksum = true;
                    }
                    catch (Exception e) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                    }
                } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("xmlData")) {
                    this.m_inXMLMetadata = true;
                    this.m_dsXMLBuffer = new StringBuffer();
                    this.m_dsFirstElementBuffer = new StringBuffer();
                    this.m_dsPrefixes = new ArrayList();
                    this.m_firstInlineXMLElement = true;
                } else if (this.m_inXMLMetadata) {
                    String prefix = this.nsPrefixMap.get(namespaceURI);
                    if (this.m_firstInlineXMLElement) {
                        this.m_firstInlineXMLElement = false;
                        this.m_dsFirstElementBuffer.append('<');
                        if (prefix != null) {
                            if (!this.m_dsPrefixes.contains(prefix)) {
                                this.m_dsPrefixes.add(prefix);
                            }
                            if (!prefix.equals("")) {
                                this.m_dsFirstElementBuffer.append(prefix);
                                this.m_dsFirstElementBuffer.append(':');
                            }
                        }
                        this.m_dsFirstElementBuffer.append(localName);
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            this.m_dsFirstElementBuffer.append(' ');
                            String aPrefix = this.nsPrefixMap.get(attrs.getURI(i));
                            if (aPrefix != null) {
                                if (!this.m_dsPrefixes.contains(aPrefix)) {
                                    this.m_dsPrefixes.add(aPrefix);
                                }
                                if (!prefix.equals("")) {
                                    this.m_dsFirstElementBuffer.append(aPrefix);
                                    this.m_dsFirstElementBuffer.append(':');
                                }
                            }
                            if (attrs.getLocalName(i).equals("")) continue;
                            this.m_dsFirstElementBuffer.append(attrs.getLocalName(i));
                            this.m_dsFirstElementBuffer.append("=\"");
                            this.m_dsFirstElementBuffer.append(StreamUtility.enc(attrs.getValue(i)));
                            this.m_dsFirstElementBuffer.append("\"");
                        }
                    } else {
                        this.m_dsXMLBuffer.append('<');
                        if (prefix != null) {
                            if (!this.m_dsPrefixes.contains(prefix)) {
                                this.m_dsPrefixes.add(prefix);
                            }
                            if (!prefix.equals("")) {
                                this.m_dsXMLBuffer.append(prefix);
                                this.m_dsXMLBuffer.append(':');
                            }
                        }
                        this.m_dsXMLBuffer.append(localName);
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            this.m_dsXMLBuffer.append(' ');
                            String aPrefix = this.nsPrefixMap.get(attrs.getURI(i));
                            if (aPrefix != null) {
                                if (!this.m_dsPrefixes.contains(aPrefix)) {
                                    this.m_dsPrefixes.add(aPrefix);
                                }
                                if (!prefix.equals("")) {
                                    this.m_dsXMLBuffer.append(aPrefix);
                                    this.m_dsXMLBuffer.append(':');
                                }
                            }
                            this.m_dsXMLBuffer.append(attrs.getLocalName(i));
                            this.m_dsXMLBuffer.append("=\"");
                            this.m_dsXMLBuffer.append(StreamUtility.enc(attrs.getValue(i)));
                            this.m_dsXMLBuffer.append("\"");
                        }
                    }
                    this.m_dsXMLBuffer.append('>');
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.m_inXMLMetadata) {
            if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equals("xmlData")) {
                String[] prefixes = new String[this.m_dsPrefixes.size()];
                for (int i = 0; i < this.m_dsPrefixes.size(); ++i) {
                    String pfx;
                    prefixes[i] = pfx = this.m_dsPrefixes.get(i);
                    String pfxUri = this.m_prefixUris.get(pfx);
                    if (pfx.equals("")) {
                        this.m_dsFirstElementBuffer.append(" xmlns");
                    } else {
                        this.m_dsFirstElementBuffer.append(" xmlns:");
                        this.m_dsFirstElementBuffer.append(pfx);
                    }
                    this.m_dsFirstElementBuffer.append("=\"");
                    this.m_dsFirstElementBuffer.append(pfxUri);
                    this.m_dsFirstElementBuffer.append("\"");
                }
                this.m_inXMLMetadata = false;
                this.m_inXMLMetadata = false;
                this.m_inXMLMetadata = false;
                this.m_firstInlineXMLElement = false;
                String combined = this.m_dsFirstElementBuffer.toString() + this.m_dsXMLBuffer.toString();
                try {
                    if (this.m_ds != null && combined != null) {
                        this.m_ds.xmlContent = combined.getBytes("UTF-8");
                    }
                }
                catch (UnsupportedEncodingException uee) {}
            } else {
                this.m_dsXMLBuffer.append("</");
                String prefix = this.nsPrefixMap.get(namespaceURI);
                if (prefix != null && !prefix.equals("")) {
                    this.m_dsXMLBuffer.append(prefix);
                    this.m_dsXMLBuffer.append(':');
                }
                this.m_dsXMLBuffer.append(localName);
                this.m_dsXMLBuffer.append(">");
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("addObject")) {
            try {
                block97: {
                    try {
                        if (!this.addObject) break block97;
                        StringBuffer xml = new StringBuffer();
                        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        xml.append("<" + BatchModifyParser.FOXML.DIGITAL_OBJECT.qName + " ");
                        xml.append(BatchModifyParser.FOXML.VERSION.localName + "=\"1.1\"");
                        if (this.m_obj.pid != null && this.m_obj.pid.length() > 0) {
                            xml.append(" " + BatchModifyParser.FOXML.PID.localName + "=\"");
                            xml.append(StreamUtility.enc(this.m_obj.pid) + "\"");
                        }
                        xml.append("\n");
                        xml.append("    xmlns:" + BatchModifyParser.FOXML.prefix + "=\"");
                        xml.append(BatchModifyParser.FOXML.uri + "\"\n");
                        xml.append("    xmlns:" + BatchModifyParser.XSI.prefix + "=\"");
                        xml.append(BatchModifyParser.XSI.uri + "\"\n");
                        xml.append("    " + BatchModifyParser.XSI.SCHEMA_LOCATION.qName + "=\"");
                        xml.append(BatchModifyParser.FOXML.uri + " " + BatchModifyParser.FOXML1_1.xsdLocation);
                        xml.append("\">\n");
                        xml.append("  <" + BatchModifyParser.FOXML.OBJECT_PROPERTIES.qName + ">\n");
                        BatchModifyParser.appendProperty(xml, BatchModifyParser.MODEL.LABEL.uri, this.m_obj.label);
                        xml.append("  </" + BatchModifyParser.FOXML.OBJECT_PROPERTIES.qName + ">\n");
                        xml.append("</" + BatchModifyParser.FOXML.DIGITAL_OBJECT.qName + ">");
                        String objXML = xml.toString();
                        ByteArrayInputStream in = new ByteArrayInputStream(objXML.getBytes("UTF-8"));
                        String newPID = AutoIngestor.ingestAndCommit(APIA, APIM, in, BatchModifyParser.FOXML1_1.uri, "Created with BatchModify Utility \"addObject\" directive");
                        ++this.succeededCount;
                        BatchModifyParser.logSucceededDirective(newPID, localName, " Added new object with PID: " + newPID);
                    }
                    catch (Exception e) {
                        if (this.addObject) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, "");
                        }
                        Object var9_30 = null;
                        this.addObject = false;
                    }
                }
                Object var9_29 = null;
                this.addObject = false;
            }
            catch (Throwable throwable) {
                Object var9_31 = null;
                this.addObject = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("modifyObject")) {
            try {
                try {
                    if (this.modifyObject) {
                        APIM.modifyObject(this.m_obj.pid, this.m_obj.state, this.m_obj.label, this.m_obj.ownerId, "ModifyObject");
                    }
                    ++this.succeededCount;
                    BatchModifyParser.logSucceededDirective(this.m_obj.pid, localName, "Object PID: " + this.m_obj.pid + " modified");
                }
                catch (Exception e) {
                    if (this.modifyObject) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, null);
                    }
                    Object var11_34 = null;
                    this.modifyObject = false;
                }
                Object var11_33 = null;
                this.modifyObject = false;
            }
            catch (Throwable throwable) {
                Object var11_35 = null;
                this.modifyObject = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("purgeObject")) {
            try {
                block98: {
                    try {
                        if (!this.purgeObject) break block98;
                        String purgedPid = null;
                        purgedPid = APIM.purgeObject(this.m_obj.pid, "PurgeObject", this.m_obj.force);
                        if (purgedPid != null) {
                            ++this.succeededCount;
                            BatchModifyParser.logSucceededDirective(this.m_obj.pid, localName, "Purged PID: " + this.m_obj.pid);
                            break block98;
                        }
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, null, "Unable to purge object with PID: " + this.m_obj.pid);
                    }
                    catch (Exception e) {
                        if (this.purgeObject) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_obj.pid, localName, e, "");
                        }
                        Object var13_38 = null;
                        this.purgeObject = false;
                    }
                }
                Object var13_37 = null;
                this.purgeObject = false;
            }
            catch (Throwable throwable) {
                Object var13_39 = null;
                this.purgeObject = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("addDatastream")) {
            try {
                block99: {
                    try {
                        if (!this.addDatastream) break block99;
                        String datastreamID = null;
                        if (this.m_ds.dsControlGrp.equalsIgnoreCase("X")) {
                            ByteArrayInputStream xmlMetadata = new ByteArrayInputStream(this.m_ds.xmlContent);
                            this.m_ds.dsLocation = UPLOADER.upload(xmlMetadata);
                            datastreamID = APIM.addDatastream(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.altIDs, this.m_ds.dsLabel, this.m_ds.versionable, this.m_ds.dsMIME, this.m_ds.formatURI, this.m_ds.dsLocation, this.m_ds.dsControlGrp, this.m_ds.dsState, this.m_ds.checksumType, this.m_ds.checksum, this.m_ds.logMessage);
                        } else if (this.m_ds.dsControlGrp.equalsIgnoreCase("E") || this.m_ds.dsControlGrp.equalsIgnoreCase("M") || this.m_ds.dsControlGrp.equalsIgnoreCase("R")) {
                            datastreamID = APIM.addDatastream(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.altIDs, this.m_ds.dsLabel, this.m_ds.versionable, this.m_ds.dsMIME, this.m_ds.formatURI, this.m_ds.dsLocation, this.m_ds.dsControlGrp, this.m_ds.dsState, this.m_ds.checksumType, this.m_ds.checksum, this.m_ds.logMessage);
                        }
                        if (datastreamID != null) {
                            ++this.succeededCount;
                            BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastreamID: " + datastreamID + " added");
                            break block99;
                        }
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, null, "Unable to add datastream");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.addDatastream) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                        }
                        Object var15_42 = null;
                        this.addDatastream = false;
                    }
                }
                Object var15_41 = null;
                this.addDatastream = false;
            }
            catch (Throwable throwable) {
                Object var15_43 = null;
                this.addDatastream = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("purgeDatastream")) {
            try {
                block100: {
                    try {
                        if (!this.purgeDatastream) break block100;
                        String[] versionsPurged = null;
                        versionsPurged = APIM.purgeDatastream(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.asOfDate, this.m_ds.endDate, this.m_ds.logMessage, this.m_ds.force);
                        if (versionsPurged.length > 0) {
                            ++this.succeededCount;
                            if (this.m_ds.asOfDate != null && this.m_ds.endDate != null) {
                                BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastreamID: " + this.m_ds.dsID + "\n    Purged all versions from: " + this.m_ds.asOfDate + " to " + this.m_ds.endDate + "\n    Versions purged: " + versionsPurged.length);
                            } else if (this.m_ds.asOfDate == null && this.m_ds.endDate == null) {
                                BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastreamID: " + this.m_ds.dsID + "\n    Purged all versions. " + "\n    Versions purged: " + versionsPurged.length);
                            } else if (this.m_ds.asOfDate != null && this.m_ds.endDate == null) {
                                BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastreamID: " + this.m_ds.dsID + "\n    Purged all versions after : " + this.m_ds.asOfDate + "\n    Versions purged: " + versionsPurged.length);
                            } else if (this.m_ds.asOfDate == null && this.m_ds.endDate != null) {
                                BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastreamID: " + this.m_ds.dsID + "\n    Purged all versions prior to : " + this.m_ds.endDate + "\n    Versions purged: " + versionsPurged.length);
                            }
                            break block100;
                        }
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, null, "Unable to purge datastream; verify datastream ID and/or asOfDate");
                    }
                    catch (Exception e) {
                        if (this.purgeDatastream) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, "");
                        }
                        Object var17_46 = null;
                        this.purgeDatastream = false;
                    }
                }
                Object var17_45 = null;
                this.purgeDatastream = false;
            }
            catch (Throwable throwable) {
                Object var17_47 = null;
                this.purgeDatastream = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("modifyDatastream")) {
            try {
                block101: {
                    try {
                        if (!this.modifyDatastream) break block101;
                        if (this.m_ds.dsControlGrp.equalsIgnoreCase("X")) {
                            APIM.modifyDatastreamByValue(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.altIDs, this.m_ds.dsLabel, this.m_ds.dsMIME, this.m_ds.formatURI, this.m_ds.xmlContent, this.m_ds.checksumType, this.m_ds.checksum, this.m_ds.logMessage, this.m_ds.force);
                        } else if (this.m_ds.dsControlGrp.equalsIgnoreCase("E") || this.m_ds.dsControlGrp.equalsIgnoreCase("M") || this.m_ds.dsControlGrp.equalsIgnoreCase("R")) {
                            APIM.modifyDatastreamByReference(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.altIDs, this.m_ds.dsLabel, this.m_ds.dsMIME, this.m_ds.formatURI, this.m_ds.dsLocation, this.m_ds.checksumType, this.m_ds.checksum, this.m_ds.logMessage, this.m_ds.force);
                        }
                        ++this.succeededCount;
                        BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "DatastreamID: " + this.m_ds.dsID + " modified");
                    }
                    catch (Exception e) {
                        if (this.modifyDatastream) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, null);
                        }
                        Object var19_50 = null;
                        this.modifyDatastream = false;
                    }
                }
                Object var19_49 = null;
                this.modifyDatastream = false;
            }
            catch (Throwable throwable) {
                Object var19_51 = null;
                this.modifyDatastream = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("setDatastreamState")) {
            try {
                block102: {
                    try {
                        if (!this.setDatastreamState) break block102;
                        APIM.setDatastreamState(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.dsState, "SetDatastreamState");
                        ++this.succeededCount;
                        BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastream: " + this.m_ds.dsID + "\n    Set dsState: " + this.m_ds.dsState);
                    }
                    catch (Exception e) {
                        if (this.setDatastreamState) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, null);
                        }
                        Object var21_54 = null;
                        this.setDatastreamState = false;
                    }
                }
                Object var21_53 = null;
                this.setDatastreamState = false;
            }
            catch (Throwable throwable) {
                Object var21_55 = null;
                this.setDatastreamState = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("setDatastreamVersionable")) {
            try {
                block103: {
                    try {
                        if (!this.setDatastreamVersionable) break block103;
                        APIM.setDatastreamVersionable(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.versionable, "SetDatastreamVersionable");
                        ++this.succeededCount;
                        BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastream: " + this.m_ds.dsID + "\n    Set dsVersionable: " + this.m_ds.versionable);
                    }
                    catch (Exception e) {
                        if (this.setDatastreamVersionable) {
                            ++this.failedCount;
                            BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, null);
                        }
                        Object var23_58 = null;
                        this.setDatastreamVersionable = false;
                    }
                }
                Object var23_57 = null;
                this.setDatastreamVersionable = false;
            }
            catch (Throwable throwable) {
                Object var23_59 = null;
                this.setDatastreamVersionable = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("compareDatastreamChecksum")) {
            try {
                try {
                    if (this.compareDatastreamChecksum) {
                        String msg = APIM.compareDatastreamChecksum(this.m_ds.objectPID, this.m_ds.dsID, this.m_ds.asOfDate);
                        if (!msg.equals("Checksum validation error")) {
                            ++this.succeededCount;
                            BatchModifyParser.logSucceededDirective(this.m_ds.objectPID, localName, "datastream: " + this.m_ds.dsID + "\n    compareDatastreamChecksum: " + msg);
                        } else {
                            throw new Exception("Checksum validation error");
                        }
                    }
                    Object var25_61 = null;
                    this.compareDatastreamChecksum = false;
                }
                catch (Exception e) {
                    if (this.compareDatastreamChecksum) {
                        ++this.failedCount;
                        BatchModifyParser.logFailedDirective(this.m_ds.objectPID, localName, e, null);
                    }
                    Object var25_62 = null;
                    this.compareDatastreamChecksum = false;
                }
            }
            catch (Throwable throwable) {
                Object var25_63 = null;
                this.compareDatastreamChecksum = false;
                throw throwable;
            }
        } else if (namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) && localName.equalsIgnoreCase("addDatastreamBinding") || !namespaceURI.equalsIgnoreCase(BatchModifyParser.BATCH_MODIFY.uri) || localName.equalsIgnoreCase("removeDatastreamBinding")) {
            // empty if block
        }
    }

    private static void appendProperty(StringBuffer xml, String uri, String value) {
        xml.append("    <" + BatchModifyParser.FOXML.PROPERTY.qName + " ");
        xml.append(BatchModifyParser.FOXML.NAME.localName + "=\"");
        xml.append(uri + "\" " + BatchModifyParser.FOXML.VALUE.localName + "=\"");
        xml.append(StreamUtility.enc(value) + "\"/>\n");
    }

    private static void logFailedDirective(String sourcePID, String directive, Exception e, String msg) {
        out.println("  <failed directive=\"" + directive + "\" sourcePID=\"" + sourcePID + "\">");
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            out.println("    " + StreamUtility.enc(message));
        } else {
            out.println("    " + StreamUtility.enc(msg));
        }
        out.println("  </failed>");
    }

    private static void logParserError(Exception e, String msg) {
        out.println("  <parserError>");
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            out.println("    " + StreamUtility.enc(message));
        } else {
            out.println("    " + StreamUtility.enc(msg));
        }
        out.println("  </parserError>");
    }

    private static void logSucceededDirective(String sourcePID, String directive, String msg) {
        out.println("  <succeeded directive=\"" + directive + "\" sourcePID=\"" + sourcePID + "\">");
        out.println("    " + StreamUtility.enc(msg));
        out.println("  </succeeded>");
    }

    public static Map getServiceLabelMap() throws IOException {
        try {
            HashMap labelMap = new HashMap();
            FieldSearchQuery query = new FieldSearchQuery();
            Condition[] conditions = new Condition[]{new Condition()};
            conditions[0].setProperty("fType");
            conditions[0].setOperator(ComparisonOperator.fromValue("eq"));
            conditions[0].setValue("D");
            query.setConditions(conditions);
            String[] fields = new String[]{"pid", "label"};
            throw new UnsupportedOperationException("This operation uses obsolete field search semantics");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Map getDeploymentLabelMap(String sDefPID) throws IOException {
        try {
            HashMap labelMap = new HashMap();
            FieldSearchQuery query = new FieldSearchQuery();
            Condition[] conditions = new Condition[2];
            conditions[0] = new Condition();
            conditions[0].setProperty("fType");
            conditions[0].setOperator(ComparisonOperator.fromValue("eq"));
            conditions[0].setValue("M");
            conditions[1] = new Condition();
            conditions[1].setProperty("bDef");
            conditions[1].setOperator(ComparisonOperator.fromValue("has"));
            conditions[1].setValue(sDefPID);
            query.setConditions(conditions);
            String[] fields = new String[]{"pid", "label"};
            throw new UnsupportedOperationException("This operation uses obsolete field search semantics");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length == 5) {
            String host = args[0];
            int port = new Integer(args[1]);
            String user = args[2];
            String pass = args[3];
            String protocol = args[4];
            try {
                UPLOADER = new Uploader(host, port, user, pass);
                PrintStream logFile = new PrintStream(new FileOutputStream("C:\\zlogfile.txt"));
                String baseURL = protocol + "://" + host + ":" + port + "/fedora";
                FedoraClient fc = new FedoraClient(baseURL, user, pass);
                FedoraAPIA APIA = fc.getAPIA();
                FedoraAPIM APIM = fc.getAPIM();
                FileInputStream file = new FileInputStream("c:\\fedora\\mellon\\dist\\client\\demo\\batch-demo\\modify-batch-directives-valid.xml");
                BatchModifyParser bmp = new BatchModifyParser(UPLOADER, APIM, APIA, file, logFile);
                ((InputStream)file).close();
                logFile.close();
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
            }
        } else {
            System.out.println("Enter args for: host port user pass protocol");
        }
    }
}

