/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.console;

import fedora.client.console.InputPanel;
import fedora.common.Constants;
import fedora.server.utilities.StreamUtility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ByteArrayInputPanel
extends InputPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JTextField m_textField;
    private final JTextField m_fileField;
    private JFileChooser m_browse;
    private final JRadioButton m_fromTextRadioButton;
    private static File s_lastDir;

    public ByteArrayInputPanel(boolean primitive) {
        File f;
        this.setLayout(new BoxLayout(this, 1));
        if (Constants.FEDORA_HOME != null && (f = new File(Constants.FEDORA_HOME)).exists() && f.isDirectory()) {
            s_lastDir = f;
        }
        JPanel fromText = new JPanel();
        fromText.setLayout(new BoxLayout(fromText, 0));
        this.m_fromTextRadioButton = new JRadioButton("Text: ");
        this.m_fromTextRadioButton.setSelected(true);
        fromText.add(this.m_fromTextRadioButton);
        this.m_textField = new JTextField(10);
        fromText.add(this.m_textField);
        this.add(fromText);
        JPanel fromFile = new JPanel();
        fromFile.setLayout(new BoxLayout(fromFile, 0));
        JRadioButton fromFileRadioButton = new JRadioButton("File: ");
        fromFile.add(fromFileRadioButton);
        this.m_fileField = new JTextField(10);
        fromFile.add(this.m_fileField);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(this);
        fromFile.add(browseButton);
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_fromTextRadioButton);
        g.add(fromFileRadioButton);
        this.add(fromFile);
        this.m_browse = s_lastDir == null ? new JFileChooser() : new JFileChooser(s_lastDir);
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal = this.m_browse.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.m_browse.getSelectedFile();
            s_lastDir = file.getParentFile();
            this.m_fileField.setText(file.getAbsolutePath());
        }
    }

    public Object getValue() {
        if (this.m_fromTextRadioButton.isSelected()) {
            return this.m_textField.getText().getBytes();
        }
        File f = new File(this.m_fileField.getText());
        if (!f.exists() || f.isDirectory()) {
            System.out.println("returning null..file doesnt exist");
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileInputStream in = new FileInputStream(f);
            StreamUtility.pipeStream(in, out, 4096);
            return out.toByteArray();
        }
        catch (IOException ioe) {
            System.out.println("ioexecption getting filestream: " + ioe.getMessage());
            return null;
        }
    }
}

