/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.console;

import java.lang.reflect.Method;

public class ConsoleCommand {
    Method m_method;
    String m_methodDescription;
    String[] m_paramNames;
    String[] m_paramDescriptions;
    String m_returnDescription;

    public ConsoleCommand(Method method, String methodDescription, String[] paramNames, String[] paramDescriptions, String returnDescription) {
        this.m_method = method;
        this.m_methodDescription = methodDescription;
        this.m_paramNames = paramNames;
        if (paramNames == null) {
            this.m_paramNames = new String[method.getParameterTypes().length];
            for (int i = 0; i < this.m_paramNames.length; ++i) {
                this.m_paramNames[i] = "param" + (i + 1);
            }
        }
        this.m_paramDescriptions = paramDescriptions;
        this.m_returnDescription = returnDescription;
    }

    public String getName() {
        return this.m_method.getName();
    }

    public Class[] getParameterTypes() {
        return this.m_method.getParameterTypes();
    }

    public String[] getParameterNames() {
        return this.m_paramNames;
    }

    public String[] getParameterDescriptions() {
        return this.m_paramDescriptions;
    }

    public String getMethodDescription() {
        return this.m_methodDescription;
    }

    public Class getReturnType() {
        return this.m_method.getReturnType();
    }

    public Object invoke(Object instance, Object[] paramValues) throws Throwable {
        return this.m_method.invoke(instance, paramValues);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getUnqualifiedName(this.m_method.getReturnType()));
        ret.append(" ");
        ret.append(this.m_method.getName());
        ret.append("(");
        Class<?>[] types = this.m_method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(this.getUnqualifiedName(types[i]));
            ret.append(' ');
            ret.append(this.m_paramNames[i]);
        }
        ret.append(")");
        return ret.toString();
    }

    public String getUnqualifiedName(Class cl) {
        if (cl == null) {
            return "void";
        }
        if (cl.getPackage() == null) {
            return this.bracketsForArrays(cl.getName());
        }
        String pName = cl.getPackage().getName();
        if (pName != null && pName.length() > 0) {
            return cl.getName().substring(pName.length() + 1);
        }
        return this.bracketsForArrays(cl.getName());
    }

    private String bracketsForArrays(String in) {
        if (in.equals("[B")) {
            return "byte[]";
        }
        if (in.startsWith("[L")) {
            try {
                return this.getUnqualifiedName(Class.forName(in.substring(2, in.length() - 1))) + "[]";
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("class not found: " + in.substring(2, in.length() - 1));
            }
        }
        return in;
    }
}

