/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.console;

import fedora.client.console.ArrayInputPanel;
import fedora.client.console.BooleanInputPanel;
import fedora.client.console.ByteArrayInputPanel;
import fedora.client.console.DateTimeInputPanel;
import fedora.client.console.InputPanel;
import fedora.client.console.NonNegativeIntegerInputPanel;
import fedora.client.console.NullInputPanel;
import fedora.client.console.StringInputPanel;

public abstract class InputPanelFactory {
    public static InputPanel getPanel(Class cl) {
        if (cl.getName().equals("java.lang.String")) {
            return new StringInputPanel();
        }
        if (cl.getName().equals("[B")) {
            return new ByteArrayInputPanel(true);
        }
        if (cl.getName().equals("boolean")) {
            return new BooleanInputPanel(true);
        }
        if (cl.getName().equals("java.lang.Boolean")) {
            return new BooleanInputPanel(false);
        }
        if (cl.getName().equals("java.util.Date")) {
            return new DateTimeInputPanel();
        }
        if (cl.getName().equals("org.apache.axis.types.NonNegativeInteger")) {
            return new NonNegativeIntegerInputPanel();
        }
        if (cl.getName().startsWith("[L")) {
            try {
                return new ArrayInputPanel(Class.forName(cl.getName().substring(2, cl.getName().length() - 1)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        System.out.println("Unrecognized type: " + cl.getName());
        return NullInputPanel.getInstance();
    }
}

