/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.export;

import fedora.client.Administrator;
import fedora.common.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ExportOptionsDialog
extends JDialog
implements Constants {
    private static final long serialVersionUID = 1L;
    private JRadioButton foxml11Button;
    private JRadioButton foxml10Button;
    private JRadioButton mets11Button;
    private JRadioButton mets10Button;
    private JRadioButton atomButton;
    private JRadioButton atomZipButton;
    private final ButtonGroup fmt_buttonGroup = new ButtonGroup();
    protected String fmt_chosen;
    private JRadioButton publicButton;
    private JRadioButton migrateButton;
    private JRadioButton archiveButton;
    private final ButtonGroup ctx_buttonGroup = new ButtonGroup();
    protected String ctx_chosen;

    public ExportOptionsDialog(String title) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), title, true);
        this.setSize(350, 450);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ExportOptionsDialog.this.fmt_chosen = null;
                ExportOptionsDialog.this.ctx_chosen = null;
                ExportOptionsDialog.this.dispose();
            }
        });
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridLayout(2, 1));
        optionsPanel.add(this.setFormatPanel());
        optionsPanel.add(this.setContextPanel());
        JButton okButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ExportOptionsDialog.this.dispose();
            }
        });
        okButton.setText("OK");
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ExportOptionsDialog.this.fmt_chosen = null;
                ExportOptionsDialog.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        JButton helpButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ExportOptionsDialog.this.showHelp();
            }
        });
        helpButton.setText("Help");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(helpButton);
        buttonPanel.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)optionsPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    private JPanel setFormatPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setLayout(new GridLayout(0, 1));
        formatPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        String text = "Select the desired export FORMAT";
        JLabel label = new JLabel(text);
        formatPanel.add(label);
        this.foxml11Button = new JRadioButton("FOXML (Fedora Object XML) version 1.1", true);
        this.foxml11Button.setActionCommand(ExportOptionsDialog.FOXML1_1.uri);
        this.foxml11Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.foxml11Button.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.FOXML1_1.uri;
                }
            }
        });
        formatPanel.add(this.foxml11Button);
        this.foxml10Button = new JRadioButton("FOXML (Fedora Object XML) version 1.0", true);
        this.foxml10Button.setActionCommand(ExportOptionsDialog.FOXML1_0.uri);
        this.foxml10Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.foxml10Button.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.FOXML1_0.uri;
                }
            }
        });
        formatPanel.add(this.foxml10Button);
        this.mets11Button = new JRadioButton("METS (Fedora METS Extension) version 1.1", false);
        this.mets11Button.setActionCommand(ExportOptionsDialog.METS_EXT1_1.uri);
        this.mets11Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.mets11Button.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.METS_EXT1_1.uri;
                }
            }
        });
        formatPanel.add(this.mets11Button);
        this.mets10Button = new JRadioButton("METS (Fedora METS Extension) version 1.0", false);
        this.mets10Button.setActionCommand(ExportOptionsDialog.METS_EXT1_0.uri);
        this.mets10Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.mets10Button.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.METS_EXT1_0.uri;
                }
            }
        });
        formatPanel.add(this.mets10Button);
        this.atomButton = new JRadioButton("ATOM (Fedora Atom)", false);
        this.atomButton.setActionCommand(ExportOptionsDialog.ATOM1_1.uri);
        this.atomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.atomButton.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.ATOM1_1.uri;
                }
            }
        });
        formatPanel.add(this.atomButton);
        this.atomZipButton = new JRadioButton("ATOM Zip", false);
        this.atomZipButton.setActionCommand(ExportOptionsDialog.ATOM_ZIP1_1.uri);
        this.atomZipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.atomZipButton.isSelected()) {
                    ExportOptionsDialog.this.fmt_chosen = Constants.ATOM_ZIP1_1.uri;
                }
            }
        });
        formatPanel.add(this.atomZipButton);
        this.fmt_buttonGroup.add(this.foxml11Button);
        this.fmt_buttonGroup.add(this.foxml10Button);
        this.fmt_buttonGroup.add(this.mets11Button);
        this.fmt_buttonGroup.add(this.mets10Button);
        this.fmt_buttonGroup.add(this.atomButton);
        this.fmt_buttonGroup.add(this.atomZipButton);
        this.fmt_chosen = ExportOptionsDialog.FOXML1_1.uri;
        return formatPanel;
    }

    private JPanel setContextPanel() {
        JPanel contextPanel = new JPanel();
        contextPanel.setLayout(new GridLayout(0, 1));
        contextPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        String text = "Select the desired export CONTEXT";
        JLabel label = new JLabel(text);
        contextPanel.add(label);
        this.migrateButton = new JRadioButton("Migrate", true);
        this.migrateButton.setActionCommand("migrate");
        this.migrateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.migrateButton.isSelected()) {
                    ExportOptionsDialog.this.ctx_chosen = "migrate";
                }
            }
        });
        contextPanel.add(this.migrateButton);
        this.publicButton = new JRadioButton("Public Access", false);
        this.publicButton.setActionCommand("public");
        this.publicButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.publicButton.isSelected()) {
                    ExportOptionsDialog.this.ctx_chosen = "public";
                }
            }
        });
        contextPanel.add(this.publicButton);
        this.archiveButton = new JRadioButton("Archive", false);
        this.archiveButton.setActionCommand("archive");
        this.archiveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExportOptionsDialog.this.archiveButton.isSelected()) {
                    ExportOptionsDialog.this.ctx_chosen = "archive";
                }
            }
        });
        contextPanel.add(this.archiveButton);
        this.ctx_buttonGroup.add(this.migrateButton);
        this.ctx_buttonGroup.add(this.publicButton);
        this.ctx_buttonGroup.add(this.archiveButton);
        this.ctx_chosen = "migrate";
        return contextPanel;
    }

    public String getFormatSelection() {
        return this.fmt_chosen;
    }

    public String getContextSelection() {
        return this.ctx_chosen;
    }

    private void showHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 500, 50);
        helptxt.append("There are two sections to the Export option dialog that must be completed:\n\n (1) Select the export FORMAT:\n\n     FOXML 1.1 - select this option if you want the export file\n             to be encoded according to the FOXML 1.1 XML schema.\n\n     FOXML 1.0 - select this option if you want the export file\n             to be encoded according to the FOXML 1.0 XML schema.\n\n     METS 1.1 - select this option if you want the export file\n             to be encoded according to version 1.1 of the Fedora\n\t\t        extension of the METS XML schema.\n\n     METS 1.0 - select this option if you want the export file\n             to be encoded according to version 1.0 of the Fedora\n             extension of the METS XML schema.\n\n     ATOM  - select this option if you want the export file\n             to be encoded according to the ATOM XML schema.\n\n     ATOM ZIP - select this option if you want the export file\n             to be encoded according to the ATOM ZIP XML schema.\n\n *************************************************************************\n (2) Select the export CONTEXT:\n\n     Migrate - (Default) select this option if you want the export file\n               to be appropriate for migration of an object from one\n               Fedora repository to another.  Any URLs that reference\n               the host:port of export repository will be specially encoded\n               so that the URLs will recognized by Fedora as relative\n               to whatever repository the object is subsequently stored.\n               When the export file is ingested into a new Fedora repository\n               the Fedora ingest process will ensure that the URLs\n               become local to the *new* repository.\n\n    Public Access - select this option if you want the export file\n               to be appropriate for use outside the context of a Fedora\n               repository.  All URLs that reference datastream content or\n               disseminations from the Fedora repository will be public\n               callback URLs to the exporting repository.\n\n    Archive - (Future Release) select this option if you want the export file\n               to serve as a self-contained archive of the object, where\n               all datastream content is directly in the export file.\n               Binary content will be base64-encoded and XML content inlined.\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Export Options", 0);
    }
}

