/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.messaging;

import fedora.client.messaging.MessagingClient;
import fedora.client.messaging.MessagingListener;
import fedora.server.errors.MessagingException;
import fedora.server.messaging.JMSManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.apache.log4j.Logger;

public class JmsMessagingClient
implements MessagingClient,
MessageListener {
    private String m_clientId;
    private MessagingListener m_listener;
    private Properties m_connectionProperties;
    private String m_messageSelector;
    private boolean m_durable;
    private JMSManager m_jmsManager;
    private Logger LOG = Logger.getLogger((String)JmsMessagingClient.class.getName());

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties) throws MessagingException {
        this(clientId, listener, connectionProperties, "", false);
    }

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties, boolean durable) throws MessagingException {
        this(clientId, listener, connectionProperties, "", durable);
    }

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties, String messageSelector, boolean durable) throws MessagingException {
        if (listener == null) {
            throw new MessagingException("MessageListener may not be null");
        }
        if (connectionProperties == null) {
            throw new MessagingException("Connection properties may not be null");
        }
        String initialContextFactory = connectionProperties.getProperty("java.naming.factory.initial");
        String providerUrl = connectionProperties.getProperty("java.naming.provider.url");
        String connectionFactoryName = connectionProperties.getProperty("connection.factory.name");
        if (initialContextFactory == null || providerUrl == null || connectionFactoryName == null) {
            throw new MessagingException("Propery values for 'java.naming.factory.initial', 'java.naming.provider.url', and'connection.factory.name' must be provided in order to initialize a messaging client");
        }
        if (durable && (clientId == null || clientId.equals(""))) {
            throw new MessagingException("ClientId must be specified for durable subscriptions");
        }
        this.m_clientId = clientId;
        this.m_listener = listener;
        this.m_connectionProperties = connectionProperties;
        this.m_messageSelector = messageSelector;
        this.m_durable = durable;
    }

    public void start() throws MessagingException {
        try {
            this.m_jmsManager = new JMSManager(this.m_connectionProperties, this.m_clientId);
            Enumeration<Object> propertyNames = this.m_connectionProperties.keys();
            while (propertyNames.hasMoreElements()) {
                String destinationName;
                String propertyName = (String)propertyNames.nextElement();
                if (propertyName.startsWith("topic.")) {
                    destinationName = this.m_connectionProperties.getProperty(propertyName);
                    this.m_jmsManager.createDestination(destinationName, JMSManager.DestinationType.Topic);
                    continue;
                }
                if (!propertyName.startsWith("queue.")) continue;
                destinationName = this.m_connectionProperties.getProperty(propertyName);
                this.m_jmsManager.createDestination(destinationName, JMSManager.DestinationType.Queue);
            }
            List<Destination> destinations = this.m_jmsManager.getDestinations();
            if (destinations.size() == 0) {
                throw new MessagingException("No destinations available for subscription, make sure that there is at least one topic or queue specified in the connection properties.");
            }
            for (Destination destination : destinations) {
                if (this.m_durable && destination instanceof Topic) {
                    this.m_jmsManager.listenDurable((Topic)destination, this.m_messageSelector, this, null);
                    continue;
                }
                this.m_jmsManager.listen(destination, this.m_messageSelector, (MessageListener)this);
            }
        }
        catch (MessagingException me) {
            this.LOG.error((Object)("MessagingException encountered attempting to start Messaging Client: " + this.m_clientId + ". Exception message: " + me.getMessage()), (Throwable)me);
            throw me;
        }
    }

    public void stop(boolean unsubscribe) throws MessagingException {
        try {
            if (unsubscribe) {
                this.m_jmsManager.unsubscribeAllDurable();
            }
            this.m_jmsManager.close();
        }
        catch (MessagingException me) {
            this.LOG.error((Object)("Messaging Exception encountered attempting to stop Messaging Client: " + this.m_clientId + ". Exception message: " + me.getMessage()), (Throwable)me);
            throw me;
        }
    }

    public void onMessage(Message message) {
        this.m_listener.onMessage(this.m_clientId, message);
    }
}

