/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.ContentHandlerFactory;
import fedora.client.objecteditor.ContentViewer;
import fedora.client.objecteditor.DatastreamPane;
import fedora.client.objecteditor.ImportDialog;
import fedora.client.objecteditor.NewRelsExtDatastreamPane;
import fedora.client.objecteditor.ObjectEditorFrame;
import fedora.client.objecteditor.PotentiallyDirty;
import fedora.client.objecteditor.TabDrawer;
import fedora.client.objecteditor.TextContentEditor;
import fedora.server.types.gen.Datastream;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DatastreamsPane
extends JPanel
implements PotentiallyDirty,
TabDrawer {
    private static final Logger LOG = Logger.getLogger((String)DatastreamsPane.class.getName());
    private static final long serialVersionUID = 1L;
    private final String m_pid;
    private final JTabbedPane m_tabbedPane;
    private DatastreamPane[] m_datastreamPanes;
    private final ObjectEditorFrame m_owner;
    private final ArrayList m_dsListeners;
    private final Map m_currentVersionMap;
    public String[] ALL_KNOWN_MIMETYPES = new String[]{"text/xml", "text/plain", "text/html", "text/html+xml", "text/svg+xml", "text/rtf", "image/jpeg", "image/jp2", "image/gif", "image/bmp", "image/png", "image/tiff", "audio/mpeg", "audio/x-aiff", "audio/x-wav", "audio/x-pn-realaudio", "video/mpeg", "video/quicktime", "application/postscript", "application/pdf", "application/rdf+xml", "application/ms-word", "application/ms-excel", "application/ms-powerpoint", "application/smil", "application/octet-stream", "application/x-tar", "application/zip", "application/x-gtar", "application/x-gzip", "application/xml", "application/xhtml+xml", "application/xslt+xml", "application/xml-dtd"};
    public String[] XML_MIMETYPE = new String[]{"text/xml"};
    static ImageIcon newIcon = new ImageIcon(Administrator.cl.getResource("images/standard/general/New16.gif"));

    public DatastreamsPane(ObjectEditorFrame owner, String pid) throws Exception {
        this.m_pid = pid;
        this.m_owner = owner;
        this.m_currentVersionMap = new HashMap();
        this.m_dsListeners = new ArrayList();
        this.m_tabbedPane = new JTabbedPane(2);
        Datastream[] currentVersions = Administrator.APIM.getDatastreams(pid, null, null);
        this.m_datastreamPanes = new DatastreamPane[currentVersions.length];
        for (int i = 0; i < currentVersions.length; ++i) {
            this.m_currentVersionMap.put(currentVersions[i].getID(), currentVersions[i]);
            this.m_datastreamPanes[i] = new DatastreamPane(owner, pid, Administrator.APIM.getDatastreamHistory(pid, currentVersions[i].getID()), this);
            StringBuffer tabLabel = new StringBuffer();
            tabLabel.append(currentVersions[i].getID());
            this.m_tabbedPane.add(tabLabel.toString(), this.m_datastreamPanes[i]);
            this.m_tabbedPane.setToolTipTextAt(i, currentVersions[i].getMIMEType() + " - " + currentVersions[i].getLabel() + " (" + currentVersions[i].getControlGroup().toString() + ")");
            this.colorTabForState(currentVersions[i].getID(), currentVersions[i].getState());
        }
        this.m_tabbedPane.add("New...", new JPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabbedPane, "Center");
        this.doNew(this.XML_MIMETYPE, false);
        this.updateNewRelsExt(this.m_pid);
    }

    private boolean hasRelsExt() {
        return this.m_currentVersionMap.get("RELS-EXT") != null;
    }

    public Map getCurrentVersionMap() {
        return this.m_currentVersionMap;
    }

    public void colorTabForState(String id, String s) {
        int i = this.getTabIndex(id);
        if (s.equals("I")) {
            this.m_tabbedPane.setBackgroundAt(i, Administrator.INACTIVE_COLOR);
        } else if (s.equals("D")) {
            this.m_tabbedPane.setBackgroundAt(i, Administrator.DELETED_COLOR);
        } else {
            this.m_tabbedPane.setBackgroundAt(i, Administrator.ACTIVE_COLOR);
        }
    }

    public void doNew(String[] dropdownMimeTypes, boolean makeSelected) {
        int i = this.getTabIndex("New...");
        this.m_tabbedPane.setComponentAt(i, new NewDatastreamPane(dropdownMimeTypes));
        i = this.getTabIndex("New...");
        this.m_tabbedPane.setToolTipTextAt(i, "Add a new datastream to this object");
        this.m_tabbedPane.setIconAt(i, newIcon);
        this.m_tabbedPane.setBackgroundAt(i, Administrator.DEFAULT_COLOR);
        if (makeSelected) {
            this.m_tabbedPane.setSelectedIndex(i);
        }
    }

    public void updateNewRelsExt(String pid) throws Exception {
        if (!this.hasRelsExt() && this.getTabIndex("New RELS-EXT...") == -1) {
            this.m_tabbedPane.insertTab("New RELS-EXT...", newIcon, new NewRelsExtDatastreamPane(this.m_owner, pid, this), "Add a RELS-EXT datastream to this object", this.getTabIndex("New..."));
            int i = this.getTabIndex("New RELS-EXT...");
            this.m_tabbedPane.setBackgroundAt(i, Administrator.DEFAULT_COLOR);
        } else if (this.hasRelsExt() && this.getTabIndex("New RELS-EXT...") != -1) {
            this.m_tabbedPane.remove(this.getTabIndex("New RELS-EXT..."));
        }
    }

    private int getTabIndex(String id) {
        int i = this.m_tabbedPane.indexOfTab(id);
        if (i != -1) {
            return i;
        }
        return this.m_tabbedPane.indexOfTab(id + "*");
    }

    private int getDatastreamPaneIndex(String id) {
        int index = -1;
        for (int i = 0; i < this.m_datastreamPanes.length; ++i) {
            if (!this.m_datastreamPanes[i].getItemId().equals(id)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void setDirty(String id, boolean isDirty) {
        int i = this.getTabIndex(id);
        if (isDirty) {
            this.m_tabbedPane.setTitleAt(i, id + "*");
        } else {
            this.m_tabbedPane.setTitleAt(i, id);
        }
    }

    protected void refresh(String dsID) {
        int i = this.getTabIndex(dsID);
        try {
            DatastreamPane replacement;
            Datastream[] versions = Administrator.APIM.getDatastreamHistory(this.m_pid, dsID);
            this.m_currentVersionMap.put(dsID, versions[0]);
            LOG.debug((Object)("New create date is: " + versions[0].getCreateDate()));
            this.m_datastreamPanes[i] = replacement = new DatastreamPane(this.m_owner, this.m_pid, versions, this);
            this.m_tabbedPane.setComponentAt(i, replacement);
            this.m_tabbedPane.setToolTipTextAt(i, versions[0].getMIMEType() + " - " + versions[0].getLabel() + " (" + versions[0].getControlGroup().toString() + ")");
            this.colorTabForState(dsID, versions[0].getState());
            this.setDirty(dsID, false);
        }
        catch (Exception e) {
            Administrator.showErrorDialog(Administrator.getDesktop(), "Error while refreshing", e.getMessage() + "\nTry re-opening the object viewer.", e);
        }
    }

    protected void addDatastreamTab(String dsID, boolean reInitNewPanel) throws Exception {
        DatastreamPane[] newArray = new DatastreamPane[this.m_datastreamPanes.length + 1];
        for (int i = 0; i < this.m_datastreamPanes.length; ++i) {
            newArray[i] = this.m_datastreamPanes[i];
        }
        Datastream[] versions = Administrator.APIM.getDatastreamHistory(this.m_pid, dsID);
        this.m_currentVersionMap.put(dsID, versions[0]);
        newArray[this.m_datastreamPanes.length] = new DatastreamPane(this.m_owner, this.m_pid, versions, this);
        this.m_datastreamPanes = newArray;
        int newIndex = this.getTabIndex("New...");
        this.m_tabbedPane.add((Component)this.m_datastreamPanes[this.m_datastreamPanes.length - 1], newIndex);
        this.m_tabbedPane.setTitleAt(newIndex, dsID);
        this.m_tabbedPane.setToolTipTextAt(newIndex, versions[0].getMIMEType() + " - " + versions[0].getLabel() + " (" + versions[0].getControlGroup().toString() + ")");
        this.colorTabForState(dsID, versions[0].getState());
        if (reInitNewPanel) {
            this.doNew(this.XML_MIMETYPE, false);
        }
        this.updateNewRelsExt(this.m_pid);
        this.m_tabbedPane.setSelectedIndex(this.getTabIndex(dsID));
    }

    protected void remove(String dsID) {
        int i = this.getTabIndex(dsID);
        this.m_tabbedPane.remove(i);
        this.m_currentVersionMap.remove(dsID);
        i = this.getDatastreamPaneIndex(dsID);
        DatastreamPane[] newArray = new DatastreamPane[this.m_datastreamPanes.length - 1];
        for (int x = 0; x < this.m_datastreamPanes.length; ++x) {
            if (x < i) {
                newArray[x] = this.m_datastreamPanes[x];
                continue;
            }
            if (x <= i) continue;
            newArray[x - 1] = this.m_datastreamPanes[x];
        }
        this.m_datastreamPanes = newArray;
        this.m_owner.indicateDirtiness();
        try {
            this.updateNewRelsExt(this.m_pid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isDirty() {
        for (DatastreamPane element : this.m_datastreamPanes) {
            if (!element.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void addRows(JComponent[] left, JComponent[] right, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 4, 4, 4);
        for (int i = 0; i < left.length; ++i) {
            c.anchor = 18;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(left[i], c);
            container.add(left[i]);
            c.gridwidth = 0;
            if (!(right[i] instanceof JComboBox)) {
                c.fill = 2;
            } else {
                c.anchor = 18;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(right[i], c);
            container.add(right[i]);
        }
    }

    public class NewDatastreamPane
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JTextField m_labelTextField;
        JTextField m_idTextField;
        JTextField m_formatURITextField;
        JTextField m_altIDsTextField;
        JTextField m_referenceTextField;
        JTextArea m_controlGroupTextArea;
        JComboBox m_mimeComboBox;
        CardLayout m_contentCard;
        JPanel m_specificPane;
        TextContentEditor m_xEditor = null;
        TextContentEditor m_mEditor = null;
        JPanel m_erPane;
        JButton m_erViewButton;
        ContentViewer m_erViewer;
        JPanel m_checksumPanel;
        JComboBox m_checksumTypeComboBox;
        JTextField m_checksumValue;
        String m_controlGroup;
        String m_lastSelectedMimeType;
        File m_managedFile;
        JComponent m_mCenter;
        JPanel m_mPane;
        static final String X_DESCRIPTION = "Metadata that is stored and managed inside the repository.  This must be well-formed XML and will be stripped of processing instructions and comments.Use of XML namespaces is optional and schema validity is not enforced by the repository.";
        static final String M_DESCRIPTION = "Arbitary content that is stored and managed inside the repository.  This is similar to internal XML metadata, but it does not have any format restrictions, and is delieved as-is from the repository.";
        static final String E_DESCRIPTION = "Content that is not managed by Fedora, and is ultimately hosted on some other server.  Each time the content is accessed, Fedora will request it from its host and send it to the client.";
        static final String R_DESCRIPTION = "Fedora will send clients a redirect to the URL you specify for this datastream.  This is useful in situations where the content must be delivered by a special streaming server, it contains relative hyperlinks, or there are licensing or access restrictions that prevent it from being proxied.";
        private final JComboBox m_stateComboBox;
        private final JComboBox m_versionableComboBox;
        private String m_initialState;
        private static final int NEW_VERSION_ON_UPDATE = 0;

        public NewDatastreamPane(String[] dropdownMimeTypes) {
            JComponent[] left = new JComponent[]{new JLabel("ID"), new JLabel("Control Group"), new JLabel("State"), new JLabel("Versionable"), new JLabel("MIME Type"), new JLabel("Label"), new JLabel("Format URI"), new JLabel("Alternate IDs"), new JLabel("Checksum")};
            this.m_stateComboBox = new JComboBox<String>(new String[]{"Active", "Inactive", "Deleted"});
            this.m_initialState = "A";
            this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
            Administrator.constrainHeight(this.m_stateComboBox);
            this.m_stateComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NewDatastreamPane.this.m_initialState = ((String)NewDatastreamPane.this.m_stateComboBox.getSelectedItem()).substring(0, 1);
                    if (NewDatastreamPane.this.m_initialState.equals("A")) {
                        NewDatastreamPane.this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
                    } else if (NewDatastreamPane.this.m_initialState.equals("I")) {
                        NewDatastreamPane.this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
                    } else if (NewDatastreamPane.this.m_initialState.equals("D")) {
                        NewDatastreamPane.this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
                    }
                }
            });
            String[] comboBoxStrings2 = new String[]{"Updates will create new version", "Updates will replace most recent version"};
            this.m_versionableComboBox = new JComboBox<String>(comboBoxStrings2);
            Administrator.constrainHeight(this.m_versionableComboBox);
            this.m_versionableComboBox.setSelectedIndex(0);
            this.m_labelTextField = new JTextField("Enter a label here.");
            this.m_idTextField = new JTextField("");
            this.m_formatURITextField = new JTextField("");
            this.m_altIDsTextField = new JTextField("");
            this.m_mimeComboBox = new JComboBox<String>(dropdownMimeTypes);
            Administrator.constrainHeight(this.m_mimeComboBox);
            this.m_mimeComboBox.setEditable(true);
            JPanel controlGroupPanel = new JPanel();
            JRadioButton xButton = new JRadioButton("Internal XML Metadata");
            xButton.setSelected(true);
            this.m_controlGroup = "X";
            xButton.setActionCommand("X");
            xButton.addActionListener(this);
            JRadioButton mButton = new JRadioButton("Managed Content");
            mButton.setActionCommand("M");
            mButton.addActionListener(this);
            JRadioButton eButton = new JRadioButton("External Referenced Content");
            eButton.setActionCommand("E");
            eButton.addActionListener(this);
            JRadioButton rButton = new JRadioButton("Redirect");
            rButton.setActionCommand("R");
            rButton.addActionListener(this);
            ButtonGroup group = new ButtonGroup();
            group.add(xButton);
            group.add(mButton);
            group.add(eButton);
            group.add(rButton);
            controlGroupPanel.setLayout(new GridLayout(0, 1));
            controlGroupPanel.add(xButton);
            controlGroupPanel.add(mButton);
            controlGroupPanel.add(eButton);
            controlGroupPanel.add(rButton);
            JPanel controlGroupOuterPanel = new JPanel(new BorderLayout());
            controlGroupOuterPanel.add((Component)controlGroupPanel, "West");
            this.m_controlGroupTextArea = new JTextArea(X_DESCRIPTION);
            this.m_controlGroupTextArea.setLineWrap(true);
            this.m_controlGroupTextArea.setEditable(false);
            this.m_controlGroupTextArea.setWrapStyleWord(true);
            this.m_controlGroupTextArea.setBackground(controlGroupOuterPanel.getBackground());
            controlGroupOuterPanel.add((Component)this.m_controlGroupTextArea, "Center");
            this.m_checksumPanel = new JPanel();
            this.m_checksumPanel.setLayout(new BorderLayout());
            this.m_checksumTypeComboBox = new JComboBox<String>(new String[]{"Default", "DISABLED", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"});
            this.m_checksumValue = null;
            this.m_checksumPanel.add((Component)this.m_checksumTypeComboBox, "West");
            this.m_checksumTypeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String csType = NewDatastreamPane.this.m_checksumTypeComboBox.getSelectedItem().toString();
                    if (csType.equals("Default") || csType.equals("DISABLED")) {
                        if (NewDatastreamPane.this.m_checksumValue != null) {
                            NewDatastreamPane.this.m_checksumPanel.remove(NewDatastreamPane.this.m_checksumValue);
                            NewDatastreamPane.this.m_checksumValue = null;
                            NewDatastreamPane.this.m_checksumPanel.validate();
                            NewDatastreamPane.this.m_checksumPanel.repaint();
                        }
                    } else {
                        if (NewDatastreamPane.this.m_checksumValue != null) {
                            NewDatastreamPane.this.m_checksumPanel.remove(NewDatastreamPane.this.m_checksumValue);
                        }
                        NewDatastreamPane.this.m_checksumValue = new JTextField("");
                        NewDatastreamPane.this.m_checksumPanel.add((Component)NewDatastreamPane.this.m_checksumValue, "Center");
                        NewDatastreamPane.this.m_checksumPanel.validate();
                    }
                }
            });
            JComponent[] right = new JComponent[]{this.m_idTextField, controlGroupOuterPanel, this.m_stateComboBox, this.m_versionableComboBox, this.m_mimeComboBox, this.m_labelTextField, this.m_formatURITextField, this.m_altIDsTextField, this.m_checksumPanel};
            JPanel commonPane = new JPanel();
            GridBagLayout grid = new GridBagLayout();
            commonPane.setLayout(grid);
            DatastreamsPane.this.addRows(left, right, grid, commonPane);
            this.m_lastSelectedMimeType = (String)this.m_mimeComboBox.getSelectedItem();
            this.m_mimeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String cur = (String)NewDatastreamPane.this.m_mimeComboBox.getSelectedItem();
                    if (!cur.equals(NewDatastreamPane.this.m_lastSelectedMimeType)) {
                        NewDatastreamPane.this.m_xEditor.setXML(cur.endsWith("+xml") || cur.endsWith("/xml"));
                        if (NewDatastreamPane.this.m_erViewer != null) {
                            NewDatastreamPane.this.m_erPane.remove(NewDatastreamPane.this.m_erViewer.getComponent());
                            NewDatastreamPane.this.m_erPane.add((Component)new JLabel(), "Center");
                            NewDatastreamPane.this.m_erPane.validate();
                        }
                        if (ContentHandlerFactory.hasViewer(cur)) {
                            NewDatastreamPane.this.m_erViewButton.setEnabled(true);
                        } else {
                            NewDatastreamPane.this.m_erViewButton.setEnabled(false);
                        }
                        NewDatastreamPane.this.m_lastSelectedMimeType = cur;
                    }
                }
            });
            try {
                this.m_xEditor = new TextContentEditor();
                this.m_xEditor.init("text/plain", new ByteArrayInputStream(new String("Enter content here, or click \"Import\" below.").getBytes("UTF-8")), false);
                this.m_xEditor.setXML(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            JPanel xBottomPane = new JPanel();
            xBottomPane.setLayout(new FlowLayout());
            JButton xImportButton = new JButton("Import...");
            Administrator.constrainHeight(xImportButton);
            xImportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ImportDialog imp = new ImportDialog();
                    if (imp.file != null) {
                        try {
                            NewDatastreamPane.this.m_xEditor.setContent(new FileInputStream(imp.file));
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            if (msg.indexOf("Error parsing as XML") != -1) {
                                msg = "Imported text does not contain valid XML.\nInline XML Metadata datastreams must contain valid XML.";
                            }
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Import Error", msg, e);
                        }
                    }
                }
            });
            xBottomPane.add(xImportButton);
            JPanel xPane = new JPanel();
            xPane.setLayout(new BorderLayout());
            xPane.add((Component)this.m_xEditor.getComponent(), "Center");
            xPane.add((Component)xBottomPane, "South");
            JPanel mBottomPane = new JPanel(new FlowLayout());
            JButton mImportButton = new JButton("Import...");
            Administrator.constrainHeight(mImportButton);
            mImportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ImportDialog imp = new ImportDialog();
                    if (imp.file != null) {
                        try {
                            JComponent newCenter;
                            String curMime = (String)NewDatastreamPane.this.m_mimeComboBox.getSelectedItem();
                            if (ContentHandlerFactory.hasViewer(curMime)) {
                                ContentViewer viewer = ContentHandlerFactory.getViewer(curMime, new FileInputStream(imp.file));
                                newCenter = viewer.getComponent();
                            } else {
                                String importString = imp.url != null ? "Will import " + imp.url : "Will import " + imp.file.getPath();
                                newCenter = new JLabel(importString);
                            }
                            if (NewDatastreamPane.this.m_mCenter != null) {
                                NewDatastreamPane.this.m_mPane.remove(NewDatastreamPane.this.m_mCenter);
                            }
                            NewDatastreamPane.this.m_mCenter = newCenter;
                            NewDatastreamPane.this.m_mPane.add((Component)NewDatastreamPane.this.m_mCenter, "Center");
                            NewDatastreamPane.this.m_mPane.validate();
                            NewDatastreamPane.this.m_managedFile = imp.file;
                        }
                        catch (Exception e) {
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Import Error", e.getMessage(), e);
                        }
                    }
                }
            });
            mBottomPane.add(mImportButton);
            this.m_mPane = new JPanel(new BorderLayout());
            this.m_mPane.add((Component)mBottomPane, "South");
            JPanel erTopPane = new JPanel(new BorderLayout());
            erTopPane.add((Component)new JLabel("Location  "), "West");
            this.m_referenceTextField = new JTextField("http://");
            erTopPane.add((Component)this.m_referenceTextField, "Center");
            JPanel erBottomPane = new JPanel(new FlowLayout());
            this.m_erViewButton = new JButton("View");
            Administrator.constrainHeight(this.m_erViewButton);
            this.m_erViewButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        String mimeType = (String)NewDatastreamPane.this.m_mimeComboBox.getSelectedItem();
                        NewDatastreamPane.this.m_erViewer = ContentHandlerFactory.getViewer(mimeType, Administrator.DOWNLOADER.get(NewDatastreamPane.this.m_referenceTextField.getText()));
                        NewDatastreamPane.this.m_erPane.add((Component)NewDatastreamPane.this.m_erViewer.getComponent(), "Center");
                        NewDatastreamPane.this.m_erPane.validate();
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "View error", e.getMessage(), e);
                    }
                }
            });
            erBottomPane.add(this.m_erViewButton);
            this.m_erPane = new JPanel(new BorderLayout());
            this.m_erPane.add((Component)erTopPane, "North");
            this.m_erPane.add((Component)erBottomPane, "South");
            this.m_specificPane = new JPanel();
            this.m_contentCard = new CardLayout();
            this.m_specificPane.setLayout(this.m_contentCard);
            this.m_specificPane.add((Component)xPane, "X");
            this.m_specificPane.add((Component)this.m_mPane, "M");
            this.m_specificPane.add((Component)this.m_erPane, "ER");
            JPanel entryPane = new JPanel();
            entryPane.setLayout(new BorderLayout());
            entryPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            entryPane.add((Component)commonPane, "North");
            entryPane.add((Component)this.m_specificPane, "Center");
            JButton saveButton = new JButton("Save Datastream");
            Administrator.constrainHeight(saveButton);
            saveButton.setActionCommand("Save");
            saveButton.addActionListener(this);
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new FlowLayout());
            buttonPane.add(saveButton);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.add((Component)entryPane, "Center");
            this.add((Component)buttonPane, "South");
        }

        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (cmd.equals("X")) {
                this.m_controlGroupTextArea.setText(X_DESCRIPTION);
                this.m_contentCard.show(this.m_specificPane, "X");
                this.m_controlGroup = "X";
                this.removeMIMETypeItems();
            } else if (cmd.equals("M")) {
                this.m_controlGroupTextArea.setText(M_DESCRIPTION);
                this.m_contentCard.show(this.m_specificPane, "M");
                this.m_controlGroup = "M";
                if (this.m_mimeComboBox.getItemCount() == 1) {
                    this.addMIMETypeItems();
                }
            } else if (cmd.equals("E")) {
                this.m_controlGroupTextArea.setText(E_DESCRIPTION);
                this.m_contentCard.show(this.m_specificPane, "ER");
                this.m_controlGroup = "E";
                if (this.m_mimeComboBox.getItemCount() == 1) {
                    this.addMIMETypeItems();
                }
            } else if (cmd.equals("R")) {
                this.m_controlGroupTextArea.setText(R_DESCRIPTION);
                this.m_contentCard.show(this.m_specificPane, "ER");
                this.m_controlGroup = "R";
                if (this.m_mimeComboBox.getItemCount() == 1) {
                    this.addMIMETypeItems();
                }
            } else if (cmd.equals("Save")) {
                try {
                    String trimmed;
                    String pid = DatastreamsPane.this.m_pid;
                    String dsID = this.m_idTextField.getText().trim();
                    if (dsID.equals("")) {
                        dsID = null;
                    }
                    String[] altIDs = (trimmed = this.m_altIDsTextField.getText().trim()).length() == 0 ? new String[]{} : (trimmed.indexOf(" ") == -1 ? new String[]{trimmed} : trimmed.split("\\s"));
                    String formatURI = this.m_formatURITextField.getText().trim();
                    if (formatURI.length() == 0) {
                        formatURI = null;
                    }
                    String label = this.m_labelTextField.getText();
                    String mimeType = (String)this.m_mimeComboBox.getSelectedItem();
                    String location = null;
                    if (this.m_controlGroup.equals("X")) {
                        location = Administrator.UPLOADER.upload(this.m_xEditor.getContent());
                    } else if (this.m_controlGroup.equals("M")) {
                        if (this.m_managedFile == null) {
                            throw new IOException("Content must be specified first.");
                        }
                        location = Administrator.UPLOADER.upload(this.m_managedFile);
                    } else {
                        location = this.m_referenceTextField.getText();
                    }
                    String csType = this.m_checksumTypeComboBox.getSelectedItem().toString();
                    String checksum = null;
                    if (csType.equals("Default")) {
                        csType = null;
                    } else {
                        checksum = csType.equals("DISABLED") ? null : (this.m_checksumValue.getText().length() == 0 ? null : (this.m_checksumValue.getText().equalsIgnoreCase("none") ? null : this.m_checksumValue.getText()));
                    }
                    boolean versionable = this.m_versionableComboBox.getSelectedIndex() == 0;
                    String newID = Administrator.APIM.addDatastream(pid, dsID, altIDs, label, versionable, mimeType, formatURI, location, this.m_controlGroup, this.m_initialState, csType, checksum, "DatastreamsPane generated this logMessage.");
                    DatastreamsPane.this.addDatastreamTab(newID, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String msg = e.getMessage();
                    if (msg.indexOf("Content is not allowed in prolog") != -1) {
                        msg = "Text entered is not valid XML.\nInternal XML Metadata datastreams must contain valid XML.";
                    }
                    Administrator.showErrorDialog(Administrator.getDesktop(), "Error saving new datastream", msg, e);
                }
            }
        }

        public void addMIMETypeItems() {
            for (int i = 1; i < DatastreamsPane.this.ALL_KNOWN_MIMETYPES.length; ++i) {
                this.m_mimeComboBox.addItem(DatastreamsPane.this.ALL_KNOWN_MIMETYPES[i]);
            }
            this.m_mimeComboBox.setPreferredSize(new Dimension(150, 20));
        }

        public void removeMIMETypeItems() {
            for (int i = 1; i < DatastreamsPane.this.ALL_KNOWN_MIMETYPES.length; ++i) {
                this.m_mimeComboBox.removeItem(DatastreamsPane.this.ALL_KNOWN_MIMETYPES[i]);
            }
            this.m_mimeComboBox.setPreferredSize(new Dimension(150, 20));
        }
    }
}

