/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public File file = null;
    public String url = null;
    private final JTextField m_fileField;
    private final JTextField m_urlField;
    private final JRadioButton m_fileButton;
    private final JRadioButton m_urlButton;

    public ImportDialog() {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Import Content", true);
        ImportAction importAction = new ImportAction();
        JButton importButton = new JButton(importAction);
        Administrator.constrainHeight(importButton);
        this.m_fileButton = new JRadioButton("From file");
        this.m_urlButton = new JRadioButton("From URL");
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_fileButton);
        group.add(this.m_urlButton);
        this.m_fileButton.setSelected(true);
        this.m_fileField = new JTextField(20);
        JButton browseButton = new JButton("Browse...");
        Administrator.constrainHeight(browseButton);
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFileChooser browse = Administrator.getLastDir() == null ? new JFileChooser() : new JFileChooser(Administrator.getLastDir());
                browse.setApproveButtonText("Import");
                browse.setApproveButtonMnemonic('I');
                browse.setApproveButtonToolTipText("Imports the selected file.");
                browse.setDialogTitle("Import New Datastream Content...");
                int returnVal = browse.showOpenDialog(Administrator.getDesktop());
                if (returnVal == 0) {
                    ImportDialog.this.m_fileField.setText(browse.getSelectedFile().getPath());
                }
            }
        });
        JPanel fileValuePanel = new JPanel();
        fileValuePanel.setLayout(new FlowLayout());
        fileValuePanel.add(this.m_fileField);
        fileValuePanel.add(browseButton);
        this.m_urlField = new JTextField(20);
        JPanel inputPane = new JPanel();
        inputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        GridBagLayout gridBag = new GridBagLayout();
        inputPane.setLayout(gridBag);
        this.addRows(new JComponent[]{this.m_fileButton, this.m_urlButton}, new JComponent[]{fileValuePanel, this.m_urlField}, gridBag, inputPane);
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ImportDialog.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        Administrator.constrainHeight(cancelButton);
        JPanel buttonPane = new JPanel();
        buttonPane.add(importButton);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)inputPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public void addRows(JComponent[] left, JComponent[] right, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 4, 4, 4);
        for (int i = 0; i < left.length; ++i) {
            c.anchor = 17;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(left[i], c);
            container.add(left[i]);
            c.gridwidth = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            gridBag.setConstraints(right[i], c);
            container.add(right[i]);
        }
    }

    public class ImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ImportAction() {
            super("Import");
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                if (ImportDialog.this.m_fileButton.isSelected()) {
                    if (ImportDialog.this.m_fileField.getText().equals("")) {
                        throw new IOException("No filename entered.");
                    }
                    File f = new File(ImportDialog.this.m_fileField.getText());
                    if (!f.exists()) {
                        throw new IOException("File does not exist.");
                    }
                    ImportDialog.this.file = f;
                } else {
                    if (ImportDialog.this.m_urlField.getText().equals("")) {
                        throw new IOException("No URL entered.");
                    }
                    File f = File.createTempFile("fedora-ingest-", null);
                    f.deleteOnExit();
                    try {
                        Administrator.DOWNLOADER.get(ImportDialog.this.m_urlField.getText(), new FileOutputStream(f));
                    }
                    catch (Exception e) {
                        throw new IOException("Download failed: " + ImportDialog.this.m_urlField.getText());
                    }
                    ImportDialog.this.url = ImportDialog.this.m_urlField.getText();
                    ImportDialog.this.file = f;
                }
                ImportDialog.this.dispose();
            }
            catch (Exception e) {
                Administrator.showErrorDialog(Administrator.getDesktop(), "Import Error", e.getMessage(), e);
            }
        }
    }
}

