/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.DatastreamPane;
import fedora.client.objecteditor.DatastreamsPane;
import fedora.client.objecteditor.ObjectEditorFrame;
import fedora.common.Constants;
import fedora.server.types.gen.Datastream;
import fedora.server.types.gen.DatastreamControlGroup;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

class NewRelsExtDatastreamPane
extends DatastreamPane {
    private static final long serialVersionUID = 1L;
    protected static String s_dsid = "RELS-EXT";

    public NewRelsExtDatastreamPane(ObjectEditorFrame gramps, String pid, DatastreamsPane owner) throws Exception {
        super(gramps, pid, NewRelsExtDatastreamPane.MakeBlankRelsExtDatastream(), owner);
        this.m_undoButton.setVisible(false);
        this.m_saveButton.setEnabled(true);
        this.m_saveButton.setText("Save Datastream");
        this.m_saveButton.setPreferredSize(null);
        Administrator.constrainHeight(this.m_saveButton);
        this.m_currentVersionPane.m_MIMETextField.setEditable(false);
        this.m_currentVersionPane.m_actionPane.remove(this.m_currentVersionPane.m_exportButton);
        this.m_currentVersionPane.m_actionPane.remove(this.m_currentVersionPane.m_purgeButton);
        this.m_currentVersionPane.m_checksumTypeComboBox.insertItemAt("Default", 0);
        this.revalidate();
        this.m_currentVersionPane.m_editCustomButton.doClick();
    }

    private static Datastream[] MakeBlankRelsExtDatastream() {
        Datastream[] ds = new Datastream[]{new Datastream(DatastreamControlGroup.fromValue("X"), s_dsid, "RELS-EXT.0", null, "RDF Statements about this object", true, "application/rdf+xml", Constants.RELS_EXT1_0.uri, null, 0L, "A", null, null, null)};
        return ds;
    }

    public InputStream getDatastreamContent(String pid, String id, String createDate) throws IOException {
        String initialContent = "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rel=\"info:fedora/fedora-system:def/relations-external#\">    <rdf:Description rdf:about=\"info:fedora/" + pid + "\">" + "    </rdf:Description>" + "</rdf:RDF>";
        ByteArrayInputStream is = new ByteArrayInputStream(initialContent.getBytes());
        return is;
    }

    public void updateButtonVisibility() {
    }

    public void saveChanges(String logMessage) throws Exception {
        if (this.m_currentVersionPane.isDirty()) {
            String state = s_stateComboBoxValues[this.m_stateComboBox.getSelectedIndex()];
            String label = this.m_currentVersionPane.m_labelTextField.getText().trim();
            String mimeType = this.m_currentVersionPane.m_MIMETextField.getText().trim();
            String formatURI = this.m_currentVersionPane.m_formatURITextField.getText().trim();
            String[] altIDs = this.m_currentVersionPane.m_altIDsTextField.getText().trim().split(" ");
            String checksumType = this.m_currentVersionPane.m_checksumTypeComboBox.getSelectedItem().toString();
            if (checksumType.equals("Default")) {
                checksumType = null;
            }
            String location = null;
            location = Administrator.UPLOADER.upload(this.m_currentVersionPane.m_editor.getContent());
            boolean versionable = this.m_versionableComboBox.getSelectedIndex() == 0;
            String newID = Administrator.APIM.addDatastream(this.m_pid, s_dsid, altIDs, label, versionable, mimeType, formatURI, location, "X", state, checksumType, null, logMessage);
            this.m_owner.addDatastreamTab(s_dsid, false);
        }
    }
}

