/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.actions.ExportObject;
import fedora.client.actions.PurgeObject;
import fedora.client.actions.ViewObjectXML;
import fedora.client.objecteditor.EditingPane;
import fedora.client.objecteditor.ObjectEditorFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ObjectPane
extends EditingPane {
    private static final long serialVersionUID = 1L;
    private final String m_pid;
    private String m_state;
    private String m_label;
    private String m_ownerId;
    private final JComboBox m_stateComboBox;
    private final JTextField m_labelTextField;
    private final JTextField m_ownerIdTextField;
    private final Dimension m_labelDims;

    public ObjectPane(ObjectEditorFrame owner, String pid, String state, String label, String cDate, String mDate, String ownerId) throws Exception {
        super(owner, null, null);
        this.m_pid = pid;
        this.m_state = state;
        this.m_label = label;
        this.m_ownerId = ownerId;
        if (ownerId == null) {
            this.m_ownerId = "";
        }
        this.m_labelDims = new JLabel("Content Model").getPreferredSize();
        JLabel stateLabel = new JLabel("State");
        stateLabel.setPreferredSize(this.m_labelDims);
        JLabel labelLabel = new JLabel("Label");
        labelLabel.setPreferredSize(this.m_labelDims);
        JLabel cModelLabel = new JLabel("Content Model");
        cModelLabel.setPreferredSize(this.m_labelDims);
        JLabel cDateLabel = new JLabel("Created");
        cDateLabel.setPreferredSize(this.m_labelDims);
        JLabel mDateLabel = new JLabel("Modified");
        mDateLabel.setPreferredSize(this.m_labelDims);
        JLabel ownerIdLabel = new JLabel("Owner");
        ownerIdLabel.setPreferredSize(this.m_labelDims);
        JLabel[] labels = new JLabel[]{stateLabel, labelLabel, cDateLabel, mDateLabel, ownerIdLabel};
        String[] comboBoxStrings = new String[]{"Active", "Inactive", "Deleted"};
        this.m_stateComboBox = new JComboBox<String>(comboBoxStrings);
        Administrator.constrainHeight(this.m_stateComboBox);
        if (state.equals("A")) {
            this.m_stateComboBox.setSelectedIndex(0);
            this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
        } else if (state.equals("I")) {
            this.m_stateComboBox.setSelectedIndex(1);
            this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
        } else {
            this.m_stateComboBox.setSelectedIndex(2);
            this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
        }
        this.m_stateComboBox.addActionListener(this.dataChangeListener);
        this.m_stateComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ObjectPane.this.m_stateComboBox.getSelectedIndex() == 0) {
                    ObjectPane.this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
                } else if (ObjectPane.this.m_stateComboBox.getSelectedIndex() == 1) {
                    ObjectPane.this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
                } else {
                    ObjectPane.this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
                }
            }
        });
        this.m_labelTextField = new JTextField(label);
        this.m_labelTextField.getDocument().addDocumentListener(this.dataChangeListener);
        this.m_ownerIdTextField = new JTextField(ownerId);
        this.m_ownerIdTextField.getDocument().addDocumentListener(this.dataChangeListener);
        JTextArea cDateValueLabel = new JTextArea(cDate);
        cDateValueLabel.setBackground(Administrator.BACKGROUND_COLOR);
        cDateValueLabel.setEditable(false);
        JTextArea mDateValueLabel = new JTextArea(mDate);
        mDateValueLabel.setBackground(Administrator.BACKGROUND_COLOR);
        mDateValueLabel.setEditable(false);
        JComponent[] values = new JComponent[]{this.m_stateComboBox, this.m_labelTextField, cDateValueLabel, mDateValueLabel, this.m_ownerIdTextField};
        JPanel northValuePane = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        northValuePane.setLayout(gridBag);
        this.addLabelValueRows(labels, values, gridBag, northValuePane);
        JPanel viewPane = new JPanel();
        JButton viewButton = new JButton(new ViewObjectXML(pid, viewPane));
        viewButton.setText("View XML");
        Administrator.constrainHeight(viewButton);
        JButton exportButton = new JButton(new ExportObject(pid));
        exportButton.setText("Export...");
        Administrator.constrainHeight(exportButton);
        JButton purgeButton = new JButton(new PurgeObject(owner, pid));
        purgeButton.setText("Purge...");
        Administrator.constrainHeight(purgeButton);
        JPanel actionPane = new JPanel(new FlowLayout());
        actionPane.add(viewButton);
        actionPane.add(exportButton);
        actionPane.add(purgeButton);
        this.mainPane.setLayout(new BorderLayout());
        this.mainPane.add((Component)northValuePane, "North");
        this.mainPane.add((Component)viewPane, "Center");
        this.mainPane.add((Component)actionPane, "South");
    }

    public boolean isDirty() {
        if (!this.m_labelTextField.getText().equals(this.m_label)) {
            return true;
        }
        if (!this.m_ownerIdTextField.getText().equals(this.m_ownerId)) {
            return true;
        }
        int origIndex = 0;
        if (this.m_state.equals("I")) {
            origIndex = 1;
        } else if (this.m_state.equals("D")) {
            origIndex = 2;
        }
        return this.m_stateComboBox.getSelectedIndex() != origIndex;
    }

    public void saveChanges(String logMessage) throws Exception {
        String state = null;
        int i = this.m_stateComboBox.getSelectedIndex();
        if (i == 0) {
            state = "A";
        }
        if (i == 1) {
            state = "I";
        }
        if (i == 2) {
            state = "D";
        }
        Administrator.APIM.modifyObject(this.m_pid, state, this.m_labelTextField.getText(), this.m_ownerIdTextField.getText(), logMessage);
    }

    public void changesSaved() {
        int i = this.m_stateComboBox.getSelectedIndex();
        if (i == 0) {
            this.m_state = "A";
        }
        if (i == 1) {
            this.m_state = "I";
        }
        if (i == 2) {
            this.m_state = "D";
        }
        this.m_label = this.m_labelTextField.getText();
        this.m_ownerId = this.m_ownerIdTextField.getText();
    }

    public void undoChanges() {
        if (this.m_state.equals("A")) {
            this.m_stateComboBox.setSelectedIndex(0);
            this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
        } else if (this.m_state.equals("I")) {
            this.m_stateComboBox.setSelectedIndex(1);
            this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
        } else if (this.m_state.equals("D")) {
            this.m_stateComboBox.setSelectedIndex(2);
            this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
        }
        this.m_labelTextField.setText(this.m_label);
        this.m_ownerIdTextField.setText(this.m_ownerId);
    }
}

