/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor.types;

public class DatastreamBindingRule {
    private final String m_key;
    private final String m_inputLabel;
    private final String m_inputInstruction;
    private final int m_max;
    private final boolean m_orderMatters;
    private String[] m_types;
    private boolean m_acceptsAll = false;

    public DatastreamBindingRule(String key, String inputLabel, String inputInstruction, int min, int max, boolean orderMatters, String[] types) {
        this.m_key = key;
        this.m_inputLabel = inputLabel;
        this.m_inputInstruction = inputInstruction;
        this.m_max = max;
        this.m_orderMatters = orderMatters;
        this.m_types = types;
        if (this.m_types == null || this.m_types.length == 0) {
            this.m_types = new String[]{"*/*"};
        }
        for (String element : this.m_types) {
            if (!element.equals("*/*") && !element.equals("*")) continue;
            this.m_acceptsAll = true;
        }
    }

    public boolean accepts(String type) {
        if (this.m_acceptsAll) {
            return true;
        }
        String[] parts = type.split("/");
        if (parts.length != 2) {
            return false;
        }
        for (String element : this.m_types) {
            if (!element.equals(parts[0] + "/*") && !element.equals(type)) continue;
            return true;
        }
        return false;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getInputLabel() {
        return this.m_inputLabel;
    }

    public String getInputInstruction() {
        return this.m_inputInstruction;
    }

    public int getMax() {
        return this.m_max;
    }

    public int getMin() {
        return this.m_max;
    }

    public boolean orderMatters() {
        return this.m_orderMatters;
    }

    public String[] getTypes() {
        return this.m_types;
    }
}

