/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor.types;

import fedora.client.objecteditor.types.MethodDefinition;
import fedora.client.objecteditor.types.ParameterDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MethodDefinitionsDeserializer
extends DefaultHandler {
    private final List m_result = new ArrayList();
    private String m_methodName;
    private String m_methodLabel;
    private List m_methodParms;
    private String m_parmName;
    private String m_parmLabel;
    private String m_parmRequired;
    private String m_parmDefaultValue;
    private List m_parmValidValues;

    public MethodDefinitionsDeserializer(InputStream xml) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(xml, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            throw new IOException("Error parsing method definitions: " + e.getClass().getName());
        }
    }

    public List getResult() {
        return this.m_result;
    }

    public void startElement(String uri, String localName, String qName, Attributes a) {
        block8: {
            block9: {
                block7: {
                    if (!localName.equals("Method")) break block7;
                    this.m_methodName = null;
                    this.m_methodLabel = null;
                    this.m_methodParms = new ArrayList();
                    for (int i = 0; i < a.getLength(); ++i) {
                        String name = a.getLocalName(i);
                        if (name.equals("operationName")) {
                            this.m_methodName = a.getValue(i);
                            continue;
                        }
                        if (!name.equals("label")) continue;
                        this.m_methodLabel = a.getValue(i);
                    }
                    break block8;
                }
                if (!localName.equals("UserInputParm")) break block9;
                this.m_parmName = null;
                this.m_parmLabel = null;
                this.m_parmRequired = null;
                this.m_parmDefaultValue = null;
                this.m_parmValidValues = new ArrayList();
                for (int i = 0; i < a.getLength(); ++i) {
                    String name = a.getLocalName(i);
                    if (name.equals("parmName")) {
                        this.m_parmName = a.getValue(i);
                        continue;
                    }
                    if (name.equals("label")) {
                        this.m_parmLabel = a.getValue(i);
                        continue;
                    }
                    if (name.equals("required")) {
                        this.m_parmRequired = a.getValue(i);
                        continue;
                    }
                    if (!name.equals("defaultValue")) continue;
                    this.m_parmDefaultValue = a.getValue(i);
                }
                break block8;
            }
            if (!localName.equals("ValidParm")) break block8;
            for (int i = 0; i < a.getLength(); ++i) {
                String name = a.getLocalName(i);
                if (!name.equals("value")) continue;
                this.m_parmValidValues.add(a.getValue(i));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("UserInputParm")) {
            if (this.m_parmName == null || this.m_parmName.length() == 0) {
                throw new SAXException("UserInputParm must have a name attribute with length>1.");
            }
            boolean parmRequired = false;
            if (this.m_parmRequired != null && (this.m_parmRequired.equalsIgnoreCase("true") || this.m_parmRequired.equalsIgnoreCase("yes") || this.m_parmRequired.equals("1"))) {
                parmRequired = true;
            }
            this.m_methodParms.add(new ParameterDefinition(this.m_parmName, this.m_parmLabel, parmRequired, this.m_parmDefaultValue, this.m_parmValidValues));
        } else if (localName.equals("Method")) {
            if (this.m_methodName == null || this.m_methodName.length() == 0) {
                throw new SAXException("Method must have a name attribute with length>1.");
            }
            this.m_result.add(new MethodDefinition(this.m_methodName, this.m_methodLabel, this.m_methodParms));
        }
    }
}

