/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.search;

import fedora.client.Administrator;
import fedora.client.actions.ChangeObjectState;
import fedora.client.actions.ExportObject;
import fedora.client.actions.PurgeObject;
import fedora.client.actions.ViewObject;
import fedora.client.actions.ViewObjectXML;
import fedora.client.utility.AutoFinder;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.FieldSearchResult;
import fedora.server.types.gen.ObjectFields;
import fedora.swing.jtable.DefaultSortTableModel;
import fedora.swing.jtable.JSortTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;

public class ResultFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JSortTable m_table;
    private String[] m_rowPids;
    private JButton m_moreButton;
    private AutoFinder m_finder = null;

    public ResultFrame(String frameTitle, String[] displayFields, String sessionToken) {
        super(frameTitle, true, true, true, true);
        try {
            this.m_finder = new AutoFinder(Administrator.APIA);
            this.searchAndDisplay(this.m_finder.resumeFindObjects(sessionToken), displayFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR: " + e.getClass().getName() + ":" + e.getMessage());
        }
    }

    public ResultFrame(String frameTitle, String[] displayFields, int maxResults, FieldSearchQuery query) {
        super(frameTitle, true, true, true, true);
        String[] resultFields;
        boolean displayPid = false;
        for (String element : displayFields) {
            if (!element.equals("pid")) continue;
            displayPid = true;
        }
        if (displayPid) {
            resultFields = displayFields;
        } else {
            resultFields = new String[displayFields.length + 1];
            resultFields[0] = "pid";
            for (int i = 1; i < displayFields.length + 1; ++i) {
                resultFields[i] = displayFields[i - 1];
            }
        }
        try {
            if (this.m_finder == null) {
                this.m_finder = new AutoFinder(Administrator.APIA);
            }
            this.searchAndDisplay(this.m_finder.findObjects(resultFields, maxResults, query), displayFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR: " + e.getClass().getName() + ":" + e.getMessage());
        }
    }

    private void searchAndDisplay(FieldSearchResult fsr, String[] displayFields) throws Exception {
        ObjectFields[] ofs = fsr.getResultList();
        Object[][] data = new Object[ofs.length][displayFields.length];
        this.m_rowPids = new String[ofs.length];
        for (int i = 0; i < ofs.length; ++i) {
            ObjectFields o = ofs[i];
            this.m_rowPids[i] = o.getPid();
            for (int j = 0; j < displayFields.length; ++j) {
                data[i][j] = this.getValue(o, displayFields[j]);
            }
        }
        DefaultSortTableModel model = new DefaultSortTableModel(data, displayFields);
        this.m_table = new JSortTable(model);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.m_table.setShowVerticalLines(false);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setUI(new BrowserTableUI());
        JScrollPane browsePanel = new JScrollPane(this.m_table);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)browsePanel, "Center");
        if (fsr.getListSession() != null && fsr.getListSession().getToken() != null) {
            this.m_moreButton = new JButton("More Results...");
            this.m_moreButton.addActionListener(new MoreResultsListener(displayFields, fsr.getListSession().getToken(), this));
            this.getContentPane().add((Component)this.m_moreButton, "South");
        }
        this.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Zoom16.gif")));
        this.pack();
        this.setSize(Administrator.getDesktop().getWidth() - 40, this.getSize().height);
    }

    protected void removeMoreResultsButton() {
        if (this.m_moreButton != null) {
            this.getContentPane().remove(this.m_moreButton);
        }
    }

    public String getValue(ObjectFields o, String name) {
        if (name.equals("pid")) {
            return o.getPid();
        }
        if (name.equals("label")) {
            return o.getLabel();
        }
        if (name.equals("state")) {
            return o.getState();
        }
        if (name.equals("ownerId")) {
            return o.getOwnerId();
        }
        if (name.equals("cDate")) {
            return o.getCDate();
        }
        if (name.equals("mDate")) {
            return o.getMDate();
        }
        if (name.equals("dcmDate")) {
            return o.getDcmDate();
        }
        if (name.equals("title")) {
            return this.getList(o.getTitle());
        }
        if (name.equals("creator")) {
            return this.getList(o.getCreator());
        }
        if (name.equals("subject")) {
            return this.getList(o.getSubject());
        }
        if (name.equals("description")) {
            return this.getList(o.getDescription());
        }
        if (name.equals("publisher")) {
            return this.getList(o.getPublisher());
        }
        if (name.equals("contributor")) {
            return this.getList(o.getContributor());
        }
        if (name.equals("date")) {
            return this.getList(o.getDate());
        }
        if (name.equals("type")) {
            return this.getList(o.getType());
        }
        if (name.equals("format")) {
            return this.getList(o.getFormat());
        }
        if (name.equals("identifier")) {
            return this.getList(o.getIdentifier());
        }
        if (name.equals("source")) {
            return this.getList(o.getSource());
        }
        if (name.equals("language")) {
            return this.getList(o.getLanguage());
        }
        if (name.equals("relation")) {
            return this.getList(o.getRelation());
        }
        if (name.equals("coverage")) {
            return this.getList(o.getCoverage());
        }
        if (name.equals("rights")) {
            return this.getList(o.getRights());
        }
        return null;
    }

    public String getList(String[] s) {
        if (s == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(s[i]);
        }
        return out.toString();
    }

    public class MultiSelectionPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public MultiSelectionPopup(Set pids) {
            JMenuItem i0 = new JMenuItem(new ViewObject(pids));
            i0.setMnemonic(79);
            i0.setToolTipText("Launches a viewer for the selected objects.");
            JMenuItem i1 = new JMenuItem(new ViewObjectXML(pids));
            i1.setMnemonic(86);
            i1.setToolTipText("Launches an XML viewer for the selected objects.");
            JMenuItem i2 = new JMenuItem(new ExportObject(pids));
            i2.setMnemonic(69);
            i2.setToolTipText("Exports the selected objects.");
            JMenuItem i3 = new JMenuItem(new PurgeObject(pids));
            i3.setMnemonic(80);
            i3.setToolTipText("Removes the selected objects from the repository.");
            this.add(i0);
            this.add(i1);
            this.add(i2);
            this.add(i3);
            JMenu m1 = new JMenu("Set object states to");
            JMenuItem activeItem = new JMenuItem(new ChangeObjectState(pids, "Active"));
            JMenuItem inactiveItem = new JMenuItem(new ChangeObjectState(pids, "Inactive"));
            JMenuItem deletedItem = new JMenuItem(new ChangeObjectState(pids, "Deleted"));
            m1.add(activeItem);
            m1.add(inactiveItem);
            m1.add(deletedItem);
            this.add(m1);
        }
    }

    public class SingleSelectionPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public SingleSelectionPopup(String pid) {
            JMenuItem i0 = new JMenuItem(new ViewObject(pid));
            i0.setMnemonic(79);
            i0.setToolTipText("Launches a viewer for the selected object.");
            JMenuItem i1 = new JMenuItem(new ViewObjectXML(pid));
            i1.setMnemonic(86);
            i1.setToolTipText("Launches an XML viewer for the selected object.");
            JMenuItem i2 = new JMenuItem(new ExportObject(pid));
            i2.setMnemonic(69);
            i2.setToolTipText("Exports the selected object.");
            JMenuItem i3 = new JMenuItem(new PurgeObject(pid));
            i3.setMnemonic(80);
            i3.setToolTipText("Removes the selected object from the repository.");
            this.add(i0);
            this.add(i1);
            this.add(i2);
            this.add(i3);
            JMenu m1 = new JMenu("Set object state to");
            JMenuItem activeItem = new JMenuItem(new ChangeObjectState(pid, "Active"));
            JMenuItem inactiveItem = new JMenuItem(new ChangeObjectState(pid, "Inactive"));
            JMenuItem deletedItem = new JMenuItem(new ChangeObjectState(pid, "Deleted"));
            m1.add(activeItem);
            m1.add(inactiveItem);
            m1.add(deletedItem);
            this.add(m1);
        }
    }

    public class BrowserTableUI
    extends BasicTableUI {
        protected MouseInputListener createMouseInputListener() {
            return new BasicTableUI.MouseInputHandler(){

                public void mouseClicked(MouseEvent e) {
                    int rowNum;
                    if (e.getClickCount() == 2 && (rowNum = ResultFrame.this.m_table.rowAtPoint(new Point(e.getX(), e.getY()))) >= 0) {
                        new ViewObject(ResultFrame.this.m_rowPids[rowNum]).launch();
                    }
                }

                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        int rowNum = ResultFrame.this.m_table.rowAtPoint(new Point(e.getX(), e.getY()));
                        if (rowNum >= 0) {
                            int[] sRows = ResultFrame.this.m_table.getSelectedRows();
                            boolean clickedOnSelected = false;
                            HashSet<String> pids = new HashSet<String>();
                            for (int element : sRows) {
                                if (element == rowNum) {
                                    clickedOnSelected = true;
                                }
                                pids.add(ResultFrame.this.m_rowPids[element]);
                            }
                            if (!clickedOnSelected) {
                                pids = new HashSet();
                                ResultFrame.this.m_table.clearSelection();
                                ResultFrame.this.m_table.addRowSelectionInterval(rowNum, rowNum);
                                pids.add(ResultFrame.this.m_rowPids[rowNum]);
                            }
                            if (pids.size() == 1) {
                                Iterator pidIter = pids.iterator();
                                new SingleSelectionPopup((String)pidIter.next()).show(e.getComponent(), e.getX(), e.getY());
                            } else {
                                new MultiSelectionPopup(pids).show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    } else {
                        super.mousePressed(e);
                    }
                }
            };
        }
    }

    public class MoreResultsListener
    implements ActionListener {
        String[] m_displayFields;
        String m_sessionToken;
        ResultFrame m_parent;

        public MoreResultsListener(String[] displayFields, String sessionToken, ResultFrame parent) {
            this.m_displayFields = displayFields;
            this.m_sessionToken = sessionToken;
            this.m_parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_parent.removeMoreResultsButton();
            ResultFrame frame = new ResultFrame("More Search Results", this.m_displayFields, this.m_sessionToken);
            frame.setVisible(true);
            Administrator.getDesktop().add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

