/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.test;

import fedora.client.FedoraClient;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class PerformanceTests
implements Constants {
    private FedoraAPIM apim;
    private FedoraAPIA apia;
    private static int iterations = 10;
    private static int threads = 10;
    private static final String pid = "demo:performance";
    private static String DEMO_FOXML_TEXT;
    private static String datastream;
    private String host;
    private String port;
    private String username;
    private String password;
    private String[] PIDS;
    private byte[][] FOXML;

    public void init(String host, String port, String username, String password) throws Exception {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        String baseURL = "http://" + host + ":" + port + "/fedora";
        FedoraClient fedoraClient = new FedoraClient(baseURL, username, password);
        this.apim = fedoraClient.getAPIM();
        this.apia = fedoraClient.getAPIA();
        this.PIDS = this.apim.getNextPID(new NonNegativeInteger(Integer.valueOf(iterations).toString()), "demo");
        this.FOXML = new byte[iterations][];
        for (int i = 0; i < iterations; ++i) {
            this.FOXML[i] = DEMO_FOXML_TEXT.replaceAll(pid, this.PIDS[i]).getBytes("UTF-8");
        }
    }

    private void runIngest(byte[] foxml) throws Exception {
        this.apim.ingest(foxml, PerformanceTests.FOXML1_1.uri, "Ingest Test");
    }

    private void runAddDatastream(String pid, String dsId) throws Exception {
        this.apim.addDatastream(pid, dsId, null, "New Datastream", true, "text/xml", null, datastream, "M", "A", null, null, "Adding Test Datastream");
    }

    private void runModifyDatastreamByRef(String pid) throws Exception {
        this.apim.modifyDatastreamByReference(pid, "MDS1", null, "New Label", "text/xml", null, datastream, null, null, "Modify Datastream Test", false);
    }

    private void runModifyDatastreamByValue(String pid) throws Exception {
        String dsContent = "<xml>Updated Content</xml>";
        this.apim.modifyDatastreamByValue(pid, "XDS1", null, "New Label", "text/xml", null, dsContent.getBytes(), null, null, "Modify Datastream Test", false);
    }

    private void runPurgeDatastream(String pid, String dsId) throws Exception {
        this.apim.purgeDatastream(pid, dsId, null, null, "Purge Datastream Test", false);
    }

    private void runPurgeObject(String pid) throws Exception {
        this.apim.purgeObject(pid, "Removing Test Object", false);
    }

    private void runGetDatastream(String pid) throws Exception {
        this.apia.getDatastreamDissemination(pid, "MDS1", null);
    }

    private void runGetDatastreamRest(String pid) throws Exception {
        HttpMethod httpMethod = this.getHttpMethod(pid);
        HttpClient client = this.getHttpClient();
        client.executeMethod(httpMethod);
        InputStream in = httpMethod.getResponseBodyAsStream();
        int input = in.read();
        while (input > 0) {
            input = in.read();
        }
    }

    public long runIngestTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        for (int i = 0; i < iterations; ++i) {
            startTime = System.currentTimeMillis();
            this.runIngest(this.FOXML[0]);
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
            this.runPurgeObject(this.PIDS[0]);
        }
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runAddDatastreamTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        for (int i = 0; i < iterations; ++i) {
            startTime = System.currentTimeMillis();
            this.runAddDatastream(this.PIDS[0], "MDS3");
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
            this.runPurgeDatastream(this.PIDS[0], "MDS3");
        }
        this.runPurgeObject(this.PIDS[0]);
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runModifyDatastreamByRefTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        for (int i = 0; i < iterations; ++i) {
            startTime = System.currentTimeMillis();
            this.runModifyDatastreamByRef(this.PIDS[0]);
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
        }
        this.runPurgeObject(this.PIDS[0]);
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runModifyDatastreamByValueTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        for (int i = 0; i < iterations; ++i) {
            startTime = System.currentTimeMillis();
            this.runModifyDatastreamByValue(this.PIDS[0]);
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
        }
        this.runPurgeObject(this.PIDS[0]);
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runPurgeDatastreamTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        for (int i = 0; i < iterations; ++i) {
            this.runAddDatastream(this.PIDS[0], "MDS3");
            startTime = System.currentTimeMillis();
            this.runPurgeDatastream(this.PIDS[0], "MDS3");
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
        }
        this.runPurgeObject(this.PIDS[0]);
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runPurgeObjectTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        for (int i = 0; i < iterations; ++i) {
            this.runIngest(this.FOXML[0]);
            startTime = System.currentTimeMillis();
            this.runPurgeObject(this.PIDS[0]);
            stopTime = System.currentTimeMillis();
            totalTime += stopTime - startTime;
        }
        long average = totalTime / (long)iterations;
        return average;
    }

    public long runGetDatastreamTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.runGetDatastream(this.PIDS[0]);
        }
        stopTime = System.currentTimeMillis();
        totalTime = stopTime - startTime;
        this.runPurgeObject(this.PIDS[0]);
        return totalTime;
    }

    public long runGetDatastreamRestTest() throws Exception {
        long totalTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        this.runIngest(this.FOXML[0]);
        HttpMethod httpMethod = this.getHttpMethod(this.PIDS[0]);
        HttpClient client = this.getHttpClient();
        startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            client.executeMethod(httpMethod);
            InputStream in = httpMethod.getResponseBodyAsStream();
            int input = in.read();
            while (input > 0) {
                input = in.read();
            }
        }
        stopTime = System.currentTimeMillis();
        totalTime = stopTime - startTime;
        this.runPurgeObject(this.PIDS[0]);
        return totalTime;
    }

    private HttpMethod getHttpMethod(String pid) {
        String url = "http://" + this.host + ":" + this.port + "/fedora/get/" + pid + "/" + "MDS1";
        GetMethod httpMethod = new GetMethod(url);
        httpMethod.setDoAuthentication(true);
        httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
        return httpMethod;
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(this.host, Integer.valueOf(this.port).intValue(), "realm"), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return client;
    }

    public long[] runThroughputTests() throws Exception {
        int i;
        long ingestTime = 0L;
        long addDsTime = 0L;
        long modifyRefTime = 0L;
        long modifyValTime = 0L;
        long purgeDsTime = 0L;
        long purgeObjectTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runIngest(this.FOXML[i]);
        }
        stopTime = System.currentTimeMillis();
        ingestTime = stopTime - startTime;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runAddDatastream(this.PIDS[i], "MDS3");
        }
        stopTime = System.currentTimeMillis();
        addDsTime = stopTime - startTime;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runModifyDatastreamByRef(this.PIDS[i]);
        }
        stopTime = System.currentTimeMillis();
        modifyRefTime = stopTime - startTime;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runModifyDatastreamByValue(this.PIDS[i]);
        }
        stopTime = System.currentTimeMillis();
        modifyValTime = stopTime - startTime;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runPurgeDatastream(this.PIDS[i], "MDS1");
        }
        stopTime = System.currentTimeMillis();
        purgeDsTime = stopTime - startTime;
        startTime = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            this.runPurgeObject(this.PIDS[i]);
        }
        stopTime = System.currentTimeMillis();
        purgeObjectTime = stopTime - startTime;
        long[] totals = new long[]{ingestTime, addDsTime, modifyRefTime, modifyValTime, purgeDsTime, purgeObjectTime};
        return totals;
    }

    public long[] runThreadedThroughputTests() throws Exception {
        long ingestTime = 0L;
        long addDsTime = 0L;
        long modifyRefTime = 0L;
        long modifyValTime = 0L;
        long purgeDsTime = 0L;
        long purgeObjectTime = 0L;
        long getDatastreamTime = 0L;
        long getDatastreamRestTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        ArrayList<MethodRunner> ingestRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            ingestRunnerList.add(new MethodRunner(MethodType.INGEST, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(ingestRunnerList);
        stopTime = System.currentTimeMillis();
        ingestTime = stopTime - startTime;
        ArrayList<MethodRunner> addDatastreamRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            addDatastreamRunnerList.add(new MethodRunner(MethodType.ADD_DATASTREAM, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(addDatastreamRunnerList);
        stopTime = System.currentTimeMillis();
        addDsTime = stopTime - startTime;
        ArrayList<MethodRunner> modDatastreamRefRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            modDatastreamRefRunnerList.add(new MethodRunner(MethodType.MODIFY_DATASTREAM_REF, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(modDatastreamRefRunnerList);
        stopTime = System.currentTimeMillis();
        modifyRefTime = stopTime - startTime;
        ArrayList<MethodRunner> modDatastreamValRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            modDatastreamValRunnerList.add(new MethodRunner(MethodType.MODIFY_DATASTREAM_VAL, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(modDatastreamValRunnerList);
        stopTime = System.currentTimeMillis();
        modifyValTime = stopTime - startTime;
        ArrayList<MethodRunner> purgeDatastreamRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            purgeDatastreamRunnerList.add(new MethodRunner(MethodType.PURGE_DATASTREAM, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(purgeDatastreamRunnerList);
        stopTime = System.currentTimeMillis();
        purgeDsTime = stopTime - startTime;
        ArrayList<MethodRunner> purgeObjectRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            purgeObjectRunnerList.add(new MethodRunner(MethodType.PURGE_OBJECT, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(purgeObjectRunnerList);
        stopTime = System.currentTimeMillis();
        purgeObjectTime = stopTime - startTime;
        ArrayList<MethodRunner> getDatastreamRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            getDatastreamRunnerList.add(new MethodRunner(MethodType.GET_DATASTREAM, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(getDatastreamRunnerList);
        stopTime = System.currentTimeMillis();
        getDatastreamTime = stopTime - startTime;
        ArrayList<MethodRunner> getDatastreamRestRunnerList = new ArrayList<MethodRunner>();
        for (int i = 0; i < iterations; ++i) {
            getDatastreamRestRunnerList.add(new MethodRunner(MethodType.GET_DATASTREAM_REST, i));
        }
        startTime = System.currentTimeMillis();
        threadPool.invokeAll(getDatastreamRestRunnerList);
        stopTime = System.currentTimeMillis();
        getDatastreamRestTime = stopTime - startTime;
        long[] totals = new long[]{ingestTime, addDsTime, modifyRefTime, modifyValTime, purgeDsTime, purgeObjectTime, getDatastreamTime, getDatastreamRestTime};
        return totals;
    }

    private static double round(double d) {
        int decimalPlace = 5;
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }

    private static void usage() {
        System.out.println("Runs a set of performance tests over a running Fedora repository.");
        System.out.println("USAGE: ant performance-tests -Dhost=HOST -Dport=PORT -Dusername=USERNAME -Dpassword=PASSWORD -Diterations=NUM-ITERATIONS -Dthreads=NUM-THREADS -Dfile=OUTPUT-FILE -Dname=TEST-NAME");
        System.out.println("Where:");
        System.out.println("  HOST = Host on which Fedora server is running.");
        System.out.println("  PORT = Port on which the Fedora server APIs can be accessed.");
        System.out.println("  USERNAME = A fedora user with administrative privileges.");
        System.out.println("  PASSWORD = The fedora user's password.");
        System.out.println("  NUM-ITERATIONS = The number of times to perform each operation.");
        System.out.println("  NUM-THREADS = The number of threads to use in the thread pool");
        System.out.println("                when running threaded tests.");
        System.out.println("  OUTPUT-FILE = The file to which the test results will be written.");
        System.out.println("                If the file does not exist, it will be created, if the");
        System.out.println("                file does exist the new results will be appended.");
        System.out.println("  TEST-NAME = A name for this test run.");
        System.out.println("Example:");
        System.out.println("ant performance-tests -Dhost=localhost -Dport=8080 -Dusername=fedoraAdmin -Dpassword=fedoraAdmin -Diterations=100 -Dthreads=10 -Dfile=C:\\temp\\performance_testing_output.txt -Dname=\"Test 1\"");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 8) {
            PerformanceTests.usage();
        }
        String host = args[0];
        String port = args[1];
        String username = args[2];
        String password = args[3];
        String itr = args[4];
        String thrds = args[5];
        String output = args[6];
        String name = args[7];
        if (host == null || host.startsWith("$") || port == null || port.startsWith("$") || username == null || username.startsWith("$") || password == null || password.startsWith("$") || itr == null || itr.startsWith("$") || thrds == null || thrds.startsWith("$") || output == null || output.startsWith("$") || name == null || name.startsWith("$")) {
            PerformanceTests.usage();
        }
        name = name.replaceAll(",", ";");
        iterations = Integer.parseInt(itr);
        threads = Integer.parseInt(thrds);
        boolean newFile = true;
        File outputFile = new File(output);
        File tempFile = null;
        BufferedReader reader = null;
        String line = "";
        if (outputFile.exists()) {
            newFile = false;
            tempFile = File.createTempFile("performance-test", "tmp");
            BufferedReader input = new BufferedReader(new FileReader(outputFile));
            PrintStream tempOut = new PrintStream(tempFile);
            while ((line = input.readLine()) != null) {
                tempOut.println(line);
            }
            input.close();
            tempOut.close();
            reader = new BufferedReader(new FileReader(tempFile));
        }
        PrintStream out = new PrintStream(outputFile);
        if (newFile) {
            out.println("-------------------------------------------------------------- Performance Test Results --------------------------------------------------------------");
        }
        PerformanceTests tests = new PerformanceTests();
        tests.init(host, port, username, password);
        System.out.println("Running Ingest Round-Trip Test...");
        long ingestResults = tests.runIngestTest();
        System.out.println("Running AddDatastream Round-Trip Test...");
        long addDsResults = tests.runAddDatastreamTest();
        System.out.println("Running ModifyDatastreamByReference Round-Trip Test...");
        long modifyRefResults = tests.runModifyDatastreamByRefTest();
        System.out.println("Running ModifyDatastreamByValue Round-Trip Test...");
        long modifyValResults = tests.runModifyDatastreamByValueTest();
        System.out.println("Running PurgeDatastream Round-Trip Test...");
        long purgeDsResults = tests.runPurgeDatastreamTest();
        System.out.println("Running PurgeObject Round-Trip Test...");
        long purgeObjectResults = tests.runPurgeObjectTest();
        System.out.println("Running GetDatastream Round-Trip Test...");
        long getDatastreamResults = tests.runGetDatastreamTest();
        System.out.println("Running GetDatastreamREST Round-Trip Test...");
        long getDatastreamRestResults = tests.runGetDatastreamRestTest();
        System.out.println("Running Throughput Tests...");
        long[] tpResults = tests.runThroughputTests();
        System.out.println("Running Threaded Throughput Tests...");
        long[] tptResults = tests.runThreadedThroughputTests();
        if (newFile) {
            out.println("1. Test performing each operation in isolation. Time (in ms) is the average required to perform each operation.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        out.println(name + ", " + ingestResults + ", " + addDsResults + ", " + modifyRefResults + ", " + modifyValResults + ", " + purgeDsResults + ", " + purgeObjectResults + ", " + getDatastreamResults / (long)iterations + ", " + getDatastreamRestResults / (long)iterations);
        out.println();
        if (newFile) {
            out.println("2. Operations-Per-Second based on results listed in item 1.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        double ingestPerSecond = 1000.0 / (double)ingestResults;
        double addDsPerSecond = 1000.0 / (double)addDsResults;
        double modifyRefPerSecond = 1000.0 / (double)modifyRefResults;
        double modifyValPerSecond = 1000.0 / (double)modifyValResults;
        double purgeDsPerSecond = 1000.0 / (double)purgeDsResults;
        double purgeObjPerSecond = 1000.0 / (double)purgeObjectResults;
        double getDatastreamPerSecond = 1000.0 / ((double)getDatastreamResults / (double)iterations);
        double getDatastreamRestPerSecond = 1000.0 / ((double)getDatastreamRestResults / (double)iterations);
        out.println(name + ", " + PerformanceTests.round(ingestPerSecond) + ", " + PerformanceTests.round(addDsPerSecond) + ", " + PerformanceTests.round(modifyRefPerSecond) + ", " + PerformanceTests.round(modifyValPerSecond) + ", " + PerformanceTests.round(purgeDsPerSecond) + ", " + PerformanceTests.round(purgeObjPerSecond) + ", " + PerformanceTests.round(getDatastreamPerSecond) + ", " + PerformanceTests.round(getDatastreamRestPerSecond));
        out.println();
        if (newFile) {
            out.println("3. Test performing operations back-to-back. Time (in ms) is that required to perform all iterations.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        out.println(name + ", " + tpResults[0] + ", " + tpResults[1] + ", " + tpResults[2] + ", " + tpResults[3] + ", " + tpResults[4] + ", " + tpResults[5] + ", " + getDatastreamResults + ", " + getDatastreamRestResults);
        out.println();
        if (newFile) {
            out.println("4. Operations-Per-Second based on results listed in item 3.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        double ingestItPerSecond = (double)(iterations * 1000) / (double)tpResults[0];
        double addDsItPerSecond = (double)(iterations * 1000) / (double)tpResults[1];
        double modifyRefItPerSecond = (double)(iterations * 1000) / (double)tpResults[2];
        double modifyValItPerSecond = (double)(iterations * 1000) / (double)tpResults[3];
        double purgeDsItPerSecond = (double)(iterations * 1000) / (double)tpResults[4];
        double purgeObjItPerSecond = (double)(iterations * 1000) / (double)tpResults[5];
        double getDsItPerSecond = (double)(iterations * 1000) / (double)getDatastreamResults;
        double getDsRestItPerSecond = (double)(iterations * 1000) / (double)getDatastreamRestResults;
        out.println(name + ", " + PerformanceTests.round(ingestItPerSecond) + ", " + PerformanceTests.round(addDsItPerSecond) + ", " + PerformanceTests.round(modifyRefItPerSecond) + ", " + PerformanceTests.round(modifyValItPerSecond) + ", " + PerformanceTests.round(purgeDsItPerSecond) + ", " + PerformanceTests.round(purgeObjItPerSecond) + ", " + PerformanceTests.round(getDsItPerSecond) + ", " + PerformanceTests.round(getDsRestItPerSecond));
        out.println();
        if (newFile) {
            out.println("5. Test performing operations using a thread pool. Time (in ms) is that required to perform all iterations.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        out.println(name + ", " + tptResults[0] + ", " + tptResults[1] + ", " + tptResults[2] + ", " + tptResults[3] + ", " + tptResults[4] + ", " + tptResults[5] + ", " + tptResults[6] + ", " + tptResults[7]);
        out.println();
        if (newFile) {
            out.println("6. Operations-Per-Second based on results listed in item 5.");
            out.println("test name, ingest, addDatastream, modifyDatastreamByReference, modifyDatastreamByValue, purgeDatastream, purgeObject, getDatastream, getDatastreamREST");
        } else {
            line = reader.readLine();
            while (line != null && line.length() > 2) {
                out.println(line);
                line = reader.readLine();
            }
        }
        double thrdIngestItPerSecond = (double)(iterations * 1000) / (double)tptResults[0];
        double thrdAddDsItPerSecond = (double)(iterations * 1000) / (double)tptResults[1];
        double thrdModifyRefItPerSecond = (double)(iterations * 1000) / (double)tptResults[2];
        double thrdModifyValItPerSecond = (double)(iterations * 1000) / (double)tptResults[3];
        double thrdPurgeDsItPerSecond = (double)(iterations * 1000) / (double)tptResults[4];
        double thrdPurgeObjItPerSecond = (double)(iterations * 1000) / (double)tptResults[5];
        double thrdGetDsItPerSecond = (double)(iterations * 1000) / (double)tptResults[6];
        double thrdGetDsRestItPerSecond = (double)(iterations * 1000) / (double)tptResults[7];
        out.println(name + ", " + PerformanceTests.round(thrdIngestItPerSecond) + ", " + PerformanceTests.round(thrdAddDsItPerSecond) + ", " + PerformanceTests.round(thrdModifyRefItPerSecond) + ", " + PerformanceTests.round(thrdModifyValItPerSecond) + ", " + PerformanceTests.round(thrdPurgeDsItPerSecond) + ", " + PerformanceTests.round(thrdPurgeObjItPerSecond) + ", " + PerformanceTests.round(thrdGetDsItPerSecond) + ", " + PerformanceTests.round(thrdGetDsRestItPerSecond));
        if (!newFile) {
            reader.close();
            tempFile.delete();
        }
        out.close();
        System.out.println("Performance Tests Complete.");
    }

    static {
        datastream = "http://localhost:8080/fedora-demo/simple-image-demo/coliseum-thumb.jpg";
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject PID=\"demo:performance\" VERSION=\"1.1\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\"");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"Active\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"Test Object\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#ownerId\" VALUE=\"fedoraAdmin\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2008-07-09T19:28:04.890Z\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2008-07-09T19:32:31.750Z\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"X\" ID=\"AUDIT\" STATE=\"A\" VERSIONABLE=\"false\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:28:04.890Z\"");
        sb.append("      FORMAT_URI=\"info:fedora/fedora-system:format/xml.fedora.audit\" ID=\"AUDIT.0\" LABEL=\"Fedora Object Audit Trail\" MIMETYPE=\"text/xml\">");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <audit:auditTrail xmlns:audit=\"info:fedora/fedora-system:def/audit#\">");
        sb.append("          <audit:record ID=\"AUDREC1\">");
        sb.append("            <audit:process type=\"Fedora API-M\"/>");
        sb.append("            <audit:action>ingest</audit:action>");
        sb.append("            <audit:componentID/>");
        sb.append("            <audit:responsibility>fedoraAdmin</audit:responsibility>");
        sb.append("            <audit:date>2008-07-09T19:28:04.890Z</audit:date>");
        sb.append("            <audit:justification>Created New Object</audit:justification>");
        sb.append("          </audit:record>");
        sb.append("        </audit:auditTrail>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"X\" ID=\"DC\" STATE=\"A\" VERSIONABLE=\"true\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:28:04.890Z\" ID=\"DC1.0\" LABEL=\"Dublin Core Metadata\"");
        sb.append("      MIMETYPE=\"text/xml\" SIZE=\"226\">");
        sb.append("      <foxml:contentDigest DIGEST=\"none\" TYPE=\"DISABLED\"/>");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("          <dc:title>Test Object</dc:title>");
        sb.append("          <dc:identifier>demo:performance</dc:identifier>");
        sb.append("        </oai_dc:dc>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"X\" ID=\"XDS1\" STATE=\"A\" VERSIONABLE=\"true\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:28:58.125Z\" ID=\"XDS1.0\" LABEL=\"XML Datastream 1\" MIMETYPE=\"text/xml\" SIZE=\"41\">");
        sb.append("      <foxml:contentDigest DIGEST=\"none\" TYPE=\"DISABLED\"/>");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <xml>Datastream Content</xml>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"X\" ID=\"XDS2\" STATE=\"A\" VERSIONABLE=\"true\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:29:33.609Z\" ID=\"XDS2.0\" LABEL=\"XML Datastream 2\" MIMETYPE=\"text/xml\" SIZE=\"41\">");
        sb.append("      <foxml:contentDigest DIGEST=\"none\" TYPE=\"DISABLED\"/>");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <xml>Datastream Content</xml>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"M\" ID=\"MDS1\" STATE=\"A\" VERSIONABLE=\"true\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:31:57.593Z\" ID=\"MDS1.0\" LABEL=\"Managed Datastream 1\" MIMETYPE=\"text/xml\" SIZE=\"0\">");
        sb.append("      <foxml:contentDigest DIGEST=\"none\" TYPE=\"DISABLED\"/>");
        sb.append("      <foxml:binaryContent>");
        sb.append("              PHhtbD5EYXRhc3RyZWFtIENvbnRlbnQ8L3htbD4=");
        sb.append("            </foxml:binaryContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream CONTROL_GROUP=\"M\" ID=\"MDS2\" STATE=\"A\" VERSIONABLE=\"true\">");
        sb.append("    <foxml:datastreamVersion CREATED=\"2008-07-09T19:32:31.750Z\" ID=\"MDS2.0\" LABEL=\"Managed Datastream 2\" MIMETYPE=\"text/xml\" SIZE=\"0\">");
        sb.append("      <foxml:contentDigest DIGEST=\"none\" TYPE=\"DISABLED\"/>");
        sb.append("      <foxml:binaryContent>");
        sb.append("              PHhtbD5EYXRhc3RyZWFtIENvbnRlbnQ8L3htbD4=");
        sb.append("            </foxml:binaryContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("</foxml:digitalObject>");
        DEMO_FOXML_TEXT = sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodRunner
    implements Callable<Boolean> {
        MethodType methodType;
        int index;

        public MethodRunner(MethodType methodType, int index) {
            this.methodType = methodType;
            this.index = index;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.methodType.equals((Object)MethodType.INGEST)) {
                PerformanceTests.this.runIngest(PerformanceTests.this.FOXML[this.index]);
            } else if (this.methodType.equals((Object)MethodType.ADD_DATASTREAM)) {
                PerformanceTests.this.runAddDatastream(PerformanceTests.this.PIDS[this.index], "MDS3");
            } else if (this.methodType.equals((Object)MethodType.MODIFY_DATASTREAM_REF)) {
                PerformanceTests.this.runModifyDatastreamByRef(PerformanceTests.this.PIDS[this.index]);
            } else if (this.methodType.equals((Object)MethodType.MODIFY_DATASTREAM_VAL)) {
                PerformanceTests.this.runModifyDatastreamByValue(PerformanceTests.this.PIDS[this.index]);
            } else if (this.methodType.equals((Object)MethodType.PURGE_DATASTREAM)) {
                PerformanceTests.this.runPurgeDatastream(PerformanceTests.this.PIDS[this.index], "MDS1");
            } else if (this.methodType.equals((Object)MethodType.PURGE_OBJECT)) {
                PerformanceTests.this.runPurgeObject(PerformanceTests.this.PIDS[this.index]);
            } else if (this.methodType.equals((Object)MethodType.GET_DATASTREAM)) {
                PerformanceTests.this.runGetDatastream(PerformanceTests.this.PIDS[this.index]);
            } else if (this.methodType.equals((Object)MethodType.GET_DATASTREAM_REST)) {
                PerformanceTests.this.runGetDatastreamRest(PerformanceTests.this.PIDS[this.index]);
            }
            return new Boolean(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MethodType {
        INGEST,
        ADD_DATASTREAM,
        MODIFY_DATASTREAM_REF,
        MODIFY_DATASTREAM_VAL,
        PURGE_DATASTREAM,
        PURGE_OBJECT,
        GET_DATASTREAM,
        GET_DATASTREAM_REST;

    }
}

